/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.DataSourceSapDBBase;
import com.sap.dbtech.jdbcext.XAConnectionSapDB;
import com.sap.dbtech.jdbcext.XATrace;
import com.sap.dbtech.jdbcext.XATransaction;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;

public class XADataSourceSapDB
extends DataSourceSapDBBase
implements XADataSource,
Referenceable {
    private XATrace xatrace;
    private boolean initialized = false;
    private Hashtable transactions = new Hashtable();
    private GarbageCollector garbagecollector = new GarbageCollector(1000);

    public XADataSourceSapDB() {
        this.garbagecollector.start();
    }

    public XAConnection getXAConnection() {
        Properties properties = (Properties)this.connectProperties.clone();
        if (!this.initialized) {
            this.createXATrace();
        }
        return new XAConnectionSapDB(properties, this, this.xatrace);
    }

    public XAConnection getXAConnection(String string, String string2) {
        Properties properties = (Properties)this.connectProperties.clone();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        if (!this.initialized) {
            this.createXATrace();
        }
        return new XAConnectionSapDB(properties, this, this.xatrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createXATrace() {
        block8: {
            try {
                String string = this.getXATrace();
                if (string == null) {
                    return;
                }
                PrintWriter printWriter = this.getLogWriter();
                if (printWriter != null && string.equalsIgnoreCase("true")) {
                    this.xatrace = new XATrace(printWriter);
                }
                if (printWriter != null) break block8;
                try {
                    this.xatrace = new XATrace(string);
                }
                catch (IOException iOException) {
                    this.initialized = true;
                    return;
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    XATransaction getXATransaction(Xid xid) {
        return (XATransaction)this.transactions.get(xid);
    }

    void addXATransaction(XATransaction xATransaction) {
        this.transactions.put(xATransaction.xid, xATransaction);
    }

    void removeXATransaction(Xid xid) {
        this.transactions.remove(xid);
    }

    Xid[] getAllPrepared() {
        Vector<Xid> vector = new Vector<Xid>();
        Enumeration enumeration = this.transactions.elements();
        while (enumeration.hasMoreElements()) {
            XATransaction xATransaction = (XATransaction)enumeration.nextElement();
            if (xATransaction.getStatus() != 3) continue;
            vector.add(xATransaction.xid);
        }
        return vector.toArray(new Xid[vector.size()]);
    }

    private Object outer() {
        return this;
    }

    public Reference getReference() throws NamingException {
        return this.createReference(this.getClass().getName());
    }

    class GarbageCollector
    extends Thread {
        ArrayList toBeRolledBack = new ArrayList();
        ArrayList toBeRemoved = new ArrayList();
        int delay;

        GarbageCollector(int n) {
            super("SAPDB XA Timeout Manager " + XADataSourceSapDB.this.outer().hashCode());
            this.delay = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: while (true) {
                Object object;
                Iterator iterator;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.toBeRemoved.clear();
                this.toBeRolledBack.clear();
                Iterator iterator2 = XADataSourceSapDB.this.outer();
                synchronized (iterator2) {
                    iterator = XADataSourceSapDB.this.transactions.elements();
                    long l = System.currentTimeMillis();
                    while (iterator.hasMoreElements()) {
                        XATransaction xATransaction = (XATransaction)iterator.nextElement();
                        if (xATransaction.getStatus() == 2) {
                            this.toBeRemoved.add(xATransaction.xid);
                            continue;
                        }
                        if (xATransaction.timeOutTime >= l) continue;
                        this.toBeRolledBack.add(xATransaction.xid);
                    }
                }
                iterator2 = this.toBeRolledBack.iterator();
                while (iterator2.hasNext()) {
                    iterator = (Xid)iterator2.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace((Xid)((Object)iterator), "rollback (timeout)");
                    }
                    Object object2 = XADataSourceSapDB.this.outer();
                    synchronized (object2) {
                        object = XADataSourceSapDB.this.getXATransaction((Xid)((Object)iterator));
                        if (object != null) {
                            try {
                                ((XATransaction)object).rollbackRelease();
                            }
                            catch (SQLException sQLException) {
                                try {
                                    ((XATransaction)object).physicalConnection.close();
                                }
                                catch (SQLException sQLException2) {
                                    // empty catch block
                                }
                                ((XATransaction)object).setStatus(2);
                            }
                        }
                    }
                }
                iterator = this.toBeRemoved.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block15;
                    Xid xid = (Xid)iterator.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace(xid, "forget (timeout)");
                    }
                    object = XADataSourceSapDB.this.outer();
                    synchronized (object) {
                        XADataSourceSapDB.this.removeXATransaction(xid);
                    }
                }
                break;
            }
        }
    }
}

