/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.PacketLayout;
import com.sap.dbtech.util.StructuredBytes;
import java.io.PrintStream;
import java.util.StringTokenizer;

class DbPacketLayout
implements PacketLayout {
    private int maxDataLength;
    private int maxSegmentSize;
    private int minReplySize;
    private int packetSize;
    private int portNumber;
    private boolean supportsChallengeResponse = false;
    public static final int safePacketSizeC = 0;

    DbPacketLayout() {
        this(0, 32768, 0, 0);
    }

    DbPacketLayout(int n, int n2, int n3, int n4) {
        this.maxDataLength = n;
        this.maxSegmentSize = n2;
        this.minReplySize = n3;
        this.packetSize = n4;
    }

    DbPacketLayout(StructuredBytes structuredBytes, boolean bl, boolean bl2) {
        this.getPacketLayoutFromReply(structuredBytes, bl, bl2);
    }

    public void dumpOn(PrintStream printStream, String string) {
        printStream.println("DbPacketLayout: " + string);
        printStream.println("    packetSize: " + this.packetSize);
        printStream.println("    maxSegmentSize: " + this.maxSegmentSize);
        printStream.println("    maxDataLength: " + this.maxDataLength);
        printStream.println("    minReplySize: " + this.minReplySize);
    }

    public int maxCmdDataLength() {
        return this.maxDataLength() - this.minReplySize();
    }

    public int maxDataLength() {
        return this.maxDataLength;
    }

    public int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int minReplySize() {
        return this.minReplySize;
    }

    public int packetSize() {
        return this.packetSize;
    }

    public boolean isChallengeResponseSupported() {
        return this.supportsChallengeResponse;
    }

    private void getPacketLayoutFromReply(StructuredBytes structuredBytes, boolean bl, boolean bl2) {
        this.maxDataLength = structuredBytes.getInt4(36);
        this.minReplySize = structuredBytes.getInt4(44);
        this.packetSize = structuredBytes.getInt4(40);
        this.maxSegmentSize = bl ? structuredBytes.getInt4(32) : this.packetSize;
        if (bl2) {
            this.parseVardataPart(structuredBytes);
        }
    }

    private void parseVardataPart(StructuredBytes structuredBytes) {
        byte by;
        boolean bl = false;
        int n = 64;
        int n2 = structuredBytes.bytes().length - n;
        block4: for (int i = n; i < n2 && (by = structuredBytes.getInt1(i)) > 0; i += by) {
            switch ((char)structuredBytes.getInt1(i + 1)) {
                case 'P': {
                    int n3 = structuredBytes.getInt1(i + 3);
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    this.portNumber = structuredBytes.getInt1(i + 2) * 256 + n3;
                    continue block4;
                }
                case 'a': {
                    String string = structuredBytes.getString(i + 2, by - 3);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        if (!stringTokenizer.nextToken().equals("SCRAMMD5")) continue;
                        this.supportsChallengeResponse = true;
                        continue block4;
                    }
                    continue block4;
                }
            }
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }
}

