/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;

public class SocketComm
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String string, String string2, Properties properties) throws RTEException {
            SocketComm socketComm = new SocketComm(string, properties);
            socketComm.connectDB(string2);
            return socketComm;
        }

        public JdbcCommunication xopen(String string, String string2, String string3, String string4, Properties properties) throws RTEException {
            SocketComm socketComm = new SocketComm(string, properties);
            socketComm.connectAdmin(string2, string3, string4);
            return socketComm;
        }
    };

    protected SocketComm(String string, Properties properties) throws RTEException {
        super(string, properties);
        this.openSocket();
    }

    protected void openSocket() throws RTEException {
        try {
            this.socket = new Socket(this.host, this.lookupPort());
            try {
                this.socket.setSoTimeout(this.socketTimeOut);
                this.socket.setTcpNoDelay(true);
                this.socket.setSendBufferSize(36864);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, unknownHostException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13]);
        }
        catch (IOException iOException) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, iOException.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5]);
        }
        try {
            this.socket.setSoLinger(true, 15);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SocketComm(this.host + ":" + this.port, null);
    }

    protected int getDefaultPort() {
        return 7210;
    }

    protected boolean socketMustClosedAfterInfoRequest() {
        return true;
    }
}

