#include <MyxSQLTreeItem.h>
#include <myx_public_interface.h>
#include <myx_grt_public_interface.h>
#include <myx_grt_builtin_module_public_interface.h>

#include "myx_grt_mysql.h"
#include "myx_sql_parser_public_interface.h"
#include "myx_grt_mysql_reveng_script_helper.h"

MYX_GRT_VALUE * add_schema(MYX_GRT_VALUE * schemata, HELPER_ARGS * args, 
                          const char *schema_name)
{
  MYX_GRT_VALUE *schema= myx_grt_dict_new_obj(args->grt, "db.mysql.Schema", schema_name, "", myx_grt_dict_item_get_as_string(args->catalog, "_id"));

  myx_grt_list_item_add(schemata, schema);
  myx_grt_value_release(schema);
  return schema;
}

void process_create_schema_statement(MyxSQLTreeItem *tree, HELPER_ARGS * args)
{
  MYX_GRT_VALUE *schemata= myx_grt_dict_item_get_value(args->catalog, "schemata");
  MyxCreateSchemaTreeItem helper(tree);
  add_schema(schemata, args, helper.get_schema_name());
}

MYX_GRT_VALUE * add_table(MYX_GRT_VALUE * schema_tables, HELPER_ARGS * args, 
                          const char *table_name, 
                          const char *table_engine, 
                          const char *row_format, 
                          const char *next_auto_inc, 
                          const char *def_collation,
                          const char *delay_key_write,
                          const char *comment, 
                          bool is_temp, 
                          const char *sql)
{
  MYX_GRT_VALUE *table= myx_grt_dict_new(args->grt, "db.mysql.Table");

  if(table_name != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "name", table_name);
  }
  if(table_engine != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "tableEngine", table_engine);
  }
  myx_grt_dict_item_set_value_from_int(table, "isTemporary", is_temp ? 1 : 0);
  if(sql != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "sql", sql);
  }
  if(row_format != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "rowFormat", row_format);
  }
  if(next_auto_inc != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "nextAutoInc", next_auto_inc);
  }
  if(def_collation != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "defaultCollationName", def_collation);
  }
  if(comment != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "comment", comment);
  }
  if(delay_key_write != NULL)
  {
    myx_grt_dict_item_set_value_from_string(table, "delayKeyWrite", delay_key_write);
  }
  myx_grt_list_item_add(schema_tables, table);
  myx_grt_value_release(table);
  return table;
}

MYX_GRT_VALUE * set_used_schema(HELPER_ARGS * args, const char *schema_name)
{
  MYX_GRT_VALUE *schemata= myx_grt_dict_item_get_value(args->catalog, "schemata");
  MYX_GRT_VALUE *schema= myx_grt_dict_new_obj(args->grt, "db.mysql.Schema", schema_name, "", myx_grt_dict_item_get_as_string(args->catalog, "_id"));
  if(schema == NULL)
  {
    schema= add_schema(schemata, args, schema_name);
  }
  args->used_schema= schema;
  return schema;
}

void process_create_table_statement(MyxSQLTreeItem *tree, HELPER_ARGS * args)
{
  MYX_GRT_VALUE *prev_schema= args->used_schema;
  MyxCreateTableTreeItem helper(tree);

  if(helper.get_schema_name() != NULL)
  {
    set_used_schema(args, helper.get_schema_name());  // this will add schema to schemata if nesessary
  }
  
  MYX_GRT_VALUE *schema_tables= myx_grt_dict_item_get_value(args->used_schema, "tables");
  add_table(schema_tables, args, helper.get_table_name(), helper.get_table_engine(), helper.get_row_format(), helper.get_next_auto_inc(),
    helper.get_def_collation(), helper.get_delay_key_write(), helper.get_comment(), helper.is_temporary(), args->sql);
  
  args->used_schema= prev_schema;
}

void process_use_statement(MyxSQLTreeItem *tree, HELPER_ARGS * args)
{
  MyxUseSchemaTreeItem helper(tree);
  set_used_schema(args, helper.get_schema_name()); 
}

extern "C" void convert_parser_dom_to_grt_dom(void *parser_dom_tree, HELPER_ARGS * args)
{
  //MYX_GRT_VALUE * catalog= args->catalog;
  //MYX_GRT * grt= args->grt;
  
  MyxSQLTreeItem *tree = static_cast<MyxSQLTreeItem *>(parser_dom_tree);

  if(MyxCreateSchemaTreeItem::check(tree)) 
  {
    process_create_schema_statement(tree, args);
  }
  else if(MyxCreateTableTreeItem::check(tree)) 
  {
    process_create_table_statement(tree, args);
  }
  else if(MyxUseSchemaTreeItem::check(tree)) 
  {
    process_use_statement(tree, args);
  }
}