.\"
.\"@(#)nfsidmap(8) - The NFS idmapper upcall program
.\"
.\" Copyright (C) 2010 Bryan Schumaker <bjschuma@netapp.com>
.TH nfsidmap 5 "1 October 2010"
.SH NAME
nfsidmap \- The NFS idmapper upcall program
.SH DESCRIPTION
The file
.I /usr/sbin/nfsidmap
is used by the NFS idmapper to translate user and group ids into names, and to
translate user and group names into ids. Idmapper uses request-key to perform
the upcall and cache the result.
.I /usr/sbin/nfsidmap
should only be called by request-key, and will perform the translation and
initialize a key with the resulting information.
.PP
NFS_USE_NEW_IDMAPPER must be selected when configuring the kernel to use this
feature.
.SH CONFIGURING
The file
.I /etc/request-key.conf
will need to be modified so
.I /sbin/request-key
can properly direct the upcall. The following line should be added before a call
to keyctl negate:
.PP
create	id_resolver	*	*	/usr/sbin/nfsidmap %k %d 600
.PP
This will direct all id_resolver requests to the program
.I /usr/sbin/nfsidmap
The last parameter, 600, defines how many seconds into the future the key will
expire.  This is an optional parameter for
.I /usr/sbin/nfsidmap
and will default to 600 seconds when not specified.
.PP
The idmapper system uses four key descriptions:
.PP
	  uid: Find the UID for the given user
.br
	  gid: Find the GID for the given group
.br
	 user: Find the user name for the given UID
.br
	group: Find the group name for the given GID
.PP
You can choose to handle any of these individually, rather than using the
generic upcall program.  If you would like to use your own program for a uid
lookup then you would edit your request-key.conf so it looks similar to this:
.PP
create	id_resolver	uid:*	*	/some/other/program %k %d 600
.br
create	id_resolver	*		*	/usr/sbin/nfsidmap %k %d 600
.PP
Notice that the new line was added above the line for the generic program.
request-key will find the first matching line and run the corresponding program.
In this case, /some/other/program will handle all uid lookups, and
/usr/sbin/nfsidmap will handle gid, user, and group lookups.
.SH AUTHOR
Bryan Schumaker, <bjschuma@netapp.com>
