/*=========================================================================
| Open Office QuickStarter
|--------------------------------------------------------------------------
| (c) 2002  Kumaran Santhanam  <kumaran@alumni.stanford.org>
|
| This project is released under the GNU General Public License.
| Please see the file COPYING for more details.
|--------------------------------------------------------------------------
| console.cxx
|
| This file contains a command-line driver for the application.
| In practice, this is only used to test the Model.  Normally,
| an end-user would use either the Gnome or KDE front-end.
 ========================================================================*/

/*=========================================================================
| INCLUDES
 ========================================================================*/
#include <stdio.h>
#include <unistd.h>
#include "model.h"


/*=========================================================================
| MAIN PROGRAM
 ========================================================================*/
int main (int argc, char **argv) {
    if (argc != 2) {
        printf("usage: ooqstart OPENOFFICE_BASE_DIR\n");
        return 1;
    }
    
    Model model;
    model.setOpenOfficeDir(argv[1]);
    if (!model.isValid()) {
        printf("error: Open Office executable not found in %s\n", argv[1]);
        return 1;
    }
    
    // Execute an infinite loop, processing the model every 250ms.
    model.enable();
    for (int i = 0; ; ++i) {
        model.process();
        switch (model.getStatus()) {
          case MODEL_OFFICE_STOPPED:   printf("%d: stopped\n",  i); break;
          case MODEL_OFFICE_RUNNING:   printf("%d: running\n",  i); break;
          case MODEL_OFFICE_STARTING:  printf("%d: starting\n", i); break;
          default:  printf("%d: -- null --\n", i);
        }
        usleep(250000);
    }
}
