/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>

#include <saml/saml.h>

using namespace saml;
using namespace std;

class SAMLSOAPHTTPBindingTest : public CxxTest::TestSuite, public SAMLSOAPHTTPBinding::HTTPHook
{
public:
    XMLCh *endpoint,*name,*format,*qualifier,*resource;

    void setUp() {
        endpoint = XMLString::transcode("https://wayf.internet2.edu:8443/shibboleth-idp/AA");
        name = XMLString::transcode("test-handle");
        format = XMLString::transcode("urn:mace:shibboleth:test:nameIdentifier");
        qualifier = XMLString::transcode("urn:mace:inqueue:example.edu");
        resource = XMLString::transcode("http://www.foo.com/");
        
        auto_ptr_XMLCh ns("urn:mace:shibboleth:1.0");
        auto_ptr_XMLCh id("shibboleth.xsd");
        XML::registerSchema(ns.get(),id.get());
    }

    void tearDown() {
        XMLString::release(&endpoint);
        XMLString::release(&name);
        XMLString::release(&format);
        XMLString::release(&qualifier);
        XMLString::release(&resource);
    }
    
    void testSOAPBinding(void) {
        TS_TRACE("testing SAML SOAP/HTTP binding");

        auto_ptr<SAMLRequest> r(
            new SAMLRequest(
                new SAMLAttributeQuery(
                    new SAMLSubject(new SAMLNameIdentifier(name,qualifier,format)),
                    resource
                )
            )
        );

        auto_ptr<SAMLSOAPHTTPBinding> b(dynamic_cast<SAMLSOAPHTTPBinding*>(SAMLBinding::getInstance(SAMLSOAPBinding::SOAP)));
        TS_ASSERT(b.get());
        b->addHook(this);
        SAMLResponse* r2 = b->send(endpoint,*r.get());
        TS_ASSERT_EQUALS(r2->getAssertions().size(),1);
        TS_ASSERT_EQUALS(r2->getAssertions().next()->getStatements().size(),1);
        TS_ASSERT_LESS_THAN(0,dynamic_cast<SAMLAttributeStatement*>(r2->getAssertions().next()->getStatements().next())->getAttributes().size());
        delete r2;
    }
    
    virtual bool incoming(HTTPClient* conn, void* globalCtx=NULL, void* callCtx=NULL) {
        Iterator<string> i=conn->getResponseHeader("Content-type");
        TS_ASSERT(i.hasNext());
        TS_ASSERT_SAME_DATA("text/xml",i.next().data(),8);
        return true;
    }
};
