/* $Cambridge: hermes/src/prayer/lib/memblock.h,v 1.2 2008/05/19 15:55:56 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Data structures for variable length string */

struct memblock {
    struct pool *pool;          /* Allocation pool for parent structure */
    void *block;                /* malloced block for data */
    unsigned long bsize;        /* Block size */
    unsigned long size;         /* Size of live data in block */
};


struct memblock *memblock_create(struct pool *p,
                                 unsigned long initial_size);

void memblock_free(struct memblock *m);

void memblock_resize(struct memblock *m, unsigned long size);

char *memblock_string(struct memblock *m);

void *memblock_data(struct memblock *m);

unsigned long memblock_size(struct memblock *m);

char *memblock_strdup(struct memblock *m, char *s);

void memblock_strcpy(struct memblock *m, char *s);

void memblock_puts(struct memblock *m, char *s);

unsigned long
memblock_vprintf_size(struct memblock *m, char *fmt, va_list ap);

void memblock_vprintf(struct memblock *m, char *fmt, va_list ap);

void memblock_printf(struct memblock *m, char *fmt, ...);

#define mprintf memblock_printf
#define mputs   memblock_puts
