/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_eventlog.h"

NTSTATUS rpccli_eventlog_ClearEventLogW(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct lsa_String *backupfile /* [in] [unique] */)
{
	struct eventlog_ClearEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.backupfile = backupfile;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLEAREVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_BackupEventLogW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 struct lsa_String *backup_filename /* [in] [ref] */)
{
	struct eventlog_BackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.backup_filename = backup_filename;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_BACKUPEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_CloseEventLog(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in,out] [ref] */)
{
	struct eventlog_CloseEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_CloseEventLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLOSEEVENTLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_CloseEventLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_DeregisterEventSource(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in,out] [ref] */)
{
	struct eventlog_DeregisterEventSource r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterEventSource, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_DEREGISTEREVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterEventSource, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_GetNumRecords(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       uint32_t *number /* [out] [ref] */)
{
	struct eventlog_GetNumRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetNumRecords, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETNUMRECORDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetNumRecords, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*number = *r.out.number;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_GetOldestRecord(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t *oldest_entry /* [out] [ref] */)
{
	struct eventlog_GetOldestRecord r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetOldestRecord, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETOLDESTRECORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetOldestRecord, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*oldest_entry = *r.out.oldest_entry;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ChangeNotify(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct eventlog_ChangeNotify r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ChangeNotify, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CHANGENOTIFY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ChangeNotify, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_OpenEventLogW(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
				       struct lsa_String *logname /* [in] [ref] */,
				       struct lsa_String *servername /* [in] [ref] */,
				       uint32_t major_version /* [in]  */,
				       uint32_t minor_version /* [in]  */,
				       struct policy_handle *handle /* [out] [ref] */)
{
	struct eventlog_OpenEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.logname = logname;
	r.in.servername = servername;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_RegisterEventSourceW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
					      struct lsa_String *module_name /* [in] [ref] */,
					      struct lsa_String *reg_module_name /* [in] [ref] */,
					      uint32_t major_version /* [in]  */,
					      uint32_t minor_version /* [in]  */,
					      struct policy_handle *log_handle /* [out] [ref] */)
{
	struct eventlog_RegisterEventSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.module_name = module_name;
	r.in.reg_module_name = reg_module_name;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTEREVENTSOURCEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*log_handle = *r.out.log_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
					     struct lsa_String *backup_logname /* [in] [ref] */,
					     uint32_t major_version /* [in]  */,
					     uint32_t minor_version /* [in]  */,
					     struct policy_handle *handle /* [out] [ref] */)
{
	struct eventlog_OpenBackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.backup_logname = backup_logname;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENBACKUPEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ReadEventLogW(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       uint32_t flags /* [in]  */,
				       uint32_t offset /* [in]  */,
				       uint32_t number_of_bytes /* [in] [range(0,0x7FFFF)] */,
				       uint8_t *data /* [out] [ref,size_is(number_of_bytes)] */,
				       uint32_t *sent_size /* [out] [ref] */,
				       uint32_t *real_size /* [out] [ref] */)
{
	struct eventlog_ReadEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.flags = flags;
	r.in.offset = offset;
	r.in.number_of_bytes = number_of_bytes;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_READEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(data, r.out.data, (r.in.number_of_bytes) * sizeof(*data));
	*sent_size = *r.out.sent_size;
	*real_size = *r.out.real_size;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ReportEventW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      time_t timestamp /* [in]  */,
				      enum eventlogEventTypes event_type /* [in]  */,
				      uint16_t event_category /* [in]  */,
				      uint32_t event_id /* [in]  */,
				      uint16_t num_of_strings /* [in] [range(0,256)] */,
				      uint32_t data_size /* [in] [range(0,0x3FFFF)] */,
				      struct lsa_String *servername /* [in] [ref] */,
				      struct dom_sid *user_sid /* [in] [unique] */,
				      struct lsa_String **strings /* [in] [unique,size_is(num_of_strings)] */,
				      uint8_t *data /* [in] [unique,size_is(data_size)] */,
				      uint16_t flags /* [in]  */,
				      uint32_t *record_number /* [in,out] [unique] */,
				      time_t *time_written /* [in,out] [unique] */)
{
	struct eventlog_ReportEventW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.timestamp = timestamp;
	r.in.event_type = event_type;
	r.in.event_category = event_category;
	r.in.event_id = event_id;
	r.in.num_of_strings = num_of_strings;
	r.in.data_size = data_size;
	r.in.servername = servername;
	r.in.user_sid = user_sid;
	r.in.strings = strings;
	r.in.data = data;
	r.in.flags = flags;
	r.in.record_number = record_number;
	r.in.time_written = time_written;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (record_number && r.out.record_number) {
		*record_number = *r.out.record_number;
	}
	if (time_written && r.out.time_written) {
		*time_written = *r.out.time_written;
	}

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ClearEventLogA(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct eventlog_ClearEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLEAREVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_BackupEventLogA(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx)
{
	struct eventlog_BackupEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_BACKUPEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_OpenEventLogA(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct eventlog_OpenEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_RegisterEventSourceA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx)
{
	struct eventlog_RegisterEventSourceA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTEREVENTSOURCEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogA(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx)
{
	struct eventlog_OpenBackupEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENBACKUPEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ReadEventLogA(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct eventlog_ReadEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_READEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ReportEventA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct eventlog_ReportEventA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_RegisterClusterSvc(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx)
{
	struct eventlog_RegisterClusterSvc r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterClusterSvc, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTERCLUSTERSVC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterClusterSvc, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_DeregisterClusterSvc(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx)
{
	struct eventlog_DeregisterClusterSvc r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterClusterSvc, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_DEREGISTERCLUSTERSVC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterClusterSvc, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_WriteClusterEvents(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx)
{
	struct eventlog_WriteClusterEvents r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_WriteClusterEvents, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_WRITECLUSTEREVENTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_WriteClusterEvents, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_GetLogInformation(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t level /* [in]  */,
					   uint8_t *buffer /* [out] [ref,size_is(buf_size)] */,
					   uint32_t buf_size /* [in] [range(0,1024)] */,
					   uint32_t *bytes_needed /* [out] [ref] */)
{
	struct eventlog_GetLogInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetLogInformation, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETLOGINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetLogInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(buffer, r.out.buffer, (r.in.buf_size) * sizeof(*buffer));
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_FlushEventLog(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */)
{
	struct eventlog_FlushEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_FlushEventLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_FLUSHEVENTLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_FlushEventLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_eventlog_ReportEventAndSourceW(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       time_t timestamp /* [in]  */,
					       enum eventlogEventTypes event_type /* [in]  */,
					       uint16_t event_category /* [in]  */,
					       uint32_t event_id /* [in]  */,
					       struct lsa_String *sourcename /* [in] [ref] */,
					       uint16_t num_of_strings /* [in] [range(0,256)] */,
					       uint32_t data_size /* [in] [range(0,0x3FFFF)] */,
					       struct lsa_String *servername /* [in] [ref] */,
					       struct dom_sid *user_sid /* [in] [unique] */,
					       struct lsa_String **strings /* [in] [unique,size_is(num_of_strings)] */,
					       uint8_t *data /* [in] [unique,size_is(data_size)] */,
					       uint16_t flags /* [in]  */,
					       uint32_t *record_number /* [in,out] [unique] */,
					       time_t *time_written /* [in,out] [unique] */)
{
	struct eventlog_ReportEventAndSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.timestamp = timestamp;
	r.in.event_type = event_type;
	r.in.event_category = event_category;
	r.in.event_id = event_id;
	r.in.sourcename = sourcename;
	r.in.num_of_strings = num_of_strings;
	r.in.data_size = data_size;
	r.in.servername = servername;
	r.in.user_sid = user_sid;
	r.in.strings = strings;
	r.in.data = data;
	r.in.flags = flags;
	r.in.record_number = record_number;
	r.in.time_written = time_written;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventAndSourceW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTANDSOURCEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventAndSourceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (record_number && r.out.record_number) {
		*record_number = *r.out.record_number;
	}
	if (time_written && r.out.time_written) {
		*time_written = *r.out.time_written;
	}

	/* Return result */
	return r.out.result;
}

