#ifndef EXPORTS_H
#define EXPORTS_H

#include <qdir.h>
#include <qstring.h>
#include <iostream>

#include "mapcenterobj.h"
#include "settings.h"

///////////////////////////////////////////////////////////////////////

class ExportBase
{
public:
	ExportBase();
	virtual ~ExportBase();
	virtual void setDir(const QString &);
	virtual void setFile(const QString &);
	virtual void setMapCenter (MapCenterObj*);
	virtual void setCaption(const QString &);
	virtual void addFilter (const QString &);
	virtual bool execDialog();
protected:  
	virtual QString getSectionString (BranchObj*);

	QDir tmpDir;
	QString outputDir;
	QString outputFile;
	MapCenterObj *mapCenter;
	QString	indentPerDepth;
	QString caption;
	QString filter;
};

///////////////////////////////////////////////////////////////////////
class ExportASCII:public ExportBase
{
public:
	virtual void doExport();
};

///////////////////////////////////////////////////////////////////////
class ExportXMLBase:public ExportBase
{
};

///////////////////////////////////////////////////////////////////////
class ExportKDEBookmarks:public ExportXMLBase
{
public:
	virtual void doExport();
};	

///////////////////////////////////////////////////////////////////////
class ExportFirefoxBookmarks:public ExportXMLBase
{
public:
	virtual void doExport();
};	

///////////////////////////////////////////////////////////////////////
class ExportTaskjuggler:public ExportXMLBase
{
public:
	virtual void doExport();
};	

///////////////////////////////////////////////////////////////////////
class ExportLaTeX:public ExportBase
{
public:
	virtual void doExport();
};	

///////////////////////////////////////////////////////////////////////
class ExportOO:public ExportBase
{
public:
	ExportOO();
	~ExportOO();
	void exportPresentation();
	bool setConfigFile (const QString &);
private:
	QString buildList (BranchObj*);
	bool useSections;
	QString configFile;
	QString configDir;
	QString templateDir;
	QString content;
	QString contentTemplate;
	QString contentTemplateFile;
	QString contentFile;
	QString pageTemplate;
	QString pageTemplateFile;
	QString sectionTemplate;
	QString sectionTemplateFile;
};
#endif
