# -*- coding: iso-8859-1 -*-

# =============================================================================
#  autoauth.py (c) October 2005 by Kolter <kolter@free.fr>
#  Python script for WeeChat.
#
#  Licence     : GPL v2
#  Description : Permits to auto-authenticate when changing nick
#  Syntax      : try /auth help to get help on this script
#
#
# ### changelog ###
#
#  * version 0.4
#      - use set_plugin_config and get_plugin_config to read ans save settings
#      - remove deprecated import
#  * version 0.3
#      - add return codes
#  * version 0.2
#      - correct weechatdir with weechat_dir while using weechat.get_info
#  * version 0.1 :
#      - first release
#
# =============================================================================


VERSION="0.4"
NAME="autoauth"

import weechat

weechat.register (NAME, VERSION, "auth_write", "Auto authentification when changing nick")
weechat.add_message_handler("NOTICE", "auth_notice_check")
weechat.add_command_handler("auth", "auth_command")

def auth_help():
    weechat.prnt("")
    weechat.prnt("-[ %s ]- (help)" % (NAME))
    weechat.prnt("")
    weechat.prnt(" Usage : ")
    weechat.prnt("    /auth help :")
    weechat.prnt("        -> display this help")
    weechat.prnt("    /auth add %nick% %pass% [%server% = current server]")
    weechat.prnt("        -> add authorization for nick %nick% with password %pass% for server %server% ")
    weechat.prnt("    /auth del %nick% [%server% = current server]")
    weechat.prnt("        -> del authorization for nick %nick% for server %server%")
    weechat.prnt("    /auth list")
    weechat.prnt("        -> list all authorization settings")
    weechat.prnt("")
    return weechat.PLUGIN_RC_OK

def auth_list():
    global AUTH_DATA

    if AUTH_DATA == {}:
        weechat.prnt("-%s- (list)" % (NAME))
    else:
        weechat.prnt("-%s- (list)" % (NAME))
    for srv in AUTH_DATA:
        weechat.prnt(" -> server %s :" % srv)
        for nick in AUTH_DATA[srv]:
            weechat.prnt("    --> nick : %s , pass : *****" % nick)
    
    return weechat.PLUGIN_RC_OK

def auth_add(nick, passwd, server):
    global AUTH_DATA

    if not AUTH_DATA.has_key(server):
        AUTH_DATA[server] = {}

    AUTH_DATA[server][nick] = passwd
    weechat.prnt("-%s- nick '%s@%s' successfully added" % (NAME, nick, server))
    return weechat.PLUGIN_RC_OK

def auth_del(nick, server):
    global AUTH_DATA
    done = False

    if AUTH_DATA.has_key(server):
        if AUTH_DATA[server].has_key(nick):
            del AUTH_DATA[server][nick]
            done=True
            if AUTH_DATA[server] == {}:
                del AUTH_DATA[server]
    if done:
        weechat.prnt("-%s- nick '%s@%s' successfully remove" % (NAME, nick, server))
    else:
        weechat.prnt("-%s- an error occured while removing nick '%s@%s' (not found)" % (NAME, nick, server))
    return weechat.PLUGIN_RC_OK

def auth_auto(server):
    global AUTH_DATA

    if AUTH_DATA.has_key(server):
        if AUTH_DATA[server].has_key(weechat.get_info("nick")):
            weechat.command("/quote nickserv identify %s" % (AUTH_DATA[server][weechat.get_info("nick")]))
    return weechat.PLUGIN_RC_OK

def auth_notice_check(server, args):
    if args.find("If this is your nickname, type /msg NickServ") != -1:
        auth_auto(server)
    return weechat.PLUGIN_RC_OK

def auth_read():
    data = weechat.get_plugin_config("data")

    for e in data.split(","):
        (serv_nick, passwd) = e.split("=")
        (server, nick) = serv_nick.split(".")
        auth_add(nick, passwd, server)

    return weechat.PLUGIN_RC_OK

def auth_write(server, args):
    global AUTH_DATA

    data = []                                  
    for s in AUTH_DATA:            
        for n in AUTH_DATA[s]:
            data.append("%s.%s=%s" % (s, n, AUTH_DATA[s][n]))

    strdata = ",".join(data)
    if strdata != "":
        weechat.set_plugin_config("data", strdata)

    return weechat.PLUGIN_RC_OK
        
def auth_command(server, args):
    list_args = args.split(" ")
    
    #strip spaces
    while '' in list_args:
        list_args.remove('')
    while ' ' in list_args:
        list_args.remove(' ')

    if len(list_args) ==  0:
        auth_help()
    elif list_args[0] == "help":
        auth_help()
    elif list_args[0] not in ["add", "del", "list"]:
        weechat.prnt("-%s- bad option while using /auth command, try /auth help for more info" % (NAME))
    elif list_args[0] == "list":
        auth_list()
    elif list_args[0] == "add":
        if len(list_args) < 3:
            weechat.prnt("-%s- bad option while using /auth command, try /auth help for more info" % (NAME))
        else:
            if len(list_args) == 3:
                auth_add(list_args[1], list_args[2], weechat.get_info("server"))
            else:
                auth_add(list_args[1], list_args[2], list_args[3])
    elif list_args[0] == "del":
       if len(list_args) < 2:
           weechat.prnt("-%s- bad option while using /auth command, try /auth help for more info" % (NAME))
       else:
            if len(list_args) == 2:
                auth_del(list_args[1], weechat.get_info("server"))
            else:
                auth_del(list_args[1], list_args[2])
    else:
        pass
    return weechat.PLUGIN_RC_OK

AUTH_DATA={}
auth_read()

