/*
 $Id: BlockScope.java,v 1.4 2004/07/10 03:31:39 bran Exp $

 Copyright 2003 (C) James Strachan and Bob Mcwhirter. All Rights Reserved.

 Redistribution and use of this software and associated documentation
 ("Software"), with or without modification, are permitted provided
 that the following conditions are met:

 1. Redistributions of source code must retain copyright
    statements and notices.  Redistributions must also contain a
    copy of this document.

 2. Redistributions in binary form must reproduce the
    above copyright notice, this list of conditions and the
    following disclaimer in the documentation and/or other
    materials provided with the distribution.

 3. The name "groovy" must not be used to endorse or promote
    products derived from this Software without prior written
    permission of The Codehaus.  For written permission,
    please contact info@codehaus.org.

 4. Products derived from this Software may not be called "groovy"
    nor may "groovy" appear in their names without prior written
    permission of The Codehaus. "groovy" is a registered
    trademark of The Codehaus.

 5. Due credit should be given to The Codehaus -
    http://groovy.codehaus.org/

 THIS SOFTWARE IS PROVIDED BY THE CODEHAUS AND CONTRIBUTORS
 ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 THE CODEHAUS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

 */
package org.codehaus.groovy.classgen;

import org.objectweb.asm.Label;

/**
 * A helper class to help maintain a stack of scopes for labels etc
 * 
 * @author <a href="mailto:james@coredevelopers.net">James Strachan</a>
 * @version $Revision: 1.4 $
 */
public class BlockScope {


    // new scopes for methods do not have continue and break labels
    // for, while, dowhile need to explicitly set the lables
	// switch can break but not continue
    private Label breakLabel = null; //new Label();
    private Label continueLabel = null; //new Label();
    private BlockScope parent;
    private int firstVariableIndex = 0;
    
    public BlockScope(BlockScope parent) {
        this.parent = parent;
    }
    
    public Label getContinueLabel() {
        return continueLabel;
    }

    public void setContinueLabel(Label continueLabel) {
        this.continueLabel = continueLabel;
    }

    public Label getBreakLabel() {
        return breakLabel;
    }

    public void setBreakLabel(Label breakLabel) {
            this.breakLabel = breakLabel;
        }

    public BlockScope getParent() {
        return parent;
    }

    public int getFirstVariableIndex() {
        return firstVariableIndex;
    }

    public void setFirstVariableIndex(int firstVariableIndex) {
        this.firstVariableIndex = firstVariableIndex;
    }

    /**
     *
     * @param firstVariableIndex
     * @deprecated
     */
    public void setLastVariableIndex(int firstVariableIndex) {
        this.firstVariableIndex = firstVariableIndex;
    }

    public int getLastVariableIndex() {
        return firstVariableIndex;
    }

}
