#! /usr/bin/env python
# Part of the A-A-P recipe executive: Separate program that runs under root

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

# This programs runs as root to be able to install a package
# Stdin and stdout should be piped by popenerr.py.

import sys
import os

from Util import *


if __name__ == '__main__':
    # Print a message so that the invoking process knows we're ready for
    # commands.
    print "RootShell ready"
    sys.stdout.flush()

    # We have been started by "popenerr", need to fix stdin.
    os.close(0)
    n = os.dup(2)
    if n <> 0:
        print 'RootShell: bad stdin dup: %d\n' % n
    # Duplicate stderr from stdout, so that the other side only needs to read
    # one stream.
    os.close(2)
    n = os.dup(1)
    if n <> 2:
        print 'RootShell: bad stderr dup: %d\n' % n

    # Internationalisation inits: setlocale and gettext.
    i18n_init()

    # Loop until there is nothing to be read or the quit command is received.
    while 1:
        cmd = sys.stdin.readline()
        if not cmd:
            sys.exit(1)
        if cmd[-1] == '\n':
            cmd = cmd[:-1]
        if cmd[0] == 'C':
            try:
                os.chdir(cmd[1:])
            except:
                print "RootShell: Cannot change directory to '%s'" % cmd[1:]
        elif cmd[0] == 'X':
            try:
                res = os.system(cmd[1:])
            except:
                res = 1
            if res:
                print "RootShell: Command failed"
            else:
                print "RootShell: OK"
            sys.stdout.flush()
        elif cmd[0] == 'Q':
            sys.exit(0)
        else:
            print 'RootShell: error: unrecognized command: "%s"' % cmd


# vim: set sw=4 et sts=4 tw=79 fo+=l:
