# Part of the A-A-P recipe executive: Testing of user scopes

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import sys, os, stat, shutil, string

def runaap(args):
    res = os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))
    if res:
        print "Aap exited with error value %d" % res
    return res

os.chdir("rectest")

# Create a recipe to test whether the recipe scope is passed to build commands
# and reading a local variable before it is written results in a warning.

rec1 = "rectest1.aap"
rec2 = "rectest2.aap"
aapout = "rectest.aap.out"

def cleanup():
    for n in [ rec1, rec2, aapout ]:
        try:
            os.remove(n)
        except:
            pass

cleanup()

f = open(rec1, "w")
f.write("""
var1 = toplevel
sc1.var1 = scope1
@try:
    var1.test = some
@except:
    :print correctly caught scope error
:child %s
:print from child: $sc2.var1

@try:
    :print $sc1
@except:
    :print correctly caught scope used as var

all:
        sc3.var1 = all
        :update some
        :print all: $sc4.var1
""" % (rec2))
f.close()

# Included recipe.
f = open(rec2, "w")
f.write("""
sc2.var1 = child
:print child: $var1 $sc1.var1
some {virtual}:
        :print some: $var1 $sc1.var1 $sc2.var1 $sc3.var1
        sc4.var1 = some
""")
f.close()

def check_contents(fname, expected):
    f = open(fname)
    actual = f.read()
    f.close()
    if actual != expected:
	print ('File contents wrong for "%s":\n%s\n--- instead of ---\n%s\n---'
						   % (fname, actual, expected))
        return 1
    return 0

# The first time running should result in two files being copied.
res = runaap("-f %s > %s" % (rec1, aapout))

failed = res + check_contents(aapout,
"""correctly caught scope error
child: toplevel scope1
from child: child
correctly caught scope used as var
some: toplevel scope1 child all
all: some
""")

cleanup()

sys.exit(failed)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
