// -*- C++ -*-

//=============================================================================
/**
 *  @file     UIPMC_Message_Block_Data_Iterator.h
 *
 *  UIPMC_Message_Block_Data_Iterator.h,v 1.2 2004/01/09 11:58:48 jwillemsen Exp
 *
 *  @author Frank Hunleth <frank@hunleth.com>
 */
//=============================================================================

#ifndef TAO_UIPMC_MESSAGE_BLOCK_DATA_ITERATOR_H
#define TAO_UIPMC_MESSAGE_BLOCK_DATA_ITERATOR_H
#include /**/ "ace/pre.h"

#include "ace/os_include/sys/os_uio.h"
#include "ace/os_include/os_stddef.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

/**
 * @class UIPMC_Message_Block_Data_Iterator
 *
 * @brief This is a help class for iterating through ACE_Message_Blocks and to
 *        segment them into MIOP packets.
 */
class UIPMC_Message_Block_Data_Iterator
{
public:
  /// Constructor
  UIPMC_Message_Block_Data_Iterator (iovec *iov, int iovcnt);

  /// Get the next data block that has a size less than or equal
  /// to max_length.  Return the length of the block returned.
  size_t next_block (size_t max_length,
                     iovec &block);

private:
  enum State
  {
    INTER_BLOCK,
    INTRA_BLOCK
  };

  iovec *iov_;
  int iovcnt_;

  // Point internal to a message block, if we have to split one up.
  char *iov_ptr_;
  int iov_index_;

  // Length used in a split message block.
  size_t iov_len_left_;

  // Current message iterator state.
  State state_;

};

#include /**/ "ace/post.h"
#endif  /* TAO_UIPMC_MESSAGE_BLOCK_DATA_ITERATOR_H */
