// ulonglong.h,v 1.9 2002/01/29 20:21:09 okellogg Exp

// ============================================================================
//
// = LIBRARY
//    TAO/tests/Param_Test
//
// = FILENAME
//    ulonglong.h
//
// = DESCRIPTION
//     Tests 64bit unsigned longs.
//
// = AUTHORS
//      Aniruddha Gokhale
//
// ============================================================================

#ifndef PARAM_TEST_ULONGLONG_H
#define PARAM_TEST_ULONGLONG_H

#include "param_testC.h"

class Test_ULongLong
{
public:
  Test_ULongLong (void);
  // ctor

  ~Test_ULongLong (void);
  // dtor

  int run_sii_test (Param_Test_ptr objref
                    ACE_ENV_ARG_DECL);
  // run the SII test

  const char *opname (void) const;
  // return operation name

  int init_parameters (Param_Test_ptr objref
                       ACE_ENV_ARG_DECL);
  // set values for parameters

  int reset_parameters (void);
  // reset values for CORBA

  CORBA::Boolean check_validity (void);
  // check if results are valid

  CORBA::Boolean check_validity (CORBA::Request_ptr req);
  // check if results are valid. This is used for DII results

  void print_values (void);
  // print all the values

  void dii_req_invoke (CORBA::Request * ACE_ENV_ARG_DECL_NOT_USED);
  // invoke DII request with appropriate exception handling.

private:
  char *opname_;
  // operation name

  CORBA::ULongLong in_;
  // in parameter

  CORBA::ULongLong inout_;
  // inout parameter

  CORBA::ULongLong out_;
  // out parameter

  CORBA::ULongLong ret_;
  // return value
};

#endif /* PARAM_TEST_ULONGLONG_H */
