#ifndef _MOBILE_H
#define _MOBILE_H

#include "strings.h"
#include "individual.h"
#include "builder.h"
#include "shop.h"

struct Com_List {
   Strings  the_keywords;
   Strings  the_reply;
   Com_List *next_com;
};


class Mobile : public Individual
{
public:

   Mobile(char *the_name, char *the_area);
   virtual ~Mobile();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   bool can_see_ind(Individual *the_ind);

   int      set_brief(char *the_brief);
   char     *get_brief(void);
   int      set_speed(int the_speed);
   int      get_speed(void);
   void     set_rot_timer(int new_time);
   int      get_rot_timer(void);
   int      set_subarea(char *the_subarea);
   char     *get_subarea(void);
   int      check_mobile(void);
   int      add_comlist(Com_List *new_com);
   int      del_comlist(int the_num);
   int      rename_comlist(int the_num, char *new_keywords);
   char     *find_reply(char *the_keyword);
   virtual  int set_title(char *the_title);
   Com_List *copy_com_list();
   Mobile   *operator = (Mobile *copy_from); 
   Shop     *get_shop();
   int      set_shop(Shop *new_shop);
   int      read_shop(FILE *read_file, ErrLog *error_log, int for_build_port);
   int      write_shop(FILE *the_file);
   int      delete_shop(void);
   int      set_start_wield(char *the_item, playerhand the_hand);
   char     *get_start_wield(playerhand the_hand);
   void     set_start_wear(char *the_items);
   char     *get_start_wear();
   int      read_mobile_attrib(FILE *read_file, ErrLog *error_log, 
                                                        int for_build_port);
   int      start_wield(Object_List *obj_dbase, ErrLog *error_log);
   int      start_wear(Object_List *obj_dbase, ErrLog *error_log);
   int      set_aggression(int the_value);
   int      get_aggression(void);
   int      check_aggression(Individual *the_ind);
   int      check_get();
   int      rot_corpse();
   int      load_decay_str(Strings *the_str);

   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();
   virtual int send_plr(char *new_str, ...);
   
   int coord_ranks(Object_List *the_dbase);

   /**********************************
    ** Combat functions
    **********************************/

   virtual int attack(Individual *target);





private:
   Mobile();

   Com_List *tell_list;
   Strings  brief;
   int      speed;
   int      aggression;
   Strings  subareas;

   Strings  wield_left;
   Strings  wield_right;

   Strings  worn;

   Shop     *the_shop;
   int      rot_timer;
};

#endif
