# (c) Aleksey Filutich, 2002        cactus@narod.ru   ICQ#61043410
# (c) Emil berg, 2003		ICQ#131916023
#
# Auto offline module. Will put user in specified state after N minutes

variable wakeup 10000 

namespace eval meta {
	set name "Auto away"
	set desciption "Automatically switch to Away or NA status after idle time"
	set author "Aleksey Filutich <cactus@narod.ru>, Emil O:berg (ICQ#131916023)"
	array set mode {type variant property Global:ICQ:Auto-Offline|Mode
		values {none away na offline}
		description "Switch to status" save change default none
	}
	array set timeout {type integer default 5 save change
		description "Idle time, minutes"
		property Global:ICQ:Auto-Offline|Timeout
	}
}

proc CheckSleeping {lastxy} {
  foreach x {wakeup mode status} { variable $x }
  set xy [winfo pointerxy .]
  if { $mode == "none" } {
      # no auto timeout
      after [timeout] [nc CheckSleeping $xy]
  } elseif {$lastxy == $xy && $status == "online"} {
      # the mouse hasn't changed, so we timeout. also start the makeup  msec. wakeup timer
      after $wakeup [nc CheckAwakend $status $xy]
      Event SetStatus $mode
  } else {
      # mouse has moved since last check, so just keep on waiting
      after [timeout] [nc CheckSleeping $xy]
  }
}



proc CheckAwakend {state lastxy} {
  foreach x {wakeup mode status} { variable $x }
  set xy [winfo pointerxy .]
  if {$lastxy == $xy && $status == $mode} {
    # we wait for wakeup milliseconds before we check again
    after $wakeup [nc CheckAwakend $state $xy]
  } else {
    # awaken and return to sleep timeout loop
    Event SetStatus  $state
    after [timeout] [nc CheckSleeping $xy]
  }
}

proc timeout {} {
	variable timeout
	expr $timeout * 60000
}

# Can only work if icq module is loaded
handler ConfigLoaded onConfig {args} { CheckSleeping "-1 -1" }
upvar #0 [ref Me](Status) status

