package require Tk
catch { package require BWidget }
package provide AlicqWidgets 0.4

# Default resources and keybindings common for all modules
option add *close.image button:close widgetDefault
option add *Entry.background gray90 widgetDefault
option add *Text.background gray90 widgetDefault
option add *borderWidth 1 widgetDefault
option add *Button*overRelief raised widgetDefault
option add *highlightThickness 0 startupFile
option add *compound left widgetDefault
# Default button labels
after idle {
	if {[info commands mc]=="mc"} {
		option add *ButtonBar.close.text [mc Close] widgetDefault
	}
}
	
switch -- $::tcl_platform(platform) {
	unix {
		option add *font -*-fixed-medium-r-normal--13-*\
			widgetDefault
	}
}

event add <<Close>> <Escape>
event add <<Accept>> <Return>

# Make all toplevel windows accept 'geometry' option
catch { rename ::toplevel ::toplevel.orig }
proc ::toplevel {win args} {
	eval [list ::toplevel.orig $win] $args
	set gm [option get $win geometry Geometry]
	if {$gm!=""} { 
		wm geometry $win $gm 
		set modules::geometry::cache($win) $gm
	}
	set win
}

image create bitmap button:close -foreground DarkRed -data {
	#define close_width 14
	#define close_height 14
	static unsigned char close_bits[] = {
	   0,0,0x0c,0x0c,0x1e,0x1e,0x3e,0x1f,0xfc,0x0f,0xf8,0x07,0xf0,
	   3,0xf0,3,0xf8,7,0xfc,0x0f,0x3e,0x1f,0x1e,0x1e,0x0c,0x0c,0,0};
}

proc ScrolledTxt {name args} {
	set win [ScrolledWindow $name]
	$win setwidget [eval text $win.txt $args]
	set win
}

namespace eval ui {}

# Take BWidget implementation of tooltips for now
proc ui::tooltip {args} {}
catch  {
if [package vsatisfies [package present BWidget] 1.6] {
	proc ui::tooltip {widget text {hotkey ""}} {
		set text [mc $text]
		if {$hotkey!=""} { append text "\n" [mc Hot-key] ": "\
			[join [map x [event info $hotkey]\
				{string map {Key- ""} $x}] ", "]}
		DynamicHelp::register $widget balloon $text
	}
}
}

# Subcascade is a helper widget which creates hierarchy of submenu for each
# item of a list
proc ui::subcascade {top items} {
        if {![llength $items]} {return $top}
        set ntop $top.mn[lindex $items 0]
        if {![winfo exists $ntop]} {
		menu $ntop -type normal -tearoff no
		$top add cascade -label [mc [lindex $items 0]] -menu $ntop
	}	
        subcascade $ntop [lrange $items 1 end]
}

proc ui::extend {name aux params} {
	set ns [uplevel 1 namespace current]
	set class [namespace tail $ns]
	if {[info commands $name]!=$name} { ::$class $name }
	bindtags $name [concat [bindtags $name] Extended]
	rename ::$name ${class}::$name
	interp alias {} $name {} [namespace current]::dispatch $class $name
	upvar 0 ${class}::$name options
	array set options $aux
	if {[llength $params]} {
		eval [list dispatch $class $name configure] $params
	}	
	set name
}
bind Extended <Destroy> [list %W _destroy]

proc ui::dispatch {class name cmd args} {
	set ns [namespace current]
	set c ${ns}::${class}::public:${cmd}
	if {[info commands $c]==$c} {
		return [uplevel 1 [list $c $name] $args]
	} else {
		set c ${ns}::public:${cmd}
		if {[info commands $c]==$c} {
			return [uplevel 1 [list $c $class $name] $args]
		}
	}
	uplevel 1 [list ${ns}::${class}::${name} $cmd] $args
}

proc ui::public:_destroy {class name} {
	upvar 0 ${class}::${name} data
	if {[info exists data]} { unset data }
	interp alias {} $name {}
}

proc ui::public:cget {class name key} {
	upvar 0 ${class}::${name} data
	if {[info exists data($key)]} { return $data($key) }
	${class}::${name} cget $key
}

# Variant widget. It is meun if parent is menu, or menubutton otherwise.
# Options:
#     -values: list of possible values. Each item can be either value itself,
# 		or list of two items: value and text representation
#     -valuescript: script invoked to get list of values in format of -value
#		option
#     -variable: variable to store selected value
#     -delimiter: delimiter for grouping long lists into submenus. Default is 
#		column
namespace eval ui::variant { 
	variable custom {-values -valuescript -variable -delimiter}
	#namespace export variant 
}

# Variant constructor command
proc ui::variant::variant {name args} {
	set parent [join [lrange [split $name .] 0 end-1] .]
	set menu $name
	if {[winfo exists $parent] && [winfo class $parent]!="Menu"} {
		set menu $name.menu
		menubutton $name -menu $menu
		bind $name <Destroy> [list destroy $menu]
	} 
	menu $menu -tearoff no 
	ui::extend $name {-values "" -delimiter : -variable "" -valuescript ""} $args
	bind $menu <Destroy> [list unset [namespace current]::$name]
	set name
}

# Variant 'configure' extended options handling
proc ui::variant::public:configure {name args} {
	variable custom
	upvar 0 [namespace current]::$name option
	if {![info exists option]} { 
		return -code error "Unknown variant $name" 
	}
	set menu $name
	if {[winfo exists $name] && [winfo class $name]=="Menubutton"} { 
		set menu [$name cget -menu] 
	}
	if {![winfo exists $menu]} { set values [list] }

	set update [list]
	foreach {key val} $args {
		if {[lsearch -exact $custom $key]!=-1} {
			set option($key) $val
			lappend update $key
		} else { lappend rest $key $val }
	}
	if {[lsearch -exact $update -valuescript]!=-1} {
		set values [uplevel 1 $option(-valuescript)]
	} elseif {[lsearch -exact $update -values]!=-1 || 
		  [lsearch -exact $update -delimiter]!=-1} {
		set values $option(-values)
	}
	if {[info exists values]} {
		foreach x [winfo children $menu] { destroy $x }
		$menu delete 0 end
		set select 1
		if {[info exists option(-variable)]} {
			upvar 1 $option(-variable) var
			if {![info exists var]} { set var "" }
			if {[winfo class $name]!="Menu"} {
				trace variable var w\
					[namespace code [list recval $menu]]
				set option(lastvar) $option(-variable)
			}
			if {[set pos [lsearch -exact $update -variable]]!=-1} {
				set update [lreplace $update $pos $pos]
			}
		}
		foreach x $values {
			if {[llength $x]==2} { 
				set values [split [lindex $x end]\
					$option(-delimiter)]
				set val [lindex $x 0]
			} else {
				set values [split [lindex $x 0] :]
				set val [lindex $values end]
			}
			set mn [::ui::subcascade $menu [lrange $values 0 end-1]]
			set label [lindex $values end]
			$mn add radiobutton -label $label -value $val
			if {$menu!=$name} { 
				$mn entryconfigure last -command\
					[nc $name configure -text $label]
				set len [string length $label]
				if {![info exists max] || $len>$max} { 
					set max $len 
				}
			}
			if {[info exists option(-variable)]} {
				$mn entryconfigure last\
					-variable $option(-variable)
				if {$var==$val} { 
					set select 0
					eval [$mn entrycget last -command] 
				}
			}
		}
		if {[info exists max]} { $name configure -width $max }
		if {$select && [info exists mn]} { $mn invoke last }
	}
	if {[lsearch -exact $update -variable]!=-1} {
		set cmd [namespace code [list recval $menu]]
		if {[winfo class $name]!="Menu"} {
			if {[info exists option(lastvar)]} {
				upvar 1 $option(lastvar) var
				foreach x [trace vinfo var] {
					if {[lindex $x 1]==$cmd} {
						eval trace vdelete var $x
					}
				}
			}
			upvar 1 $option(-variable) var
			trace variable var w $cmd
			set option(lastvar) $option(-variable)
		}
		recassign $menu $option(-variable) 
	}
	if {[info exists rest]} { eval [list ${name} configure] $rest }
}

proc ui::variant::traverse {w menu idx script {level 1}} {
	set max [$w index last]
	if {$max=="none"} return
	upvar $level $idx I $menu win
	for {set i 0} {$i<=$max} {incr i} {
		switch -exact -- [$w type $i] {
			radiobutton {
				set win $w
				set I $i
				uplevel $level $script 
			}
			cascade { ui::variant::traverse [$w entrycget $i -menu]\
					$menu $idx $script [expr $level+1] }
		}
	}
}

# Recursively assign variable to submenu radiobuttons
proc ui::variant::recassign {w var} { 
	upvar 2 $var val
	traverse $w menu x {
		$menu entryconfigure $x -variable $var
		if {[info exists val] && [$menu entrycget $x -value]==$val} {
			$menu invoke $x 
		}
	}
}

proc ui::variant::recval {w name idx args} {
	if {$idx==""} {
		upvar 1 $name var
	} else {
		upvar 1 ${name}($idx) var
	}
	traverse $w menu x {
		if {[$menu entrycget $x -value]==$var} { $menu invoke $x }
	}
}

namespace eval ui::text {
	catch  {
	if {[package vsatisfies [package present Tk] 8.4]} {
		proc modified {txt {val ""}} { eval $txt edit modified $val }
	} else {
		proc modified {txt {val ""}} {
			upvar 0 [namespace current]::$txt data
			set ret [eval set data(_modified) $val]
			if {$val==1} { event generate $txt <<Modified>> }
			set ret
		}
		event add <<Modify>> <KeyPress> <2>
		eval event add <<Modify>> [event info <<Paste>>]
		bind SyncVar <<Modify>> [namespace code [list modified %W 1]]
	}
	bind SyncVar <<Modified>> [namespace code [list SyncVar %W]]
	}
}

proc ui::text::text {name args} {
	ui::extend $name {-variable "" _modified 0} [concat [list ] $args] 
	bindtags $name [concat [bindtags $name] SyncVar]
	modified $name 0
	set name
}

proc ui::text::public:configure {name args} {
	upvar 0 [namespace current]::${name} data
	array set opts $args
	if {[info exists opts(-variable)]} {
		set cmd [namespace code [list ToText $name]]
		if {[info exists data(-variable)]} {
			upvar #0 $data(-variable) var
			trace vdelete var w $cmd
		}
		set data(-variable) $opts(-variable)
		unset opts(-variable)
		upvar #0 $data(-variable) var2
		if {![info exists var2]} { set var2 "" }
		SyncText $name $var2
		trace variable var2 w $cmd
	}
	eval [list $name configure] [array get opts]
}

proc a {args} { puts $args} 

proc ui::text::ToText {txt var field op} {
	if {$field==""} {
		upvar 2 $var value
	} else {
		upvar 2 ${var}($field) value
	}
	SyncText $txt $value 
}

proc ui::text::SyncText {txt value} {
	if {[modified $txt]} {
		modified $txt 0
		return
	}
	set state [$txt cget -state]
	$txt configure -state normal
	$txt delete 1.0 end
	$txt insert end $value
	$txt configure -state $state
	modified $txt 0
}

proc ui::text::SyncVar {txt} {
	upvar 0 [namespace current]::$txt data
	if {![info exists data(-variable)]} return
	if {![modified $txt]} return
	upvar #0 $data(-variable) var
	set var [$txt get 1.0 end]
}

# Import all UI widgets commands into ui namespace
namespace eval ui {
	foreach x [namespace children] {
		set name [namespace tail $x]
		namespace eval $x [list namespace export $name]
		namespace import ${x}::$name
	}
}

