/***************************************************************************
                          apolloninfotab.h  -  description
                             -------------------
begin		: Dec 05 2003
copyright	: (C) 2002 by Bastiaan Naber, (C) 2002 by Robert Wittams
email		: bastiaan@ricardis.tudelft.nl
description	:

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APOLLONINFOTAB_H
#define APOLLONINFOTAB_H

#include <apollontab.h>

class giFTConnection;
class QLabel;
class QTimer;
class QTextEdit;
class KPushButton;

class ApollonInfoTab : public ApollonTab
{
	Q_OBJECT

	public:
		/**
		 * Constructor.
		 */
		ApollonInfoTab(QWidget* parent, const char *name, giFTConnection* gcn);

		/**
		 * Destructor.
		 */
		~ApollonInfoTab();

	public slots:
		/**
		 * Starts the giFT daemon.
		 */
		void startDaemon();

		/**
		 * Does a retry to connect to a remote deamon.
		 */
		void retryRemoteConnection();

		/**
		 * Called when we've been connected with the giFT daemon.
		 */
		void connected();

		/**
		 * Called when we've been disconnected from the giFT daemon.
		 */
		void disconnected();

		/**
		 * Requests the statistics from the giFT daemon.
		 */
		void requestStats();

		/**
		 * Displays the requested statistics in the info page.
		 * @param status The status string passed by the giFT daemon.
		 */
		void giftStatusReply(QString status);

		/**
		 * Called if an errors occurs while connecting to the giFT daemon.
		 * @param error Error number of the error that occured.
		 */
		void socketError(int error);

	signals:
		/**
		 * Emitted to let the main program know whether there's a running
		 * giFT daemon that should be killed upon program exit.
		 * @param kill True if there's a giFT daemon running to be killed.
		 */
		void sigKill(bool kill);

	private:
		int          m_numStatUpdates;   // tells how many times the stats have been updated
		int          m_tries;            // number of tries to start the giFT daemon
		QTextEdit   *m_infoBox;          // the one and only info box which shows the stats
		QTimer      *m_timer;            // timer for updating the stats and attempting reconnects
};

#endif

