/* $Id: ArkPath.h,v 1.18 2002/12/27 20:16:46 mat Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_PATH_H
#define ARK_PATH_H

#include <Ark/ArkMath.h>
#include <Ark/ArkCollision.h>
#include <list>

namespace Ark
{

   class Entity;

   // FIXME: Move that to another place
   struct ARK_DLL_API EntityCollision
   {
	 Entity *m_Collider;
	 ColPair m_Pair;
	 bool m_Potential;
   };

   class ARK_DLL_API Path
   {
      public:
	 Entity *m_Entity;

	 /** 
	  * This is set to true when the path has been completed ; this
	  * can be used to generate an event, for a script for example.
	  */
	 bool m_GoalReached;
	 
	 Vector3 m_PosTarget;
	 Entity *m_EntTarget;
	 
      public:
	 Path () {}
	 explicit Path (Entity* entity);
	 ~Path ();
	 
	 void Reset ();
	 void AddPoint (const Vector3 &v, scalar speed);
	 bool Update (Vector3 *pos, scalar delta = 0.0);

	 void SetGoal (const Vector3 &goal);
	 void SetGoal (Entity *goal);

	 void PlanifyUpdate (scalar time);

	 const std::list<Vector3> &GetPoints() const
	    {return m_Points;}

	 void SetLastCollision(const EntityCollision &et);

      private:
	 /**
	  * When the pathfinder has run for too long, it stops and returns
	  * the best path he could find. When such a situation happen, it
	  * is likely that this path will be broken, so we walk a bit along it
	  * and then update it, hoping a path will be found.
	  */
	 bool m_BrokenPath;
	 scalar m_NextUpdateTime;

	 std::list<Vector3> m_Points;

	 /**
	  * Set to true when the m_GoalReached member has been set to true
	  * at least one time for this path.
	  */
	 bool m_GoalReachedFlag;

	 bool m_hasLastCol;
	 EntityCollision m_LastCol;
	 Vector3 m_GoalDir;
   };

}

#endif
