#ifdef CAPI_ULAW
#define capiXLAW2INT(x) capiULAW2INT[x]
#define capiINT2XLAW(x) capiINT2ULAW[((unsigned short)x) >> 2]
#else
#define capiXLAW2INT(x) capiALAW2INT[x]
#define capiINT2XLAW(x) capiINT2ALAW[(x>>4)+4096]
#endif

static unsigned char reversebits[256] =
{
0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};

#ifdef CAPI_ULAW
static short capiULAW2INT[] =
{
0x8284, 0x7d7c, 0xf8a4, 0x075c, 0xe104, 0x1efc, 0xfe8c, 0x0174,
0xc184, 0x3e7c, 0xfc94, 0x036c, 0xf0c4, 0x0f3c, 0xff88, 0x0078,
0xa284, 0x5d7c, 0xfaa4, 0x055c, 0xe904, 0x16fc, 0xff0c, 0x00f4,
0xd184, 0x2e7c, 0xfd94, 0x026c, 0xf4c4, 0x0b3c, 0xffc8, 0x0038,
0x9284, 0x6d7c, 0xf9a4, 0x065c, 0xe504, 0x1afc, 0xfecc, 0x0134,
0xc984, 0x367c, 0xfd14, 0x02ec, 0xf2c4, 0x0d3c, 0xffa8, 0x0058,
0xb284, 0x4d7c, 0xfba4, 0x045c, 0xed04, 0x12fc, 0xff4c, 0x00b4,
0xd984, 0x267c, 0xfe14, 0x01ec, 0xf6c4, 0x093c, 0xffe8, 0x0018,
0x8a84, 0x757c, 0xf924, 0x06dc, 0xe304, 0x1cfc, 0xfeac, 0x0154,
0xc584, 0x3a7c, 0xfcd4, 0x032c, 0xf1c4, 0x0e3c, 0xff98, 0x0068,
0xaa84, 0x557c, 0xfb24, 0x04dc, 0xeb04, 0x14fc, 0xff2c, 0x00d4,
0xd584, 0x2a7c, 0xfdd4, 0x022c, 0xf5c4, 0x0a3c, 0xffd8, 0x0028,
0x9a84, 0x657c, 0xfa24, 0x05dc, 0xe704, 0x18fc, 0xfeec, 0x0114,
0xcd84, 0x327c, 0xfd54, 0x02ac, 0xf3c4, 0x0c3c, 0xffb8, 0x0048,
0xba84, 0x457c, 0xfc24, 0x03dc, 0xef04, 0x10fc, 0xff6c, 0x0094,
0xdd84, 0x227c, 0xfe54, 0x01ac, 0xf7c4, 0x083c, 0xfff8, 0x0008,
0x8684, 0x797c, 0xf8e4, 0x071c, 0xe204, 0x1dfc, 0xfe9c, 0x0164,
0xc384, 0x3c7c, 0xfcb4, 0x034c, 0xf144, 0x0ebc, 0xff90, 0x0070,
0xa684, 0x597c, 0xfae4, 0x051c, 0xea04, 0x15fc, 0xff1c, 0x00e4,
0xd384, 0x2c7c, 0xfdb4, 0x024c, 0xf544, 0x0abc, 0xffd0, 0x0030,
0x9684, 0x697c, 0xf9e4, 0x061c, 0xe604, 0x19fc, 0xfedc, 0x0124,
0xcb84, 0x347c, 0xfd34, 0x02cc, 0xf344, 0x0cbc, 0xffb0, 0x0050,
0xb684, 0x497c, 0xfbe4, 0x041c, 0xee04, 0x11fc, 0xff5c, 0x00a4,
0xdb84, 0x247c, 0xfe34, 0x01cc, 0xf744, 0x08bc, 0xfff0, 0x0010,
0x8e84, 0x717c, 0xf964, 0x069c, 0xe404, 0x1bfc, 0xfebc, 0x0144,
0xc784, 0x387c, 0xfcf4, 0x030c, 0xf244, 0x0dbc, 0xffa0, 0x0060,
0xae84, 0x517c, 0xfb64, 0x049c, 0xec04, 0x13fc, 0xff3c, 0x00c4,
0xd784, 0x287c, 0xfdf4, 0x020c, 0xf644, 0x09bc, 0xffe0, 0x0020,
0x9e84, 0x617c, 0xfa64, 0x059c, 0xe804, 0x17fc, 0xfefc, 0x0104,
0xcf84, 0x307c, 0xfd74, 0x028c, 0xf444, 0x0bbc, 0xffc0, 0x0040,
0xbe84, 0x417c, 0xfc64, 0x039c, 0xf004, 0x0ffc, 0xff7c, 0x0084,
0xdf84, 0x207c, 0xfe74, 0x018c, 0xf844, 0x07bc, 0x0000, 0x0000
};

const unsigned char capiINT2ULAW[16384] = {
255,127,127,191,191,63,63,223,223,95,95,159,159,31,31,239,
239,111,111,175,175,47,47,207,207,79,79,143,143,15,15,247,
247,247,247,119,119,119,119,183,183,183,183,55,55,55,55,215,
215,215,215,87,87,87,87,151,151,151,151,23,23,23,23,231,
231,231,231,103,103,103,103,167,167,167,167,39,39,39,39,199,
199,199,199,71,71,71,71,135,135,135,135,7,7,7,7,251,
251,251,251,251,251,251,251,123,123,123,123,123,123,123,123,187,
187,187,187,187,187,187,187,59,59,59,59,59,59,59,59,219,
219,219,219,219,219,219,219,91,91,91,91,91,91,91,91,155,
155,155,155,155,155,155,155,27,27,27,27,27,27,27,27,235,
235,235,235,235,235,235,235,107,107,107,107,107,107,107,107,171,
171,171,171,171,171,171,171,43,43,43,43,43,43,43,43,203,
203,203,203,203,203,203,203,75,75,75,75,75,75,75,75,139,
139,139,139,139,139,139,139,11,11,11,11,11,11,11,11,243,
243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,115,
115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,179,
179,179,179,179,179,179,179,179,179,179,179,179,179,179,179,51,
51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,211,
211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,83,
83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,147,
147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,227,
227,227,227,227,227,227,227,227,227,227,227,227,227,227,227,99,
99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,163,
163,163,163,163,163,163,163,163,163,163,163,163,163,163,163,35,
35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,195,
195,195,195,195,195,195,195,195,195,195,195,195,195,195,195,67,
67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,253,
253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,189,
189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,
189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,61,
61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,
93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,
93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,157,
157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,
157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,29,
29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,
29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,237,
237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,
237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,173,
173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,
173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,205,
205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,
205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,77,
77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,141,
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,13,
13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,245,
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,117,
117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,213,
213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,21,
21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,229,
229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,101,
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,165,
165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,197,
197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,
121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,
217,217,217,217,217,217,217,217,217,217,217,217,217,217,217,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,
153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,
233,233,233,233,233,233,233,233,233,233,233,233,233,233,233,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,
169,169,169,169,169,169,169,169,169,169,169,169,169,169,169,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,
201,201,201,201,201,201,201,201,201,201,201,201,201,201,201,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
192,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
160,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
224,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
144,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
208,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
240,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,200,
200,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,168,
168,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,232,
232,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,
152,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,216,
216,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,
248,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
164,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
228,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
148,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
52,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
116,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
244,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
204,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,
44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,
44,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,
172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,
172,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,
156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,
156,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
220,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
60,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,
188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,
188,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
130,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,
66,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,
194,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,
98,226,226,226,226,226,226,226,226,226,226,226,226,226,226,226,
226,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,
146,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,
82,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,
210,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,
50,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,
178,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,
114,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,
242,10,10,10,10,10,10,10,10,138,138,138,138,138,138,138,
138,74,74,74,74,74,74,74,74,202,202,202,202,202,202,202,
202,42,42,42,42,42,42,42,42,170,170,170,170,170,170,170,
170,106,106,106,106,106,106,106,106,234,234,234,234,234,234,234,
234,26,26,26,26,26,26,26,26,154,154,154,154,154,154,154,
154,90,90,90,90,90,90,90,90,218,218,218,218,218,218,218,
218,58,58,58,58,58,58,58,58,186,186,186,186,186,186,186,
186,122,122,122,122,122,122,122,122,250,250,250,250,250,250,250,
250,6,6,6,6,134,134,134,134,70,70,70,70,198,198,198,
198,38,38,38,38,166,166,166,166,102,102,102,102,230,230,230,
230,22,22,22,22,150,150,150,150,86,86,86,86,214,214,214,
214,54,54,54,54,182,182,182,182,118,118,118,118,246,246,246,
246,14,14,142,142,78,78,206,206,46,46,174,174,110,110,238,
238,30,30,158,158,94,94,222,222,62,62,190,190,126,126,254,
};
#else
static short capiALAW2INT[] =
{
	0x13fc, 0xec04, 0x0144, 0xfebc, 0x517c, 0xae84, 0x051c, 0xfae4,
	0x0a3c, 0xf5c4, 0x0048, 0xffb8, 0x287c, 0xd784, 0x028c, 0xfd74,
	0x1bfc, 0xe404, 0x01cc, 0xfe34, 0x717c, 0x8e84, 0x071c, 0xf8e4,
	0x0e3c, 0xf1c4, 0x00c4, 0xff3c, 0x387c, 0xc784, 0x039c, 0xfc64,
	0x0ffc, 0xf004, 0x0104, 0xfefc, 0x417c, 0xbe84, 0x041c, 0xfbe4,
	0x083c, 0xf7c4, 0x0008, 0xfff8, 0x207c, 0xdf84, 0x020c, 0xfdf4,
	0x17fc, 0xe804, 0x018c, 0xfe74, 0x617c, 0x9e84, 0x061c, 0xf9e4,
	0x0c3c, 0xf3c4, 0x0084, 0xff7c, 0x307c, 0xcf84, 0x030c, 0xfcf4,
	0x15fc, 0xea04, 0x0164, 0xfe9c, 0x597c, 0xa684, 0x059c, 0xfa64,
	0x0b3c, 0xf4c4, 0x0068, 0xff98, 0x2c7c, 0xd384, 0x02cc, 0xfd34,
	0x1dfc, 0xe204, 0x01ec, 0xfe14, 0x797c, 0x8684, 0x07bc, 0xf844,
	0x0f3c, 0xf0c4, 0x00e4, 0xff1c, 0x3c7c, 0xc384, 0x03dc, 0xfc24,
	0x11fc, 0xee04, 0x0124, 0xfedc, 0x497c, 0xb684, 0x049c, 0xfb64,
	0x093c, 0xf6c4, 0x0028, 0xffd8, 0x247c, 0xdb84, 0x024c, 0xfdb4,
	0x19fc, 0xe604, 0x01ac, 0xfe54, 0x697c, 0x9684, 0x069c, 0xf964,
	0x0d3c, 0xf2c4, 0x00a4, 0xff5c, 0x347c, 0xcb84, 0x034c, 0xfcb4,
	0x12fc, 0xed04, 0x0134, 0xfecc, 0x4d7c, 0xb284, 0x04dc, 0xfb24,
	0x09bc, 0xf644, 0x0038, 0xffc8, 0x267c, 0xd984, 0x026c, 0xfd94,
	0x1afc, 0xe504, 0x01ac, 0xfe54, 0x6d7c, 0x9284, 0x06dc, 0xf924,
	0x0dbc, 0xf244, 0x00b4, 0xff4c, 0x367c, 0xc984, 0x036c, 0xfc94,
	0x0f3c, 0xf0c4, 0x00f4, 0xff0c, 0x3e7c, 0xc184, 0x03dc, 0xfc24,
	0x07bc, 0xf844, 0x0008, 0xfff8, 0x1efc, 0xe104, 0x01ec, 0xfe14,
	0x16fc, 0xe904, 0x0174, 0xfe8c, 0x5d7c, 0xa284, 0x05dc, 0xfa24,
	0x0bbc, 0xf444, 0x0078, 0xff88, 0x2e7c, 0xd184, 0x02ec, 0xfd14,
	0x14fc, 0xeb04, 0x0154, 0xfeac, 0x557c, 0xaa84, 0x055c, 0xfaa4,
	0x0abc, 0xf544, 0x0058, 0xffa8, 0x2a7c, 0xd584, 0x02ac, 0xfd54,
	0x1cfc, 0xe304, 0x01cc, 0xfe34, 0x757c, 0x8a84, 0x075c, 0xf8a4,
	0x0ebc, 0xf144, 0x00d4, 0xff2c, 0x3a7c, 0xc584, 0x039c, 0xfc64,
	0x10fc, 0xef04, 0x0114, 0xfeec, 0x457c, 0xba84, 0x045c, 0xfba4,
	0x08bc, 0xf744, 0x0018, 0xffe8, 0x227c, 0xdd84, 0x022c, 0xfdd4,
	0x18fc, 0xe704, 0x018c, 0xfe74, 0x657c, 0x9a84, 0x065c, 0xf9a4,
	0x0cbc, 0xf344, 0x0094, 0xff6c, 0x327c, 0xcd84, 0x032c, 0xfcd4
};

const unsigned char capiINT2ALAW[8192] = {
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
  212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
  212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
  212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
  212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
  148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
  148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
  148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
  148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
  52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
  52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
  52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
  52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
  180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
  68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
  68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
  68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
  68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
  196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
  196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
  196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
  196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
  132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
  132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
  132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
  100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
  228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
  228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
  228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
  228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,228,
  36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
  36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
  36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
  36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
  164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
  164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
  164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
  164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,
  92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
  220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
  220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,220,
  28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
  28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
  156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,
  156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,
  124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
  124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
  252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
  252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
  60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
  60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
  188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,
  76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
  76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
  204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
  204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
  12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
  12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
  140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
  140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
  108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
  108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
  236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
  236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
  44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,
  44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,
  172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,
  172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,
  80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
  208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,208,
  16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
  144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,
  112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
  240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
  48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
  64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
  192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
  96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
  224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
  88,88,88,88,88,88,88,88,216,216,216,216,216,216,216,216,
  24,24,24,24,24,24,24,24,152,152,152,152,152,152,152,152,
  120,120,120,120,120,120,120,120,248,248,248,248,248,248,248,248,
  56,56,56,56,56,56,56,56,184,184,184,184,184,184,184,184,
  72,72,72,72,72,72,72,72,200,200,200,200,200,200,200,200,
  8,8,8,8,8,8,8,8,136,136,136,136,136,136,136,136,
  104,104,104,104,104,104,104,104,232,232,232,232,232,232,232,232,
  40,40,40,40,40,40,40,40,168,168,168,168,168,168,168,168,
  86,86,86,86,214,214,214,214,22,22,22,22,150,150,150,150,
  118,118,118,118,246,246,246,246,54,54,54,54,182,182,182,182,
  70,70,70,70,198,198,198,198,6,6,6,6,134,134,134,134,
  102,102,102,102,230,230,230,230,38,38,38,38,166,166,166,166,
  94,94,222,222,30,30,158,158,126,126,254,254,62,62,190,190,
  78,78,206,206,14,14,142,142,110,110,238,238,46,46,174,174,
  82,210,18,146,114,242,50,178,66,194,2,130,98,226,34,162,
  90,218,26,154,122,250,58,186,74,202,10,138,106,234,42,170,
  171,43,235,107,139,11,203,75,187,59,251,123,155,27,219,91,
  163,35,227,99,131,3,195,67,179,51,243,115,147,19,211,83,
  175,175,47,47,239,239,111,111,143,143,15,15,207,207,79,79,
  191,191,63,63,255,255,127,127,159,159,31,31,223,223,95,95,
  167,167,167,167,39,39,39,39,231,231,231,231,103,103,103,103,
  135,135,135,135,7,7,7,7,199,199,199,199,71,71,71,71,
  183,183,183,183,55,55,55,55,247,247,247,247,119,119,119,119,
  151,151,151,151,23,23,23,23,215,215,215,215,87,87,87,87,
  169,169,169,169,169,169,169,169,41,41,41,41,41,41,41,41,
  233,233,233,233,233,233,233,233,105,105,105,105,105,105,105,105,
  137,137,137,137,137,137,137,137,9,9,9,9,9,9,9,9,
  201,201,201,201,201,201,201,201,73,73,73,73,73,73,73,73,
  185,185,185,185,185,185,185,185,57,57,57,57,57,57,57,57,
  249,249,249,249,249,249,249,249,121,121,121,121,121,121,121,121,
  153,153,153,153,153,153,153,153,25,25,25,25,25,25,25,25,
  217,217,217,217,217,217,217,217,89,89,89,89,89,89,89,89,
  161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
  33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
  225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
  97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
  129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,
  65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
  177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,
  49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
  241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241,
  113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
  145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145,
  17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
  209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,
  81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
  173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,
  173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,173,
  45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
  45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
  237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,
  237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,
  109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
  109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
  141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,
  141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,
  13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,
  13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,
  205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,
  205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,
  77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,
  77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,
  189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,
  61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
  61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,
  253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
  253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
  125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
  125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
  157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,
  157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,
  29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,
  29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,
  221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
  221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
  93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,
  165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
  165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
  165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
  165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
  37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
  37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
  37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
  37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
  229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
  229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
  229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
  229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,
  101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
  101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
  101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
  101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
  133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
  133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
  133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
  133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
  197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
  197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
  197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197,
  69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
  69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
  69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
  69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
  181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
  53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
  53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
  53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
  53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
  245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
  245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
  245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
  245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
  149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
  149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
  149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
  21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
  21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
  21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
  21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,
  213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
  213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
  213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
  213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,213,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85
};

#endif // CAPI_ULAW
