<?php
$possiblepagetypes = array (
	'txt'  => array('Text',   'txt.png'),
	'html' => array('HTML',   'html.png'),
	'php'  => array('PHP',    'php.png'),
	'mod'  => array('Module', 'mod.png'),
	'alias'=> array('Alias',  'alias.png'),
	'raw'  => array('Raw',    'file.png')
);
$allowed = explode(' ', $prop->getGlobal('allowed-types'));
$pagetypes = array();
foreach ($allowed as $type) {
	$pagetypes[$type] = $possiblepagetypes[$type];
}

$children = $page->children();
$tabindex = count($children)+1;
?>

<script language="JavaScript">
function submitform(formname,inputname,value) {
  f = document.forms[formname]; 
  f.elements[inputname].value = value;
  f.submit();
}
</script>

<div style="float: left">
<?php
	$editinfo = true;
	if ($page->path == '')
		echo img('img/big/home.png');
	elseif ($page->path == '/.trash') {
		echo img('img/big/trash.png');
		$editinfo = false;
	}
	elseif ($page->path == '/.clipboard') {
		echo img('img/big/clip.png');
		$editinfo = false;
	}
	elseif ($page->get('dir'))
		echo img('img/big/folder.png');
	else
		echo img('img/big/' . $pagetypes[$page->type][1]);
?>
</div>

<?php if ($editinfo) { ?>

<table>
<form action="<?=$action?>" method=post name=infoform>
<input type=hidden name=action value=edit>
<input type=hidden name=eaction value=info>
 
<?php if ($page->path != '') { ?>
<tr>
  <td align=right>Name:</td>
  <td>
    <input class=textinput type=text name=name value="<?=$page->name?>" size=40 tabindex=<?=$tabindex++?>>
  </td>
</tr>
<?php } ?>

<tr>
 <td align=right>Title:</td>
 <td>
    <input class=textinput type=text name=title value="<?=$page->get('title')?>" size=40 tabindex=<?=$tabindex++?>>
 </td>
</tr>

<tr>
 <td align=right>Subject:</td>
 <td>
    <input class=textinput type=text name=subject value="<?=$page->get('subject')?>" size=40 tabindex=<?=$tabindex++?>>
 </td>
</tr>

<tr>
 <td align=right valign=top>Description:</td>
 <td><textarea class=textinput name=description cols=40 rows=2 tabindex=<?=$tabindex++?>><?=$page->get('description')?></textarea></td>
</tr>

<tr>
 <td align=right>Keywords:</td>
 <td>
    <input class=textinput type=text name=keywords value="<?=$page->get('keywords')?>" size=40 tabindex=<?=$tabindex++?>>
 </td>
</tr>

<tr>
  <td align=right>Type:</td>
  <td>
  	<table><tr>
      <td>
        <select class=textinput name=type tabindex=<?=$tabindex++?>>
         <?php foreach($pagetypes as $type => $typedata) {
         	$selected = '';
         	if ($page->get('type') == $type)
         		$selected = 'SELECTED';
         	echo ("<option $selected value=\"$type\">$typedata[0]</option>");
         }?>
        </select>
      </td>
      <td>&nbsp;&nbsp;&nbsp;</td>
      <td align=right>Folder:</td>
      <td>
        <select class=textinput name=dir tabindex=<?=$tabindex++?>>
          <option <?= $page->get('dir') ? "SELECTED" : "" ?> value=true>Yes</option>
    	  <option <?= !$page->get('dir') ? "SELECTED" : "" ?> value=false>No</option>
        </select>
      </td>
    </tr></table>
  </td>
</tr>

<tr>
  <td align=right>Modified:</td>
  <td>
    <input class=textinput DISABLED type=text name=mtime value="<?=date('F j, Y, g:i a',$page->mtime)?>" size=40>
  </td>
</tr>

<tr><td colspan=2 align=right  style="padding: 2px">
<a class=button href="javascript:submitform('infoform','save','true')" accesskey='s' tabindex=<?=$tabindex++?>><u>S</u>ave</a>
<input type=hidden name="save" value="false">
<input type=submit style="display: none">
</td></tr>

</form>
</table>
<?php

} // end if editinfo
elseif($page->path == '/.trash') {
	echo "<br><b>Trash</b>";
	echo "<br><a href=\"$action?a=edit&ea=info&clip=destroyall\">empty trash</a><br clear=both />";
}
elseif($page->path == '/.clipboard') {
	echo "<br><b>Clipboard</b>";
	echo "<br clear=both />";
}	
?>


<?php
function display_child(&$child) {
	static $row = 'roweven';
	static $index = 1;
	global $page;
		
	if ($child->get('visible') == false) return;
	
	$action = "a=edit&ea=info";
	
	if ($row == 'roweven') $row = 'rowodd';
	else $row = 'roweven';
			
	echo "<tr class=\"$row\">";
	echo "<td width=5><input type=\"checkbox\" name=\"checked[" . basename($child->path) . "]\" tabindex=$index></td>";
	echo "<td>";
		if ($child->get('dir'))
			$class = 'type-dir';
		else
			$class = 'type-file';	
		echo alink($child->path . "/?$action", $child->name, "class=\"$class\" style=\"padding-left: 16px\"");
	echo "</td>";
	echo "<td>";
	echo $child->title;
	echo "</td>";

	echo "<td>";
	echo round($child->get('size') / 1024,1) . 'K';
	echo "</td>";
	echo "<td>";
	echo $child->get('type');
	echo "</td>";
	echo "<td>";
	echo date('M d Y g:i a',$child->get('mtime'));
	echo "</td>";
	echo "<td>";
	echo alink($page->path . "/?$action&move=up&child=" . basename($child->path), 'up');
	echo "&nbsp;&nbsp;";
	echo alink($page->path . "/?$action&move=down&child=" . basename($child->path), 'down');
	echo "</td>";
	echo "</tr>\n";
}

function display_attachment($filedata) {
	global $page;
	static $row = 'roweven';
	static $index = 1;
	if ($row == 'roweven') $row = 'rowodd';
	else $row = 'roweven';
			
	echo "<tr class=\"$row\">";
	echo "<td width=5><input type=\"checkbox\" name=\"checked[$filedata[name]]\" tabindex=$index></td>";
	echo "<td>";
	$class = 'type-file';	
	echo alink($page->path . "/$filedata[name]", $filedata['name'], "class=\"$class\" style=\"padding-left: 16px\"");
	echo "</td><td>";
	echo round($filedata['size'] / 1024,1) . 'K';
	echo "</td><td>";
	echo $filedata['type'];
	echo "</td><td>";
	echo date('M d Y g:i a',$filedata['mtime']);
	echo "</td><td></tr>\n";
}

?>

<script language=javascript>
function selectAll() {
  void(d=document);
  void(el=d.getElementsByTagName('INPUT'));
  for(i=0;i<el.length;i++)
    void(el[i].checked=1) 
}
function selectNone() {
  void(d=document);
  void(el=d.getElementsByTagName('INPUT'));
  for(i=0;i<el.length;i++)
    void(el[i].checked=0) 
}
</script>

	<div class=box><div class=section>Sub-pages</div>
	<table border=0 cellspacing=1 width="100%">
	<form action="<?=$action?>" method=post name=filelist>
	<input type=hidden name=action value=edit>
	<input type=hidden name=eaction value=info>
	<input type=hidden name=clip value="">
	<tr><td></td><td>name</td><td>title</td><td>size</td><td>type</td><td>modified</td><td>move</td></tr>
	<?php
		if (count($children)) {
			foreach($children as $child)
				display_child($child);
		}
		else {
			echo "<tr class=rowodd><td colspan=30 align=center><i>---- none ----</i></td></tr>";
		}
	?>
	<tr><td align=left colspan=3 style="padding: 2px">
	<a class=button href="javascript:selectAll()" accesskey='a'>Select <u>A</u>ll</a>	
	<a class=button href="javascript:selectNone()" accesskey='u'><u>U</u>nselect All</a>
	</td>
	<td align=right colspan=20>
	<a class=button href="javascript:submitform('filelist','clip','new')" accesskey='n'><u>N</u>ew Page</a>
	<a class=button href="javascript:submitform('filelist','clip','cut')" accesskey='x'>Cut <u>X</u></a>
	<a class=button href="javascript:submitform('filelist','clip','copy')" accesskey='c'>Copy <u>C</u></a>
	<a class=button href="javascript:submitform('filelist','clip','paste')" accesskey='v'>Paste <u>V</u></a>
	<a class=button href="javascript:submitform('filelist','clip','delete')" accesskey='d'>Delete <u>D</u></a>
	</td>
	</tr>
	</form>
	</table>
	</div>

<div class=box><div class=section>Attachments</div>
	<table border=0 cellspacing=1 width="100%">
	<form action="<?=$action?>" method=post name=attachments>
	<input type=hidden name=action value=edit>
	<input type=hidden name=eaction value=info>
	<input type=hidden name=attachcmd value="">
	<tr><td></td><td>name</td><td>size</td><td>type</td><td>modified</td></tr>
	<?php
		$files = $page->attachments();
		if (count($files)) {
			foreach($files as $filedata)
				display_attachment($filedata);
		}
		else {
			echo "<tr class=rowodd><td colspan=30 align=center><i>---- none ----</i></td></tr>";
		}
	?>
	</form>
	<tr><td align=left colspan=3 style="padding: 2px">
<!--
<a class=button href="javascript:selectAll()">Select All</a>	
<a class=button href="javascript:selectNone()">Unselect All</a>
-->
	</td>
	<td align=right colspan=20>
		<a class=button href="javascript:submitform('attachments','attachcmd','delete')">Delete</a>
	</td>
	</tr>
	</table>
</div>
<br>
<div align=right>
	<form enctype="multipart/form-data" action="<?=$action?>" method="post">
	<input type=hidden name=action value=edit>
	<input type=hidden name=eaction value=info>
	<input type=hidden name=attachcmd value=upload>
	<input type="hidden" name="MAX_FILE_SIZE" value="4097152" />
	<input name="userfile" type="file" /> <input type="submit" value="Upload" />
    </form>
</div>