<?php

/************

LdapUserStore

Store users in ldap.

Example entry in b.site:
   userbackend = "ldap, <host>[:<port>] <base> <user-attr>"
   
   (quotes are needed if there is a = in the configuration line)
   
host: the host of the ldap search.
port: the port to connect to (optional).
base: the base of the directory information tree. 
user attr: what attribute to search for. ie uid, user, login, etc.

for example:
   userbackend = "ldap, macaw.riseup.net dc=riseup,dc=net uid"

*************/

$base = dirname(dirname(__FILE__));
require_once("$base/UserStore.php");

class LdapUserStore extends UserStore {

var $host;
var $port;
var $base;
var $attr;

function LdapUserStore($args) {
	$args = split(" ", $args);
	$host = split(":",$args[0]);
	if (isset($host[0])) $this->host = $host[0];
	if (isset($host[1])) $this->port = $host[1];
	if (empty($this->port))
		$this->port = 389;
	$this->base = $args[1];
	$this->attr = $args[2];
}

function authenticate($user,$pass,&$error) {
	$connection = ldap_connect($this->host,$this->port);
	if (!$connection) {
		$error = "Unable to connect to the directory server. (" . ldap_error($connection) .")";
		return false;
	}
	if (!ldap_set_option($connection, LDAP_OPT_PROTOCOL_VERSION, 3)) {
   		$error = "Failed to set protocol version to 3";
		return false;
	}

	$result = ldap_search( $connection, $this->base, $this->attr.'='.$user, array($this->attr));

	if (ldap_count_entries($connection,$result) == 0) {
		$error = _("User or password is incorrect");
		return false;
	} elseif (ldap_count_entries($connection,$result) > 1) {
		$error = _("More than one user has that login");
		return false;
	}

	$entries = ldap_get_entries($connection, $result);

	if ($entries[0]) {
		if ( @ldap_bind($connection, $entries[0]['dn'], $pass) ) {
			return true;
		} else {
			$error = _("User or password is incorrect") . " (" . ldap_error($connection) . ")";
			return false;
		}
	} else {
		 return "Unable to fetch user entry (" . ldap_error($connection) .")";
		 return false;
	}
}

} // end class

return;
?>
