/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <qtimer.h>

#include "global.h"
#include "basket.h"
#include "item.h"
#include "container.h"
#include "settings.h"
#include "onclickaction.h"
#include "clickcursorfeedback.h"

/** OnClickAction **/

void OnClickAction::startHoverFeedback(Item *item)
{
	const int copyCurShape = Qt::ArrowCursor;
	const int editCurShape = Qt::IbeamCursor; // TODO: If QT 4.0 allow the use of custom X cursors, use the "pencil" shape
	const int openCurShape = Qt::PointingHandCursor;

	int curShape;
	int ctrlCurShape;
	int altCurShape;

	switch (item->onClickActionPolicy()) {
		case 0:
			curShape     = copyCurShape;
			ctrlCurShape = editCurShape;
			altCurShape  = openCurShape;
			break;
		case 1:
			curShape     = editCurShape;
			ctrlCurShape = copyCurShape;
			altCurShape  = openCurShape;
			break;
		case 2:
			curShape     = openCurShape;
			ctrlCurShape = editCurShape;
			altCurShape  = copyCurShape;
			break;
	}

	Global::clickCursorFeedback->setWidget(item, curShape, ctrlCurShape, altCurShape);
}

static const int stopBH = 10;

void OnClickAction::stopHoverFeedback()
{
	Global::clickCursorFeedback->stopWidget();

	// Rational for the following 3 lines of code:
	//  When mouse go out of an item (leaveEvent), stopHoverFeedback() is called and
	//  resetStatusBarHint() could be called as well.
	//  But if the mouse leave an item to enter instantly another one, the statusbar
	//  flicker ("Click: foo..." THEN a short while "Clips basket." THEN just after "Click: foo...").
	// So, we processEvents() to execute the next enterEvent() if existing: the statusbar willn't flicker
	//  and the "Clips basket." state is skiped (feedbackedWidget() is set, so resetStatusBarHint() isn't executed).

/*	kapp->processEvents();
	if (Global::clickCursorFeedback->feedbackedWidget() == 0L)
		Global::mainContainer->resetStatusBarHint();*/

	// IT DOESN'T WORK:
	//  - stopHoverFeedback() called from leaveEvent()
	//  - kapp->processEvents() have not yet received enterEvent() and do nothing
	//  - Then resetStatusBarHint() is called
	//  - But, AFTER, startHoverFeedback() from enterEvent() is called
	// So, we use a QTimer to do the eventual resetStatusBarHint() more later
	QTimer::singleShot(stopBH, Global::mainContainer, SLOT(stopHoverFeedbackBH()));
}

void OnClickAction::feedbackShiftCursor(bool shiftPressed)
{
	Item *item = dynamic_cast<Item*>(Global::clickCursorFeedback->feedbackedWidget());
	if (item == 0L) // Improbable, but it's free :-)
		return;

	QString msg;
	QString copy = (shiftPressed == Settings::clickCopyToSelection() ?
		i18n("copy") :
		i18n("copy to selection"));
	QString edit = (shiftPressed ?
		i18n("edit meta-data") :
		i18n("edit"));
	QString open = (shiftPressed ?
		i18n("open with") :
		i18n("open"));

	if (Settings::singleClick()) {
		if (shiftPressed)
			msg = i18n("%x=copy|edit|open",
			           "Shift+click: %1, Shift+Ctrl+click: %2, Shift+Alt+click: %3.");
		else
			msg = i18n("%x=copy|edit|open",
			           "Click: %1, Ctrl+click: %2, Alt+click: %3. Press Shift for more.");
	} else {
		if (shiftPressed)
			msg = i18n("%x=copy|edit|open",
			           "Shift+double-click: %1, Shift+Ctrl+double-click: %2, Shift+Alt+double-click: %3.");
		else
			msg = i18n("%x=copy|edit|open",
			           "Double-click: %1, Ctrl+double-click: %2, Alt+double-click: %3. Press Shift for more.");
	}

	switch (item->onClickActionPolicy()) {
		case 0: msg = msg.arg(copy, edit, open); break;
		case 1: msg = msg.arg(edit, copy, open); break;
		case 2: msg = msg.arg(open, edit, copy); break;
	}

	Global::mainContainer->setStatusBarHint(msg);
}

/*int OnClickAction::whichCopy(bool shiftPressed) // bool copyToSel(bool shiftPressed)
{
	if (whichCopyAction(shiftPressed) == Copy)
		return 0;                               // 0: Copy to clipboard
	else // CopyToSel
		return 1;                               // 1: Copy to selection
}

QString OnClickAction::whichCopyName(bool shiftPressed)
{
	int copy = whichCopy(shiftPressed);

	switch (copy) {
		case 0: return i18n("Copy to clipboard"); // just "copy"
		case 1: return i18n("Copy to selection");
	}

	return 0;
}*/

OnClickAction::Action OnClickAction::whichCopyAction(bool shiftPressed)
{
	if (shiftPressed == Settings::clickCopyToSelection())
		return Copy;
	else
		return CopyToSel;
}

OnClickAction::Action OnClickAction::actionForButton(Qt::ButtonState state, int policy)
{
	if ((state & Qt::ControlButton) && (state & Qt::AltButton)) // FIXME: Really?
		return NoAction;
	else if (state & Qt::ControlButton) {
		if (state & Qt::ShiftButton) {
			switch (policy) {
				case 0: return EditAnnot;
				case 1: return whichCopyAction(true);
				case 2: return EditAnnot;
			}
		} else {
			switch (policy) {
				case 0: return Edit;
				case 1: return whichCopyAction(false);
				case 2: return Edit;
			}
		}
	} else if (state & Qt::AltButton) {
		if (state & Qt::ShiftButton) {
			switch (policy) {
				case 0: return OpenWith;
				case 1: return OpenWith;
				case 2: return whichCopyAction(true);
			}
		} else {
			switch (policy) {
				case 0: return Open;
				case 1: return Open;
				case 2: return whichCopyAction(false);
			}
		}
	} else {                                  // Simple click without hotkey
		if (state & Qt::ShiftButton) {
			switch (policy) {
				case 0: return whichCopyAction(true);
				case 1: return EditAnnot;
				case 2: return OpenWith;
			}
		} else {
			switch (policy) {
				case 0: return whichCopyAction(false);
				case 1: return Edit;
				case 2: return Open;
			}
		}
	}

	return NoAction;
}

/** OnClickActionCombo **/

/*OnClickActionCombo::OnClickActionCombo(int action, QWidget *parent, const char *name)
 : QComboBox(parent, name)
{
	insertItem(i18n("Click to copy, Ctrl+click to edit, Alt+click to open (Config 1)"));
	insertItem(i18n("Click to edit, Ctrl+click to copy, Alt+click to open (Config 2)"));
	insertItem(i18n("Click to open, Ctrl+click to edit, Alt+click to copy (Config 3)"));

	setCurrentItem(action);
}

OnClickActionCombo::~OnClickActionCombo()
{
}*/

#include "onclickaction.moc"
