;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Jvm/jdump.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 11 11:08:32 2000                          */
;*    Last change :  Tue Sep 16 12:14:23 2003 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Dump the last Bigloo abstract syntax tree in an ascii file       */
;*    following the syntax of the pre-JVM ast.                         */
;*    -------------------------------------------------------------    */
;*    The grammar for the JVMAST is:                                   */
;*                                                                     */
;*    Program = Module*                                                */
;*                                                                     */
;*    Module = name:String                                             */
;*             variables::Global*                                      */
;*             functions::Method*                                      */
;*             classes::Class*                                         */
;*                                                                     */
;*    Global = (:: Qualified Type)                                     */
;*                                                                     */
;*    Qualified = (@ name::String module::String)                      */
;*                                                                     */
;*    Local = (:: name::String Type)                                   */
;*                                                                     */
;*    Method = name::String                                            */
;*             typeret::Type                                           */
;*             param::(Var Type)*                                      */
;*             body::Expr                                              */
;*                                                                     */
;*    Class = name::String                                             */
;*            extends::Class                                           */
;*            fields::Field*                                           */
;*                                                                     */
;*    Field = (name::String type::Type)                                */
;*                                                                     */
;*    Expr = (GETLOCAL Local)                                          */
;*         | (SETLOCAL Local Expr)                                     */
;*         | (LET Local Expr Expr)                                     */
;*         | (LABEL ((LabVar (Var Type)* Expr)+) Expr)                 */
;*         | (GETGLOBAL Global)                                        */
;*         | (SETGLOBAL Global Expr)                                   */
;*         | (CALL Method Expr*)                                       */
;*         | (FUNCALL Expr Expr*)                                      */
;*         | (LABELCALL LabVar Expr*)                                  */
;*         | (IF Pred Expr Expr)                                       */
;*         | (OP2 Op Type Expr Expr)                                   */
;*         | (OP1 Op Type Expr)                                        */
;*         | (NEW Type)                                                */
;*         | (GETFIELD Field Type Expr)                                */
;*         | (SETFIELD Field Type Expr Expr)                           */
;*         | (ISA Type Expr)                                           */
;*         | (CONVERT Type Type Expr)                                  */
;*         | (VLEN Type Expr)                                          */
;*         | (VREF Type Expr Expr)                                     */
;*         | (VSET! Type Expr Expr Expr)                               */
;*         | (VNEW Type Expr)                                          */
;*                                                                     */
;*         | (INVOKESTATIC ...)                                        */
;*         | (INVOKEMETHOD ...)                                        */
;*         | (INVOKEINTERFACE ...)                                     */
;*         | (INVOKESPECIAL ...)                                       */
;*         | (ANEW Type Expr)                                          */
;*         | (PROTECT LabVar LabVar)                                   */
;*         | (THROW Expr)                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module jvm_jdump
   (include "Ast/unit.sch"
	    "Engine/pass.sch")
   
   (import type_type
	   type_typeof
	   ast_var
	   ast_node
	   ast_env
	   tools_shape
	   tools_error
	   object_class
	   engine_param
	   jvm_compile
	   jas_as
	   module_module
	   read_jvm
	   backend_c_main
	   backend_c_prototype)
   
   (export (jvm-dump ::pair-nil)))

;*---------------------------------------------------------------------*/
;*    jvm-dump ...                                                     */
;*---------------------------------------------------------------------*/
(define (jvm-dump globals)
   ;; the jvm prelude (hello message and *DEST* update)
   (pass-prelude "Jvm" start-jvm-emission!)
   (verbose 2 "      [module: " *module* " qualified type name: "
	    (module->qualified-type *module*) "]"#\Newline)
   ;; if we are going to link and we have not found a main yet, we
   ;; have to produce a fake one
   (if (and (not *main*) (memq *pass* '(ld distrib)))
       (set! *main* (make-bigloo-main)))
   ;; the jvm driver
   (define (emit classfile dest)
      (let ((dir *jvm-dir-name*))
	 (if (eq? *pass* 'jvmas)
	     (let ((port (if (not (string? dest))
			     (current-output-port)
			     (open-output-file
			      (string-append dir "/" dest)))))
		(jvmasdump classfile port)
		(if (not (eq? port (current-output-port)))
		    (close-output-port port)))
	     (let* ((cname (if (not (string? dest))
			       (string-append dir "/a.class")
			       (string-append dir "/" dest)))
		    (port (open-output-binary-file cname)))
		(if (not (binary-port? port))
		    (error "jvm-dump" "Can't open file for output" cname))
		(jvm-as classfile port)
		(close-binary-port port)))))
   (jvm-check-package *module* *jvm-dir-name*)
   (let ((l* (jvm-compile globals))
	 (bname (cond
		   ((eq? *pass* 'ld)
		    (if (pair? *src-files*)
			(addsuffix (prefix (basename (car *src-files*))))
			"a.class"))
		   ((not (string? *dest*))
		    (if (pair? *src-files*)
			(addsuffix (prefix (basename (car *src-files*))))
			#f))
		   (else
		    (addsuffix (prefix (basename *dest*)))))))
      (emit (car l*) bname)
      (for-each (lambda (cf) (emit cf (jasname cf)))
		(cdr l*) )))

;*---------------------------------------------------------------------*/
;*    jvm-check-package ...                                            */
;*    -------------------------------------------------------------    */
;*    We check that the class file name is compatible with the         */
;*    JVM qualified type name declared for the class.                  */
;*---------------------------------------------------------------------*/
(define (jvm-check-package module path)
   (define (compare-path? base path)
      (let ((lbase (string-length base))
	    (lpath (string-length path)))
	 (if (< lpath lbase)
	     #f
	     (let loop ((rpath (-fx lpath 1))
			(rbase (-fx lbase 1)))
		(if (=fx rbase -1)
		    #t
		    (let ((cbase (string-ref base rbase))
			  (cpath (string-ref path rpath)))
		       (if (or (char=? cbase cpath)
			       (and (char=? cpath #\/)
				    (char=? cbase #\.)))
			   (loop (-fx rpath 1) (-fx rbase 1))
			   #f)))))))
   (let* ((qtype (module->qualified-type module))
	  (base (let ((pre (prefix qtype)))
		   (cond
		      ((string=? pre "")
		       ".")
		      ((string=? pre qtype)
		       ".")
		      (else
		       pre)))))
      (if (not (compare-path? (jvm-filename base) path))
	  (warning "Incompatible package name and class path."
		   "Package name for module " *module* " is `" base
		   "', class path is `" path "'."))))

(define *jvm-dir-name* ".")

(define (jvmasdump classfile port)
   (let ((ow *pp-width*) (oc *pp-case*))
      (set! *pp-width* 1024)
      (set! *pp-case* 'lower)
      (pp classfile port)
      (set! *pp-case* oc)
      (set! *pp-width* ow)))

(define (addsuffix name)
   (string-append name
		  (case *pass*
		     ((jast)
		      ".jast")
		     ((jvmas)
		      ".jas")
		     (else
		      ".class"))))

(define (jasname cf)
   (match-case cf
      (((class ?name) . ?-)
       (addsuffix (symbol->string name)))))

;*---------------------------------------------------------------------*/
;*    jvm-filename ...                                                 */
;*---------------------------------------------------------------------*/
(define (jvm-filename name)
   (if (string? *jvm-directory*)
       (if (string=? name ".")
	   *jvm-directory*
	   (make-file-name *jvm-directory* name))
       name))

;*---------------------------------------------------------------------*/
;*    jvm-dirname ...                                                  */
;*---------------------------------------------------------------------*/
(define (jvm-dirname file)
   (let* ((dfile (dirname file))
	  (dir (jvm-filename dfile)))
      (if (and (not (string=? dfile ""))
	       (not (directory? dfile))
	       (not (file-exists? dfile))
	       (or (not (string? *jvm-directory*))
		   (directory? *jvm-directory*)))
	  ;; we create the necessary directories to put the JVM class file
	  (make-directories dir))
      dir))

;*---------------------------------------------------------------------*/
;*    start-jvm-emission! ...                                          */
;*---------------------------------------------------------------------*/
(define (start-jvm-emission!)
   (cond
      ((string? *dest*)
       (let ((dname (dirname *dest*)))
	  (if (not (string=? dname ""))
	      (set! *jvm-dir-name* (jvm-dirname *dest*)))))
      ((eq? *pass* 'ld)
       (if (pair? *src-files*)
	   (set! *jvm-dir-name* (jvm-dirname (car *src-files*))))))
   (if (not (and (file-exists? *jvm-dir-name*) (directory? *jvm-dir-name*)))
       (error "start-jvm-emission!"
	      "Can't write dest file because directory doesn't exist"
	      *jvm-dir-name*)
       #t))
