;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/Llib/_thread.sch         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun  1 07:26:08 2003                          */
;*    Last change :  Wed Mar 24 16:00:08 2004 (serrano)                */
;*    Copyright   :  2003-04 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The declaration of the external thread bindings                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directive                                                    */
;*---------------------------------------------------------------------*/
(directives

   (extern (include "bglthread.h")

	   ;; fair threads
	   (type $bglthread (opaque) "bglthread_t")
	   (macro $bglthread-new::$bglthread (::procedure)
		  "bglthread_new")
	   (macro $bglthread-new/name::$bglthread (::procedure ::symbol)
		  "bglthread_new_with_name")
	   (macro $bglthread-id-set!::obj (::$bglthread ::obj)
		  "bglthread_id_set")
	   (macro $bglthread-setup!::void (::$bglthread ::obj)
		  "bglthread_setup")
	   (macro $bglthread-start::void (::$bglthread)
		  "bglthread_start")
	   (macro $bglthread-wait::void (::$bglthread)
		  "bglthread_wait")
	   (macro $bglthread-switch::void (::$bglthread ::$bglthread)
		  "bglthread_switch")
	   (macro $bglthread-enter-scheduler::void (::$bglthread)
		  "bglthread_enter_scheduler")
	   (macro $bglthread-leave-scheduler::void (::$bglthread)
		  "bglthread_leave_scheduler")
	   
	   ;; asynchronous threads
	   (macro $bglasync-spawn::void (::$bglthread ::procedure ::obj)
		  "bglasync_spawn")
	   (macro $bglasync-synchronize::void (::$bglthread)
		  "bglasync_synchronize")
	   (macro $bglasync-asynchronize::void (::$bglthread)
		  "bglasync_asynchronize")
	   
	   (macro $bglasync-scheduler-wait::void (::$bglthread)
		  "bglasync_scheduler_wait")
	   (macro $bglasync-scheduler-notify::void (::$bglthread)
		  "bglasync_scheduler_notify"))
   
   (java   ;; fair threads
	   (class $bglthread
	      (constructor new (::procedure))
	      (constructor new/name (::procedure ::symbol))
	      (method setup!::void (::$bglthread ::obj) "setup")
	      (method id-set!::obj (::$bglthread ::obj) "idSet")
	      (method start::void (::$bglthread) "start")
	      (method wait::void (::$bglthread) "fairWait")
	      (method switch::void (::$bglthread ::$bglthread) "fairSwitch")
	      (method enter-scheduler::void (::$bglthread) "enter_scheduler")
	      (method leave-scheduler::void (::$bglthread) "leave_scheduler")
	      "bigloo.fairthread.BglThread")

	   ;; asynchronous threads
	   (class $bglasync
	      (constructor spawn (::$bglthread ::procedure ::obj))
	      (method static synchronize::obj (::$bglthread ::procedure)
		      "synchronize")
	      (method static scheduler-wait::void (::$bglthread)
		      "scheduler_wait")
	      (method static scheduler-notify::void (::$bglthread)
		      "scheduler_notify")
	      "bigloo.fairthread.BglAsync")))

   
   
 
