;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/eval.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Oct 22 09:34:28 1994                          */
;*    Last change :  Wed Apr 14 17:00:16 2004 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'evaluateur de Bigloo                                           */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/eval.texi@                                */
;*       @node Eval@                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __eval

   (export  (eval <expression> . <env>)
	    (scheme-report-environment <version>)
	    (null-environment <version>)
	    (interaction-environment)
	    *load-verbose*
	    (load <string>)
	    (loadq <string>)
	    (loada <string>)
	    (repl)
	    (c-debug-repl ::obj)
	    (quit)
	    (module-declaration! decls)
	    (expand-define-macro <expression> <expander>)
	    (expand-define-hygiene-macro <expression> <expander>)
	    (expand-define-expander <expression> <expander>)
	    (expand-define-pattern <expression>)
	    (set-prompter! ::procedure)
	    (get-prompter::procedure)
	    *load-path*
	    *user-pass-name*
	    *user-pass*
	    (notify-assert-fail vars body loc)
	    *nil*
	    (transcript-on ::bstring)
	    (transcript-off)
	    (default-repl-error-notifier proc obj msg)
	    (set-repl-printer! ::procedure)
	    (native-repl-printer::procedure)
	    (set-repl-error-notifier! ::procedure)
	    (get-repl-error-notifier::procedure))
   
   (import  __type
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    
	    __pp_circle
	    
	    __reader
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __macro
	    __install_expanders
	    __progn
	    __expand
	    __evcompile
	    __evmeaning
	    __everror
	    __evprimop
	    __evenv
	    (extend.r.macro-env __match_normalize))

   (eval    (export *c-debug-repl-value*))
   
   (extern  (export c-debug-repl "bgl_debug_repl")

	    (reset-console!::obj (::obj) "reset_console")
	    (macro sigsetmask::int (::int) "sigsetmask")
	    (macro sigint::int "SIGINT"))
   
   (java    (class foreign
	       (method static reset-console!::obj (::obj) "reset_console")
	       (method static sigsetmask::int (::int) "sigsetmask")
	       (field static sigint::int "SIGINT"))))

;*---------------------------------------------------------------------*/
;*    Expanders setup.                                                 */
;*---------------------------------------------------------------------*/
(install-all-expanders!)

;*---------------------------------------------------------------------*/
;*    eval ...                                                         */
;*---------------------------------------------------------------------*/
(define (eval exp . environment)
   (let* ((env  (if (pair? environment)
		    (let ((env (car environment)))
		       (if (not (or (eq? env (scheme-report-environment 5))
				    (eq? env (null-environment 5))
				    (interaction-environment)))
			   (error "eval" "Illegal environment" environment)
			   env))
		    (interaction-environment)))
	  (loc  (find-loc exp #f))
	  (sexp  (if (procedure? *user-pass*) (*user-pass* exp) exp)))
      (evmeaning-reset-error!)
      (evmeaning (evcompile (expand sexp) '() env 'nowhere #f #t loc) '())))

;*---------------------------------------------------------------------*/
;*    scheme-report-environment ...                                    */
;*---------------------------------------------------------------------*/
(define (scheme-report-environment version)
   (if (=fx version 5)
       'scheme-report-environment
       (error "scheme-report-environment"
	      "Version not supported"
	      version)))
   
;*---------------------------------------------------------------------*/
;*    null-environment ...                                             */
;*---------------------------------------------------------------------*/
(define (null-environment version)
   (if (=fx version 5)
       'null-environment
       (error "scheme-report-environment"
	      "Version not supported"
	      version)))
   
;*---------------------------------------------------------------------*/
;*    interaction-environment ...                                      */
;*---------------------------------------------------------------------*/
(define (interaction-environment)
   'interaction-environment)
   
;*---------------------------------------------------------------------*/
;*    prompt ...                                                       */
;*---------------------------------------------------------------------*/
(define *prompt* (lambda (num)
		    (display num)
		    (display ":=> ")
		    (flush-output-port (current-output-port))))

;*---------------------------------------------------------------------*/
;*    repl-notify-error ...                                            */
;*---------------------------------------------------------------------*/
(define (repl-notify-error proc msg obj)
   ((if (procedure? *repl-error-notifier*)
	*repl-error-notifier*
	default-repl-error-notifier)
    proc msg obj))

;*---------------------------------------------------------------------*/
;*    default-repl-error-notifier ...                                  */
;*---------------------------------------------------------------------*/
(define (default-repl-error-notifier proc msg obj)
   (evmeaning-notify-error proc msg obj)
   (flush-output-port (current-error-port)))
   
;*---------------------------------------------------------------------*/
;*    *repl-error-notifier* ...                                        */
;*---------------------------------------------------------------------*/
(define *repl-error-notifier* default-repl-error-notifier)

;*---------------------------------------------------------------------*/
;*    set-repl-error-notifier! ...                                     */
;*---------------------------------------------------------------------*/
(define (set-repl-error-notifier! notifier::procedure)
   (if (=fx (procedure-arity notifier) 3)
       (set! *repl-error-notifier* notifier)
       (error "set-repl-error-notifier!" "Illegal notifier" notifier)))

;*---------------------------------------------------------------------*/
;*    get-repl-error-notifier ...                                      */
;*---------------------------------------------------------------------*/
(define (get-repl-error-notifier::procedure)
   *repl-error-notifier*)

;*---------------------------------------------------------------------*/
;*    set-prompter! ...                                                */
;*---------------------------------------------------------------------*/
(define (set-prompter! proc)
   (if (not (correct-arity? proc 1))
       (error "set-prompter!"
	      "argument has to be a procedure of 1 argument"
	      proc)
       (set! *prompt* proc)))

;*---------------------------------------------------------------------*/
;*    get-prompter ...                                                 */
;*---------------------------------------------------------------------*/
(define (get-prompter::procedure)
   *prompt*)

;*---------------------------------------------------------------------*/
;*    Global repl parameters ...                                       */
;*---------------------------------------------------------------------*/
(define *repl-num* 0)
(define *repl-quit* (lambda (x) (%exit x)))

;*---------------------------------------------------------------------*/
;*    repl ...                                                         */
;*---------------------------------------------------------------------*/
(define (repl)
   (let ((repl-quit *repl-quit*)
	 (repl-num  *repl-num*))
      (bind-exit (quit)
	 (set! *repl-quit* quit)
	 (set! *repl-num* (+fx 1 *repl-num*))
	 (unwind-protect
	    (internal-repl)
	    (begin
	       (set! *repl-num* repl-num)
	       (set! *repl-quit* repl-quit))))
      (newline)
      (flush-output-port (current-output-port))))

;*---------------------------------------------------------------------*/
;*    internal-repl ...                                                */
;*---------------------------------------------------------------------*/
(define (internal-repl)
   (let ((old-intrhdl (get-signal-handler sigint)))
      (unwind-protect
	 (let loop ()
	    (bind-exit (re-enter-internal-repl)
	       ;; we setup ^C interupt
	       (letrec ((intrhdl (lambda (n)
				    (notify-interrupt n)
				    ;; we flush current input port
				    (reader-reset!)
				    (reset-console! (current-input-port))
				    ;; we restore signal handling
				    (sigsetmask 0)
				    (signal n intrhdl)
				    (re-enter-internal-repl #unspecified))))
		  (signal sigint intrhdl))
	       ;; and we loop until eof
	       (newline)
	       (let loop ()
		  (*prompt* *repl-num*)
		  (let ((exp (try (read)
				  (lambda (escape proc msg obj)
				     (evmeaning-reset-error!)
				     (repl-notify-error proc msg obj)
				     (if (eof-object? obj)
					 (reset-eof (current-input-port)))
				     (sigsetmask 0)
				     (escape #unspecified)))))
		     (if (eof-object? exp)
			 (quit)
			 (let ((v (try (eval exp)
				       (lambda (escape proc msg obj)
					  (repl-notify-error proc msg obj)
					  (sigsetmask 0)
					  (escape #unspecified)))))
			    (if (not (eq? *transcript* (current-output-port)))
				(fprint *transcript* ";; " exp))
			    (*repl-printer* v *transcript*)
			    (newline *transcript*)
			    (set! exp #unspecified)
			    (loop))))))
	    (loop))
	 (if (procedure? old-intrhdl)
	     (signal sigint old-intrhdl)))))

;*---------------------------------------------------------------------*/
;*    default-repl-printer ...                                         */
;*---------------------------------------------------------------------*/
(define (default-repl-printer exp . port)
   (apply display-circle exp port))

;*---------------------------------------------------------------------*/
;*    *repl-printer* ...                                               */
;*---------------------------------------------------------------------*/
(define *repl-printer* default-repl-printer)

;*---------------------------------------------------------------------*/
;*    set-repl-printer! ...                                            */
;*---------------------------------------------------------------------*/
(define (set-repl-printer! disp)
   (if (not (correct-arity? disp -2))
       (error "set-repl-printer!" "Illegal repl-printer (wrong arity)" disp)
       (let ((old *repl-printer*))
	  (set! *repl-printer* disp)
	  old)))

;*---------------------------------------------------------------------*/
;*    native-repl-printer ...                                          */
;*---------------------------------------------------------------------*/
(define (native-repl-printer)
   default-repl-printer)

;*---------------------------------------------------------------------*/
;*    *c-debug-repl-value* ...                                         */
;*---------------------------------------------------------------------*/
(define *c-debug-repl-value* #unspecified)

;*---------------------------------------------------------------------*/
;*    c-debug-repl ...                                                 */
;*---------------------------------------------------------------------*/
(define (c-debug-repl val)
   (set! *c-debug-repl-value* val)
   (let loop ()
      (display "?* ")
      (let ((exp (read)))
	 (unless (eof-object? exp)
	    (print (eval exp))
	    (loop)))))

;*---------------------------------------------------------------------*/
;*    quit ...                                                         */
;*---------------------------------------------------------------------*/
(define (quit)
   (*repl-quit* 0))

;*---------------------------------------------------------------------*/
;*    *load-path*                                                      */
;*---------------------------------------------------------------------*/
(define *load-path* '())

;*---------------------------------------------------------------------*/
;*    find-file ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-file name)
   (if (not (string? name))
       (error "find-file" "Illegal file name" name)
       (if (file-exists? name)
	   name
	   (let loop ((path *load-path*))
	      (if (null? path)
		  name
		  (let ((try (string-append (car path) "/" name)))
		     (if (file-exists? try)
			 try
			 (loop (cdr path)))))))))

;*---------------------------------------------------------------------*/
;*    *load-verbose* ...                                               */
;*---------------------------------------------------------------------*/
(define *load-verbose* #t)

;*---------------------------------------------------------------------*/
;*    load ...                                                         */
;*---------------------------------------------------------------------*/
(define (load file-name)
   (loadv file-name *load-verbose*))

(define (loadq file-name)
   (loadv file-name #f))

(define (loadv file-name v?)
   (let* ((path (find-file file-name))
	  (port (open-input-file path)))
      (reader-reset!)
      (evmeaning-reset-error!)
      (if (input-port? port)
	  (try (let loop ((sexp         (read port #t))
			  (module-seen? #f)
			  (main         #f))
		  (cond
		     ((eof-object? sexp)
		      (close-input-port port)
		      (let ((pmain (if (symbol? main)
				       (eval main)
				       #f)))
			 (if (procedure? pmain)
			     (pmain (command-line)))
			 path))
		     ((and (pair? sexp) (eq? (car sexp) 'module))
		      (if module-seen?
			  (error "load" "module defined twice" sexp)
			  (let ((main (assq 'main (cddr sexp))))
			     (let ((v (eval sexp)))
				(if v?
				    (begin
				       (display-circle v)
				       (newline)))
				(loop (read port #t)
				      #t
				      (if (pair? main)
					  (cadr main)
					  v))))))
		     (else
		      (let ((v (eval sexp)))
			 (evmeaning-reset-error!)
			 (if v?
			     (begin
				(display-circle v)
				(newline)))
			 (loop (read port #t)
			       module-seen?
			       main)))))
	       (lambda (escape proc mes obj)
		  ;; on imprime le message d'erreur
		  (repl-notify-error proc mes obj)
		  (error "load"
			 "error occured when loading"
			 file-name)))
	  (error "load" "Can't open file" file-name))))

;*---------------------------------------------------------------------*/
;*    loada ...                                                        */
;*---------------------------------------------------------------------*/
(define (loada file)
   (let ((port (open-input-file file)))
      (if (input-port? port)
	  (begin
	     (set! *afile-list* (append (read port #t) *afile-list*))
	     (close-input-port port)
	     file)
	  (error "loada" "Can't open file" file))))
   
;*---------------------------------------------------------------------*/
;*    On met dans ce fichier les definitions de                        */
;*    `expand-define-expander' et `expand-define-macro' car elles      */
;*    contiennent des appels a `Eval'.                                 */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    expand-define-expander ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-define-expander x e)
   (match-case x
      ((?- (and (? symbol?) ?name) . ?macro)
       (let* ((expd-lam     (normalize-progn macro))
	      (expd-lam/loc (replace! x expd-lam))
	      (expd-eval    (eval expd-lam/loc)))
	  (install-expander
	   name
	   (lambda (x e)
	      (if (not (procedure? expd-eval))
		  (error name "illegal expander" macro)
		  (if (not (correct-arity? expd-eval 2))
		      (error name "wrong number of argument for expand" macro)
		      (try (expd-eval x e)
			   (lambda (escape proc mes obj)
			      (repl-notify-error proc mes obj)
			      (error "expand"
				     "error occured while expansing the call"
				     x))))))))
       (unspecified))
      (else
       (error "define-expander" "Illegal `define-expander' syntax" x))))

;*---------------------------------------------------------------------*/
;*    expand-define-macro ...                                          */
;*---------------------------------------------------------------------*/
(define (expand-define-macro x e)
   (match-case x
      ((or (?- (?name . ?args) . ?body)
	   (?- ?name (lambda ?args . ?body)))
       (install-expander
	name
	(let* ((expd-lam     `(lambda (x e)
				 (e (let ,(destructure args '(cdr x) '())
				       ,(normalize-progn body))
				    e)))
	       (expd-lam/loc (replace! x expd-lam))
	       (expd-eval    (eval expd-lam/loc)))
	   (lambda (x e)
	      (try (expd-eval x e) 
		   (lambda (escape proc mes obj)
		      (repl-notify-error proc mes obj)
		      (error "expand"
			     "error occured while expansing the call"
			     x))))))
       (unspecified))
      (else
       (error "define-macro" "Illegal `define-macro' syntax" x))))

;*---------------------------------------------------------------------*/
;*    expand-define-hygiene-macro ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-define-hygiene-macro x e)
   (match-case x
      ((?- (quote (?name . ?args)) . ?body)
       (let ((body (map cadr body)))
	  (install-expander
	   name
	   (let* ((expd-lam     `(lambda (x e)
				    (e (let ,(destructure args '(cdr x) '())
					  ,(normalize-progn body))
				       e)))
		  (expd-lam/loc (replace! x expd-lam))
		  (expd-eval    (eval expd-lam/loc)))
	      (lambda (x e)
		 (try (expd-eval x e) 
		      (lambda (escape proc mes obj)
			 (repl-notify-error proc mes obj)
			 (error "expand"
				"error occured while expansing the call"
				x))))))
	  (unspecified)))
      (else
       (error "define-macro" "Illegal `define-macro' syntax" x))))

;*---------------------------------------------------------------------*/
;*    destructure ...                                                  */
;*---------------------------------------------------------------------*/
(define (destructure pat arg bindings)
   (cond
      ((null? pat)
       (cons `(,(gensym '.dummy.)
	       (if (not (null? ,arg))
		   (error "expand" "Too many arguments provided" ,arg)
		   '()))
	     bindings))
      ((symbol? pat)
       (cons `(,pat ,arg) bindings))
      ((pair? pat)
       (destructure (car pat)
		    `(car ,arg)
		    (destructure (cdr pat)
				 `(cdr ,arg)
				 bindings)))
      (else
       (error "expand" "Illegal macro parameter" pat))))

;*---------------------------------------------------------------------*/
;*    module-declaration! ...                                          */
;*---------------------------------------------------------------------*/
(define (module-declaration! decls)
   (let loop ((decls decls))
      (cond
	 ((null? decls)
	  'done)
	 ((not (pair? (car decls)))
	  (error "eval" "Illegal module declaration" decls))
	 ((eq? (car (car decls)) 'include)
	  (include! (cdr (car decls)))
	  (loop (cdr decls)))
	 ((eq? (car (car decls)) 'import)
	  (import! (cdr (car decls)))
	  (loop (cdr decls)))
	 ((eq? (car (car decls)) 'load)
	  (import! (cdr (car decls)))
	  (loop (cdr decls)))
	 (else
	  (loop (cdr decls))))))

;*---------------------------------------------------------------------*/
;*    *files* ...                                                      */
;*---------------------------------------------------------------------*/
(define *included-files* '())
(define *imported-files* '())
(define *afile-list*     '())

;*---------------------------------------------------------------------*/
;*    include! ...                                                     */
;*---------------------------------------------------------------------*/
(define (include! includes)
   (for-each (lambda (i)
		(if (not (member i *included-files*))
		    (begin
		       (set! *included-files* (cons i *included-files*))
		       (loadq i))))
	     includes))

;*---------------------------------------------------------------------*/
;*    import! ...                                                      */
;*---------------------------------------------------------------------*/
(define (import! iclauses)
   (let ((l (map (lambda (i)
		     (match-case i
			((?- ?second)
			 (if (string? second)
			     second
			     (let ((cell (assq second *afile-list*)))
				(if (pair? cell)
				    (cadr cell)
				    #f))))
			((?- ?- ?third)
			 third)
			(?module
			 (let ((cell (assq module *afile-list*)))
			    (if (pair? cell)
				(cadr cell)
				#f)))
		 	(else
			 #f)))
		  iclauses)))
      (for-each (lambda (i)
		   (if (and (string? i)
			    (not (member i *imported-files*)))
		       (begin
			  (set! *imported-files* (cons i *imported-files*))
			  (loadq i))))
		l)))

;*---------------------------------------------------------------------*/
;*    expand-define-pattern ...                                        */
;*---------------------------------------------------------------------*/
(define (expand-define-pattern x)
   (match-case x
      ((?- ?name ?var ?body)
       (extend.r.macro-env name (eval `(lambda ,var ,body)))
       ''dummy)
      (else
       (error "expand-define-pattern" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    notify-assert-fail ...                                           */
;*---------------------------------------------------------------------*/
(define (notify-assert-fail vars fail-body loc)
   (let ((port (current-error-port)))
      (try (if (pair? loc)
	       (error/location "assert"
			       "assertion failed"
			       fail-body
			       (car loc)
			       (cdr loc))
	       (error "assert"
		      "assertion failed"
		      fail-body))
	   (lambda (escape proc mes obj)
	      (notify-error proc mes obj)
	      (escape #unspecified)))
      (fprint port "-----------------------")
      (fprint port "Variables' value are : ")
      (for-each (lambda (f)
		   (display "   " port)
		   (display f port)
		   (display " : " port)
		   (*repl-printer* (eval f) port)
		   (newline port))
		vars)
      (fprint port "-----------------------")
      (let ((old-prompter (get-prompter)))
	 (set-prompter! (lambda (num) (display "*:=> ")))
	 (repl)
	 (set-prompter! old-prompter))))

;*---------------------------------------------------------------------*/
;*    *nil* ...                                                        */
;*---------------------------------------------------------------------*/
(define *nil* #t)

;*---------------------------------------------------------------------*/
;*    *user-pass* ...                                                  */
;*---------------------------------------------------------------------*/
(define *user-pass*      (unspecified))  ;; l'eventuelle user passe 
(define *user-pass-name* "User")         ;; le nom de la user pass

;*---------------------------------------------------------------------*/
;*    *transcript* ...                                                 */
;*---------------------------------------------------------------------*/
(define *transcript* (current-output-port))

;*---------------------------------------------------------------------*/
;*    transcript-on ...                                                */
;*---------------------------------------------------------------------*/
(define (transcript-on file::bstring)
   (if (not (eq? *transcript* (current-output-port)))
       (error "transcript-on" "A transcript is already in use" *transcript*)
       (begin
	  (set! *transcript* (append-output-file file))
	  (fprint *transcript* ";; session started on " (date))
	  #unspecified)))

;*---------------------------------------------------------------------*/
;*    transcript-off ...                                               */
;*---------------------------------------------------------------------*/
(define (transcript-off)
   (if (eq? *transcript* (current-output-port))
       (error "transcript-off"
	      "No transcript is currently in use"
	      *transcript*)
       (begin
	  (close-output-port *transcript*)
	  (set! *transcript* (current-output-port))))
   #unspecified)
   
