
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <list>
#include "glow.gtk.h"
#include "glow.image.h"

static char *gtk_signal_strings[]={
  "activate",
  "button_press_event",
  "button_release_event",
  "changed",
  "clicked",
  "delete_event",
  "destroy",
  "enter",
  "leave",
  "motion_notify_event",
  "pressed",
  "released",
  "select_row",
  "switch_page",
  "toggled",
  "unselect_row"
};

gboolean Gtk::AutoShow=TRUE;

GdkWindow * Gtk::oh_my=NULL;

Gtk::Gtk() {
  recipient=NULL;
}

void Gtk::Init(int *argc,char ***argv) {
  GtkWidget *wi;
  
  gtk_init(argc,argv);
  gdk_rgb_init();

  wi=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize(wi);
  oh_my=wi->window;
}

void Gtk::Main() {
  gtk_main();
}

void Gtk::MainIteration() {
  gtk_main_iteration();
}

void Gtk::MainQuit() {
  gtk_main_quit();
}

gint Gtk::EventsPending() {
  return(gtk_events_pending());
}

void Gtk::forward(Gtk *dest) {
  recipient=dest;
}

void Gtk::connect(GlowGtkSignal signal) {
  GtkSignalFunc gsf;

  switch(signal) {
  case GSPressedAt:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_pressed_at);
    break;
  case GSReleasedAt:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_released_at);
    break;
  case GSMotion:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_motion);
    break;
  case GSSwitchPage:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_switch_page);
    break;
  case GSSelectRow:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_select_row);
    break;
  case GSUnselectRow:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_unselect_row);
    break;
  case GSActivate:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_activate);
    break;
  case GSChanged:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_changed);
    break;
  case GSClicked:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_clicked);
    break;
  case GSEnter:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_enter);
    break;
  case GSLeave:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_leave);
    break;
  case GSPressed:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_pressed);
    break;
  case GSReleased:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_released);
    break;
  case GSToggled:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_toggled);
    break;
  case GSDelete:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_delete);
    break;
  case GSDestroy:
    gsf=GTK_SIGNAL_FUNC(GlowGtk_callback_destroy);
    break;
  default:
    return;
  }
  
  gtk_signal_connect(me,gtk_signal_strings[(int)signal],
		     gsf,(gpointer)this);
}

GtkObject * Gtk::getMe() {
  return(me);
}

/* virtuals */

void Gtk::activated() { activated(getId()); }
void Gtk::changed() { changed(getId()); }
void Gtk::clicked() { clicked(getId()); }
void Gtk::pressed() { pressed(getId()); }
void Gtk::released() { released(getId()); }
void Gtk::enter() { enter(getId()); }
void Gtk::leave() { leave(getId()); }

void Gtk::pressedAt(GdkEventButton *geb) { pressedAt(getId(),geb); }
void Gtk::releasedAt(GdkEventButton *geb) { releasedAt(getId(),geb); }
void Gtk::motion(GdkEventMotion *gem) { motion(getId(),gem); }

void Gtk::destroyed() { destroyed(getId()); }

gint Gtk::deleted() { return(deleted(getId())); }
void Gtk::toggled() { toggled(getId()); }

void Gtk::rowSelected(int row,int column,GdkEventButton *geb) { 
  rowSelected(getId(),row,column,geb);
}
void Gtk::rowUnselected(int row,int column,GdkEventButton *geb) { 
  rowUnselected(getId(),row,column,geb);
}

void Gtk::pageSwitched(gint pagenum) {
  pageSwitched(getId(),pagenum);
}

void Gtk::pageSwitched(int id,gint pagenum) {
  if (recipient!=NULL)
    recipient->pageSwitched(id,pagenum);
}

void Gtk::activated(int id) {
  if (recipient!=NULL)
    recipient->activated(id);
}

void Gtk::changed(int id) {
  if (recipient!=NULL)
    recipient->changed(id);
}

void Gtk::clicked(int id) {
  if (recipient!=NULL)
    recipient->clicked(id);
}

void Gtk::pressed(int id) {
  if (recipient!=NULL)
    recipient->pressed(id);
}

void Gtk::released(int id) {
  if (recipient!=NULL)
    recipient->released(id);
}

void Gtk::enter(int id) {
  if (recipient!=NULL)
    recipient->enter(id);
}

void Gtk::leave(int id) {
  if (recipient!=NULL)
    recipient->leave(id);
}

void Gtk::destroyed(int id) {
  if (recipient!=NULL)
    recipient->destroyed(id);
}

void Gtk::toggled(int id) {
  if (recipient!=NULL)
    recipient->toggled(id);
}

gint Gtk::deleted(int id) {
  if (recipient!=NULL)
    return(recipient->deleted(id));
  return 0;
}

void Gtk::pressedAt(int id,GdkEventButton *geb) {
  if (recipient!=NULL)
    return(recipient->pressedAt(id,geb));
}

void Gtk::motion(int id,GdkEventMotion *gem) {
  if (recipient!=NULL)
    return(recipient->motion(id,gem));
}

void Gtk::releasedAt(int id,GdkEventButton *geb) {
  if (recipient!=NULL)
    return(recipient->releasedAt(id,geb));
}

void Gtk::rowSelected(int id,int row,int column,GdkEventButton *geb) {
  if (recipient!=NULL)
    recipient->rowSelected(id,row,column,geb);
}

void Gtk::rowUnselected(int id,int row,int column,GdkEventButton *geb) {
  if (recipient!=NULL)
    recipient->rowUnselected(id,row,column,geb);
}

void Gtk::clicked(int idt,int idb) {
  if (recipient!=NULL)
    recipient->clicked(idt,idb);
}

/* callbacks */

void GlowGtk_callback_activate(GtkWidget *w,gpointer data) {
  ((Gtk *)data)->activated();
}

gint GlowGtk_callback_delete(GtkWidget *w,GdkEvent *e,gpointer data) {
  return(((Gtk *)data)->deleted());
}

void GlowGtk_callback_destroy(GtkWidget *w,gpointer data) {
  ((Gtk *)data)->destroyed();
}

void GlowGtk_callback_clicked(GtkButton *w,gpointer data) {
  ((Gtk *)data)->clicked();
}

void GlowGtk_callback_enter(GtkButton *w,gpointer data) {
  ((Gtk *)data)->enter();
}

void GlowGtk_callback_leave(GtkButton *w,gpointer data) {
  ((Gtk *)data)->leave();
}

void GlowGtk_callback_pressed(GtkButton *w,gpointer data) {
  ((Gtk *)data)->pressed();
}

void GlowGtk_callback_released(GtkButton *w,gpointer data) {
  ((Gtk *)data)->released();
}

void GlowGtk_callback_toggled(GtkToggleButton *w,gpointer data) {
  ((Gtk *)data)->toggled();
}

void GlowGtk_callback_changed(GtkEditable *w,gpointer data) {
  ((Gtk *)data)->changed();
}

void GlowGtk_callback_select_row(GtkCList *w,gint row,
			       gint column,GdkEventButton *geb,
			       gpointer data) {
  ((Gtk *)data)->rowSelected(row,column,geb);
}

void GlowGtk_callback_unselect_row(GtkCList *w,gint row,
				 gint column,GdkEventButton *geb,
				 gpointer data) {
  ((Gtk *)data)->rowUnselected(row,column,geb);
}

void GlowGtk_callback_switch_page(GtkNotebook *w,
				  GtkNotebookPage *np,
				  gint pagenum,
				  gpointer data) {
  ((Gtk *)data)->pageSwitched(pagenum);
}

gboolean GlowGtk_callback_pressed_at(GtkWidget *w,
				     GdkEventButton *geb,
				     gpointer data) {
  ((Gtk *)data)->pressedAt(geb);
  return FALSE;
}

gboolean GlowGtk_callback_released_at(GtkWidget *w,
				      GdkEventButton *geb,
				      gpointer data) {
  ((Gtk *)data)->releasedAt(geb);
  return FALSE;
}

gboolean GlowGtk_callback_motion(GtkWidget *w,
				 GdkEventMotion *gem,
				 gpointer data) {
  ((Gtk *)data)->motion(gem);
  return FALSE;
}

/* abstract box */

Box::Box() {
  Expand=FALSE;
  Fill=TRUE;
  Gap=0;
}

void Box::packStart(Widget *w) {
  packStart(w,Expand,Fill,Gap);
}

void Box::packEnd(Widget *w) {
  packEnd(w,Expand,Fill,Gap);
}

void Box::packStart(Widget *w,gboolean expand,gboolean fill,gint gap) {
  gtk_box_pack_start(GTK_BOX(getMe()),GTK_WIDGET(w->getMe()),
		     expand,fill,gap);
}

void Box::packEnd(Widget *w,gboolean expand,gboolean fill,gint gap) {
  gtk_box_pack_end(GTK_BOX(getMe()),GTK_WIDGET(w->getMe()),
		     expand,fill,gap);
}

/* vbox */

VBox::VBox(gboolean homogeneous,int spacing) : Box() {
  GtkWidget *I;
  I=gtk_vbox_new(homogeneous,spacing);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

void VBox::be_abstract() { }

/* hbox */

HBox::HBox(gboolean homogeneous,int spacing) {
  GtkWidget *I;
  I=gtk_hbox_new(homogeneous,spacing);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

void HBox::be_abstract() { }

// label

Label::Label(char *s) : Widget() {
  GtkWidget *I;

  I=gtk_label_new(s);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

void Label::setText(char *s) {
  gtk_label_set_text(GTK_LABEL(getMe()),s);
}

void Label::setJustify(GtkJustification just) {
  gtk_label_set_justify(GTK_LABEL(getMe()),just);
}

// separators

HSeparator::HSeparator() {
  GtkWidget *I;
  I=gtk_hseparator_new();
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

VSeparator::VSeparator() {
  GtkWidget *I;
  I=gtk_vseparator_new();
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

// button

Button::Button() {
  GtkWidget *I;
  I=gtk_button_new();
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();
}

Button::Button(char *s) : Container() {
  GtkWidget *I;
  I=gtk_button_new_with_label(s);
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();
}

Button::Button(int nda,int ndb) : Container() {

}

void Button::attachSignals() {
  connect(GSClicked);
  connect(GSPressed);
  connect(GSReleased);
  connect(GSEnter);
  connect(GSLeave);
}

void Button::be_abstract() { }

// toggle button

ToggleButton::ToggleButton() : Button(666,999) {
  GtkWidget *I;

  I=gtk_toggle_button_new();
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();
}

ToggleButton::ToggleButton(char *s) : Button(666,999) {
  GtkWidget *I;

  I=gtk_toggle_button_new_with_label(s);
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();
}

ToggleButton::ToggleButton(int nda,int ndb) : Button(nda,ndb) {

}

void ToggleButton::setActive(gboolean v) {
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(getMe()),v);
}

gboolean ToggleButton::getActive() {
  return(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(getMe())));
}

void ToggleButton::attachSignals() {
  Button::attachSignals();
  connect(GSToggled);
}

// check button

CheckButton::CheckButton() : ToggleButton(666,999) {
  GtkWidget *I;

  I=gtk_check_button_new();
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();  
}

CheckButton::CheckButton(char *s) : ToggleButton(666,999) {
  GtkWidget *I;

  I=gtk_check_button_new_with_label(s);
  setMe(GTK_OBJECT(I));
  attachSignals();
  if (Gtk::AutoShow)
    show();
}

CheckButton::CheckButton(int nda,int ndb) : ToggleButton(nda,ndb) {
  attachSignals();
}

// radio button

RadioButton::RadioButton() : CheckButton(666,999) {
  GtkWidget *I;

  I=gtk_radio_button_new(NULL);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();  
}

RadioButton::RadioButton(char *s) : CheckButton(666,999) {
  GtkWidget *I;

  I=gtk_radio_button_new_with_label(NULL,s);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

RadioButtonGroup::RadioButtonGroup() {
  group=NULL;
}

RadioButtonGroup::~RadioButtonGroup() {
  if (group!=NULL)
    g_slist_free(group);
  group=NULL;
}

void RadioButtonGroup::append(RadioButton *radio) {
  GSList *it;
  group=g_slist_append(group,(gpointer)(GTK_RADIO_BUTTON(radio->getMe())));
  
  for(it=group;it!=NULL;it=g_slist_next(it))
    gtk_radio_button_set_group(GTK_RADIO_BUTTON(it->data),group);
}

CList::CList(int columns) : Container() {
  GtkWidget *I;
  ncolumns=columns;
  I=gtk_clist_new(columns);
  setMe(GTK_OBJECT(I));
  connect(GSSelectRow);
  connect(GSUnselectRow);
  if (Gtk::AutoShow)
    show();
}

void CList::setShadowType(GtkShadowType st) {
  gtk_clist_set_shadow_type(GTK_CLIST(getMe()),st);
}

void CList::setSelectionMode(GtkSelectionMode sm) {
  gtk_clist_set_selection_mode(GTK_CLIST(getMe()),sm);
}

void CList::setReorderable(gboolean reorderable) {
  gtk_clist_set_reorderable(GTK_CLIST(getMe()),reorderable);
}

void CList::columnTitlesShow() {
  gtk_clist_column_titles_show(GTK_CLIST(getMe()));
}

void CList::columnTitlesHide() {
  gtk_clist_column_titles_hide(GTK_CLIST(getMe()));
}

void CList::columnTitlesActive() {
  gtk_clist_column_titles_active(GTK_CLIST(getMe()));
}

void CList::columnTitlesPassive() {
  gtk_clist_column_titles_passive(GTK_CLIST(getMe()));
}

void CList::columnTitleActive(int col) {
  gtk_clist_column_title_active(GTK_CLIST(getMe()),col);
}

void CList::columnTitlePassive(int col) {
  gtk_clist_column_title_passive(GTK_CLIST(getMe()),col);
}

void CList::setColumnTitle(int col,char *title) {
  gtk_clist_set_column_title(GTK_CLIST(getMe()),col,title);
}

void CList::setColumnTitles(list<char *> & titles) {
  list<char *>::iterator pos;
  int i=0;
  for(pos=titles.begin();((pos!=titles.end()) && (i<ncolumns));i++,pos++)
    setColumnTitle(i,*pos);
}

char * CList::getColumnTitle(int col) {
  return( (char *) gtk_clist_get_column_title(GTK_CLIST(getMe()),col));
}

void CList::setColumnJustification(int col,GtkJustification j) {
  gtk_clist_set_column_justification(GTK_CLIST(getMe()),col,j);
}

void CList::setColumnVisibility(int col,gboolean visible) {
  gtk_clist_set_column_visibility(GTK_CLIST(getMe()),col,visible);
}

void CList::setColumnResizeable(int col,gboolean resizeable) {
  gtk_clist_set_column_resizeable(GTK_CLIST(getMe()),col,resizeable);
}

void CList::setColumnAutoResize(int col,gboolean autoresize) {
  gtk_clist_set_column_auto_resize(GTK_CLIST(getMe()),col,autoresize);
}

int CList::columnsAutosize() {
  return( (int) gtk_clist_columns_autosize(GTK_CLIST(getMe())));
}

void CList::setColumnWidth(int col,int width) {
  gtk_clist_set_column_width(GTK_CLIST(getMe()),col,width);
}

void CList::setColumnMaxWidth(int col,int width) {
  gtk_clist_set_column_max_width(GTK_CLIST(getMe()),col,width);
}

void CList::setColumnMinWidth(int col,int width) {
  gtk_clist_set_column_min_width(GTK_CLIST(getMe()),col,width);
}

void CList::setRowHeight(int height) {
  gtk_clist_set_row_height(GTK_CLIST(getMe()),height);
}

void CList::moveTo(int row,int column,float row_align,float col_align) {
  gtk_clist_moveto(GTK_CLIST(getMe()),row,column,row_align,col_align);
}

void CList::setText(int row,int column,char *text) {
  gtk_clist_set_text(GTK_CLIST(getMe()),row,column,text);
}

void CList::setRowText(int row,list<char *> & data) {
  int i=0;
  list<char *>::iterator pos;

  for(pos=data.begin();( (i<ncolumns) && (pos!=data.end()) ); i++, pos++)
    setText(row,i,*pos);
}

void CList::rowMove(int src,int dest) {
  gtk_clist_row_move(GTK_CLIST(getMe()),src,dest);
}

int CList::getText(int row,int column,char **text) {
  return( (int) gtk_clist_get_text(GTK_CLIST(getMe()),row,column,text));
}

void CList::append(list<char *> & data) {
  int i;
  list<char *>::iterator pos;
  char **pp;
  pp=(char **)g_malloc( sizeof(char *) * data.size() );
  for(i=0,pos=data.begin();pos!=data.end();pos++,i++)
    pp[i]=(*pos);
  gtk_clist_append(GTK_CLIST(getMe()),pp);
  g_free((gpointer)pp);
}

void CList::prepend(list<char *> & data) {
  int i;
  list<char *>::iterator pos;
  char **pp;
  pp=(char **)g_malloc( sizeof(char *) * data.size() );
  for(i=0,pos=data.begin();pos!=data.end();pos++,i++)
    pp[i]=(*pos);
  gtk_clist_prepend(GTK_CLIST(getMe()),pp);
  g_free((gpointer)pp);
}

void CList::insert(int row,list<char *> & data) {
  int i;
  list<char *>::iterator pos;
  char **pp;
  pp=(char **)g_malloc( sizeof(char *) * data.size() );
  for(i=0,pos=data.begin();pos!=data.end();pos++,i++)
    pp[i]=(*pos);
  gtk_clist_insert(GTK_CLIST(getMe()),row,pp);
  g_free((gpointer)pp);
}

void CList::remove(int row) {
  gtk_clist_remove(GTK_CLIST(getMe()),row);
}

void CList::selectRow(int row,int column) {
  gtk_clist_select_row(GTK_CLIST(getMe()),row,column);
}

void CList::unselectRow(int row,int column) {
  gtk_clist_unselect_row(GTK_CLIST(getMe()),row,column);
}

void CList::selectAll() {
  gtk_clist_select_all(GTK_CLIST(getMe()));
}

void CList::unselectAll() {
  gtk_clist_unselect_all(GTK_CLIST(getMe()));
}

void CList::swapRows(int row1,int row2) {
  gtk_clist_swap_rows(GTK_CLIST(getMe()),row1,row2);
}

void CList::freeze() {
  gtk_clist_freeze(GTK_CLIST(getMe()));
}

void CList::thaw() {
  gtk_clist_thaw(GTK_CLIST(getMe()));
}

void CList::clear() {
  gtk_clist_clear(GTK_CLIST(getMe()));
}

void CList::be_abstract() { }

// container

void Container::add(Widget *w) {
  gtk_container_add(GTK_CONTAINER(getMe()),GTK_WIDGET(w->getMe()));
}

void Container::setBorderWidth(int p) {
  gtk_container_set_border_width(GTK_CONTAINER(getMe()),p);
}

// scrolled window

ScrolledWindow::ScrolledWindow() {
  GtkWidget *I;

  I=gtk_scrolled_window_new(NULL,NULL);
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

void ScrolledWindow::addWithViewport(Widget *w) {
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(getMe()),
					GTK_WIDGET(w->getMe()));
}

void ScrolledWindow::setPolicy(GtkPolicyType h,GtkPolicyType v) {
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(getMe()),
				 h,v);
}

void ScrolledWindow::be_abstract() { }

void Editable::setEditable(gboolean v) {
  gtk_editable_set_editable(GTK_EDITABLE(getMe()),v);
}

void Editable::setPosition(gint pos) {
  gtk_editable_set_position(GTK_EDITABLE(getMe()),pos);
}

gint Editable::getPosition() {
  return(gtk_editable_get_position(GTK_EDITABLE(getMe())));
}

void Editable::deleteSelection() {
  gtk_editable_delete_selection(GTK_EDITABLE(getMe()));
}

void Editable::cutClipboard() {
  gtk_editable_cut_clipboard(GTK_EDITABLE(getMe()));
}

void Editable::copyClipboard() {
  gtk_editable_copy_clipboard(GTK_EDITABLE(getMe()));
}

void Editable::pasteClipboard() {
  gtk_editable_paste_clipboard(GTK_EDITABLE(getMe()));
}

gchar * Editable::getChars(gint start,gint end) {
  return(gtk_editable_get_chars(GTK_EDITABLE(getMe()),start,end));
}

void Editable::deleteText(gint start,gint end) {
  gtk_editable_delete_text(GTK_EDITABLE(getMe()),start,end);
}

void Editable::selectRegion(gint start,gint end) {
  gtk_editable_select_region(GTK_EDITABLE(getMe()),start,end);
}

// entry

Entry::Entry() {
  GtkWidget *I;
  I=gtk_entry_new();
  setMe(GTK_OBJECT(I));
  connect(GSChanged);
  if (Gtk::AutoShow)
    show();
}

Entry::Entry(int max) {
  GtkWidget *I;
  I=gtk_entry_new_with_max_length(max);
  setMe(GTK_OBJECT(I));
  connect(GSChanged);
  if (Gtk::AutoShow)
    show();
}

gchar * Entry::getText() {
  return(gtk_entry_get_text(GTK_ENTRY(getMe())));
}

void Entry::setVisibility(gboolean v) {
  gtk_entry_set_visibility(GTK_ENTRY(getMe()),v);
}

void Entry::setMaxLength(int max) {
  gtk_entry_set_max_length(GTK_ENTRY(getMe()),max);
}

void Entry::setText(char *text) {
  gtk_entry_set_text(GTK_ENTRY(getMe()),text);
}

void Entry::be_abstract() { }

// text

Text::Text() {
  GtkWidget *I;

  I=gtk_text_new(NULL,NULL);
  setMe(GTK_OBJECT(I));
  connect(GSChanged);
  if (Gtk::AutoShow)
    show();
}

void Text::setWordWrap(gboolean v) {
  gtk_text_set_word_wrap(GTK_TEXT(getMe()),v);
}

void Text::setLineWrap(gboolean v) {
  gtk_text_set_line_wrap(GTK_TEXT(getMe()),v);
}

void Text::freeze() {
  gtk_text_freeze(GTK_TEXT(getMe()));
}

void Text::thaw() {
  gtk_text_thaw(GTK_TEXT(getMe()));
}

void Text::insert(char *s) {
  gtk_text_insert(GTK_TEXT(getMe()),NULL,NULL,NULL,s,strlen(s));
}

void Text::be_abstract() { }

Notebook::Notebook() {
  GtkWidget *I;
  I=gtk_notebook_new();
  setMe(GTK_OBJECT(I));
  connect(GSSwitchPage);
  if (Gtk::AutoShow)
    show();
}

void Notebook::append(Widget *page,Widget *tab) {
  gtk_notebook_append_page(GTK_NOTEBOOK(getMe()),
			   GTK_WIDGET(page->getMe()),
			   (tab?GTK_WIDGET(tab->getMe()):NULL));
}

void Notebook::prepend(Widget *page,Widget *tab) {
  gtk_notebook_prepend_page(GTK_NOTEBOOK(getMe()),
			   GTK_WIDGET(page->getMe()),
			   (tab?GTK_WIDGET(tab->getMe()):NULL));
}

void Notebook::insert(Widget *page,Widget *tab,int pos) {
  gtk_notebook_insert_page(GTK_NOTEBOOK(getMe()),
			   GTK_WIDGET(page->getMe()),
			   (tab?GTK_WIDGET(tab->getMe()):NULL),
			    pos);
}

void Notebook::remove(gint pos) {
  gtk_notebook_remove_page(GTK_NOTEBOOK(getMe()),pos);
}

void Notebook::setTabPos(GtkPositionType pos) {
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(getMe()),pos);
}

void Notebook::setShowTabs(gboolean v) {
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(getMe()),v);
}

void Notebook::setShowBorder(gboolean v) {
  gtk_notebook_set_show_border(GTK_NOTEBOOK(getMe()),v);
}

void Notebook::setTabVBorder(int b) {
  gtk_notebook_set_tab_vborder(GTK_NOTEBOOK(getMe()),b);
}

void Notebook::setTabHBorder(int b) {
  gtk_notebook_set_tab_hborder(GTK_NOTEBOOK(getMe()),b);
}

void Notebook::setScrollable(gboolean v) {
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(getMe()),v);
}

void Notebook::setHomogeneousTabs(gboolean v) {
  gtk_notebook_set_homogeneous_tabs(GTK_NOTEBOOK(getMe()),v);
}

gint Notebook::getPage() {
  return(gtk_notebook_get_current_page(GTK_NOTEBOOK(getMe())));
}

void Notebook::setPage(gint page) {
  gtk_notebook_set_page(GTK_NOTEBOOK(getMe()),page);
}

void Notebook::be_abstract() { }

Pixmap::Pixmap(char **xpmd) {
  GdkBitmap *mask;
  GdkPixmap *dpix;
  GtkWidget *I;

  dpix=gdk_pixmap_create_from_xpm_d(Gtk::oh_my,
				    &mask,
				    NULL,
				    xpmd);
  
  I=gtk_pixmap_new(dpix,mask);
  setMe(GTK_OBJECT(I));
  
  if (Gtk::AutoShow)
    show();
}

list<ToolPair> Toolbar::binding;
const int Toolbar::Push = 0;
const int Toolbar::Toggle = 1;
const int Toolbar::Radio = 2;

Toolbar::Toolbar(GtkOrientation orientation,GtkToolbarStyle style) {
  GtkWidget *I;

  I=gtk_toolbar_new(orientation,style);
  setMe(GTK_OBJECT(I));
  nbuttons=0;
  if (Gtk::AutoShow)
    show();
  recipient=NULL;
  method=Push;
}

void Toolbar::setToolbarType(int type) {
  method=type%3;
}

Toolbar::~Toolbar() {
  list<ToolPair>::const_iterator pos;
  ToolPair *nc;
  Toolbar *nd;

  nd=(Toolbar *)this;

  for(pos=binding.begin();pos!=binding.end();pos++) {
    nc=(ToolPair *)&(*pos);
    if ( ((*pos).toolbar) == nd ) {
      binding.remove(*pos);
      delete(nc);
      pos=binding.begin();
    }
  }
}

int Toolbar::append(Pixmap *icon,char *text,char *tooltip) {
  ToolPair *tp;
  GtkToolbarChildType t;
  GtkWidget *him;

  switch(method) {
  case Push:   t=GTK_TOOLBAR_CHILD_BUTTON; break;
  case Toggle: t=GTK_TOOLBAR_CHILD_TOGGLEBUTTON; break;
  case Radio:  t=GTK_TOOLBAR_CHILD_RADIOBUTTON; break;
  default: return 0;
  }

  tp=new ToolPair(this,nbuttons++,NULL,(method!=Push));

  if (method!=Push) {
    him=gtk_toolbar_append_element(GTK_TOOLBAR(getMe()),
				   t,
				   NULL,
				   text,
				   tooltip,
				   "Private",
				   GTK_WIDGET(icon->getMe()),
				   GTK_SIGNAL_FUNC(toolbar_callback),
				   (gpointer)(tp));
  } else {
    him=gtk_toolbar_append_item(GTK_TOOLBAR(getMe()),
				text,
				tooltip,
				"Private",
				GTK_WIDGET(icon->getMe()),
				GTK_SIGNAL_FUNC(toolbar_callback),
				(gpointer)(tp));
  }

  tp->thewidget=him;
  binding.push_back(*tp);
  return(nbuttons-1);
}

int Toolbar::prepend(Pixmap *icon,char *text,char *tooltip) {
  ToolPair *tp;
  GtkToolbarChildType t;
  GtkWidget *him;

  switch(method) {
  case Push: t=GTK_TOOLBAR_CHILD_BUTTON; break;
  case Toggle: t=GTK_TOOLBAR_CHILD_TOGGLEBUTTON; break;
  case Radio: t=GTK_TOOLBAR_CHILD_RADIOBUTTON; break;
  default: return 0;
  }

  tp=new ToolPair(this,nbuttons++,NULL,(method!=Push));

  if (method!=Push) {
    him=gtk_toolbar_prepend_element(GTK_TOOLBAR(getMe()),
				    t,
				    NULL,
				    text,
				    tooltip,
				    "Private",
				    GTK_WIDGET(icon->getMe()),
				    GTK_SIGNAL_FUNC(toolbar_callback),
				    (gpointer)(tp));
  } else {
    him=gtk_toolbar_prepend_item(GTK_TOOLBAR(getMe()),
				 text,
				 tooltip,
				 "Private",
				 GTK_WIDGET(icon->getMe()),
				 GTK_SIGNAL_FUNC(toolbar_callback),
				 (gpointer)(tp));
  }

  tp->thewidget=him;
  binding.push_back(*tp);
  return(nbuttons-1);
}

int Toolbar::insert(Pixmap *icon,char *text,char *tooltip,int pos) {
  ToolPair *tp;
  GtkToolbarChildType t;
  GtkWidget *him;

  switch(method) {
  case Push: t=GTK_TOOLBAR_CHILD_BUTTON; break;
  case Toggle: t=GTK_TOOLBAR_CHILD_TOGGLEBUTTON; break;
  case Radio: t=GTK_TOOLBAR_CHILD_RADIOBUTTON; break;
  default: return 0;
  }

  tp=new ToolPair(this,nbuttons++,NULL,(method!=Push));

  if (method!=Push) {
    him=gtk_toolbar_insert_element(GTK_TOOLBAR(getMe()),
				   t,
				   NULL,
				   text,tooltip,"Private",
				   GTK_WIDGET(icon->getMe()),
				   GTK_SIGNAL_FUNC(toolbar_callback),
				   (gpointer)(tp),pos);
  } else {
    him=gtk_toolbar_insert_item(GTK_TOOLBAR(getMe()),
				text,tooltip,"Private",
				GTK_WIDGET(icon->getMe()),
				GTK_SIGNAL_FUNC(toolbar_callback),
				(gpointer)(tp),pos);
  }

  tp->thewidget=him;
  binding.push_back(*tp);
  return(nbuttons-1);
}

void Toolbar::appendSpace() {
  gtk_toolbar_append_space(GTK_TOOLBAR(getMe()));
}

void Toolbar::prependSpace() {
  gtk_toolbar_prepend_space(GTK_TOOLBAR(getMe()));
}

void Toolbar::insertSpace(int pos) {
  gtk_toolbar_insert_space(GTK_TOOLBAR(getMe()),pos);
}

void toolbar_callback(GtkWidget *w,gpointer data) {
  Toolbar *t;
  ToolPair *tp;
  int v;

  tp=(ToolPair *)data;

  t=tp->toolbar;
  v=tp->index;

  t->clicked(v);
}

void Toolbar::clicked(int button) {
  if (recipient!=NULL)
    recipient->clicked(getId(),button);
}

void Toolbar::forward(Gtk *dest) {
  recipient=dest;
}

gint Toolbar::getActive(int id) {
  ToolPair *tp;
  tp=getById(id);
  if (tp==NULL)
    return 0;
  if (!(tp->toggly))
    return 0;
  return((gint)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tp->thewidget)));
}

void Toolbar::setActive(int id,int state) {
  ToolPair *tp;
  tp=getById(id);
  if (tp==NULL)
    return;
  if (!(tp->toggly))
    return;
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tp->thewidget),state);
}
  
void Toolbar::setItemSensitive(int id,int state) {
  ToolPair *tp;
  tp=getById(id);
  if (tp==NULL)
    return;
  gtk_widget_set_sensitive(tp->thewidget,state);
}

ToolPair * Toolbar::getById(int id) {
  list<ToolPair>::iterator pos;

  for(pos=binding.begin();pos!=binding.end();pos++)
    if ( (*pos).toolbar->getId() == getId() )
      if ( (*pos).index == id )
	return (&(*pos));
  return NULL;
}

void Toolbar::be_abstract() { }

/* toolpair */

ToolPair::ToolPair(Toolbar *t,int i,GtkWidget *it,int actv) {
  toolbar=t;
  index=i;
  thewidget=it;
  toggly=actv;
}

int ToolPair::operator==(ToolPair &t) {
  return( &t == this );
}

int ToolPair::operator==(const ToolPair &t) {
  return( &t == this );
}

Widget::Widget() {
  me=NULL;
  been_destroyed=FALSE;
}

Widget::~Widget() {
  gtk_signal_handlers_destroy(getMe());
  destroy();
}

void Widget::destroy() {
  if (!been_destroyed) {
    if (GTK_IS_WIDGET(me))
      gtk_widget_destroy(GTK_WIDGET(me));
    been_destroyed=TRUE;
  }
}

void Widget::realize() {
  gtk_widget_realize(GTK_WIDGET(me));
}

void Widget::setSensitive(gboolean s) {
  gtk_widget_set_sensitive(GTK_WIDGET(me),s);
}

void Widget::show() {
  gtk_widget_show(GTK_WIDGET(me));
}

void Widget::hide() {
  gtk_widget_hide(GTK_WIDGET(me));
}

void Widget::grabFocus() {
  gtk_widget_grab_focus(GTK_WIDGET(me));
}

void Widget::grabAdd() {
  gtk_grab_add(GTK_WIDGET(me));
}

void Widget::grabRemove() {
  gtk_grab_remove(GTK_WIDGET(me));
}

void Widget::setMe(GtkObject *obj) {
  me=obj;
}

void Widget::destroyed() {
  delete this;
}

Window::Window() {
  create(GTK_WINDOW_TOPLEVEL);
}

Window::Window(GtkWindowType kind) {
  create(kind);
}

Window::Window(GtkWindowType kind,char *title) {
  create(kind);
  setTitle(title);
}

Window::Window(char *title) {
  create(GTK_WINDOW_TOPLEVEL);
  setTitle(title);
}

void Window::setIcon(char **xpm) {
  GdkBitmap *mask;
  GdkPixmap *dpix;

  dpix=gdk_pixmap_create_from_xpm_d(GTK_WIDGET(I)->window,
				    &mask,
				    NULL,
				    xpm);
  
  gdk_window_set_icon(GTK_WIDGET(I)->window,NULL,dpix,mask);
}

void Window::setDefaultSize(int x,int y) {
  gtk_window_set_default_size(I,x,y);
}

void Window::setTitle(char *s) {
  gtk_window_set_title(I,s);
}

void Window::setPosition(GtkWindowPosition pos) {
  gtk_window_set_position(I,pos);
}

void Window::create(GtkWindowType kind) {
  GtkWidget *m;

  m=gtk_window_new(kind);
  I=GTK_WINDOW(m);
  setMe(GTK_OBJECT(m));

  Gtk::connect(GSDelete);
  Gtk::connect(GSDestroy);
}

void Window::be_abstract() { }

HandleBox::HandleBox() {
  GtkWidget *I;
  I=gtk_handle_box_new();
  setMe(GTK_OBJECT(I));
  if (Gtk::AutoShow)
    show();
}

void HandleBox::setShadowType(GtkShadowType st) {
  gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(getMe()),st);
}

void HandleBox::setHandlePosition(GtkPositionType pos) {
  gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(getMe()),pos);
}

void HandleBox::setSnapEdge(GtkPositionType pos) {
  gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(getMe()),pos);
}

void HandleBox::be_abstract() { }

void Canvas::init(int w,int h) {
  GtkWidget *m;
  GdkWindow *ww;

  m=gtk_drawing_area_new();
  gtk_widget_set_events(m,
			GDK_EXPOSURE_MASK|GDK_BUTTON_PRESS_MASK|
			GDK_POINTER_MOTION_MASK|GDK_BUTTON_RELEASE_MASK|
			GDK_BUTTON_MOTION_MASK);
  setMe(GTK_OBJECT(m));
  
  setSize(w,h);
  
  ww=Gtk::oh_my;

  gc=gdk_gc_new(ww);
  buffer=gdk_pixmap_new(ww,w,h,-1);

  if (Gtk::AutoShow)
    show();
  else
    realize();

  gtk_signal_connect(getMe(),"expose_event",
		     GTK_SIGNAL_FUNC(canvas_expose),(gpointer)this);
  frost=0;
  setColor(0);
  curfont=NULL;

  connect(GSMotion);
  connect(GSPressedAt);
  connect(GSReleasedAt);
  FastDraw=0;
}

Canvas::Canvas() : Widget() {
  init(64,64);
}

Canvas::Canvas(int w,int h) : Widget() {
  init(w,h);
}

Canvas::~Canvas() {
  gdk_gc_destroy(gc);
  gdk_pixmap_unref(buffer);
}

void Canvas::setSize(int w,int h) {
  gtk_drawing_area_size(GTK_DRAWING_AREA(getMe()),w,h);
}

void Canvas::update() {
  gtk_widget_queue_resize(GTK_WIDGET(getMe()));
}

void Canvas::setColor(int triplet) {
  curcolor=triplet;
  gdk_rgb_gc_set_foreground(gc,triplet);
}

void Canvas::drawLine(int x1,int y1,int x2,int y2) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_line(FastDraw?window:buffer,gc,x1,y1,x2,y2);
  if (!frost)
    update();
}

void Canvas::drawRect(int x1,int y1,int w,int h) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_rectangle(FastDraw?window:buffer,gc,FALSE,x1,y1,w,h);
  if (!frost)
    update();
}

void Canvas::fillRect(int x1,int y1,int w,int h) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_rectangle(FastDraw?window:buffer,gc,TRUE,x1,y1,w,h);
  if (!frost)
    update();
}

void Canvas::fillRect3D(int x1,int y1,int w,int h,int border,gboolean raised) {
  int val,last,V,i,dark,light;
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_rectangle(FastDraw?window:buffer,gc,TRUE,x1,y1,w,h);

  last=curcolor;

  val=Triplet::RGB2YCbCr(curcolor);
  V=Triplet::Y(val);
  V+=V/2;
  if (V>255) V=255;
  light=Triplet::YCbCr2RGB(Triplet::value(V,
					  Triplet::Cb(val),
					  Triplet::Cr(val)));
  V=Triplet::Y(val);
  V/=2;
  dark=Triplet::YCbCr2RGB(Triplet::value(V,
					 Triplet::Cb(val),
					 Triplet::Cr(val)));
  setColor(raised?light:dark);

  fillRect(x1,y1,w,border);
  fillRect(x1,y1,border,h);

  setColor(raised?dark:light);  

  for(i=0;i<border;i++) {
    drawLine(x1+i,y1+h-i,x1+w-1,y1+h-i);
    drawLine(x1+w-i,y1+i,x1+w-i,y1+h-1);
  }

  setColor(last);
  if (!frost)
    update();
}


void Canvas::freeze() {
  frost++;
}

void Canvas::thaw() {
  frost--;
  if (frost<0) frost=0;
  if (!frost)
    update();
}

void Canvas::setFont(Font *font) {
  curfont=font;
}

void Canvas::drawString(char *str,int x,int y) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_string(FastDraw?window:buffer,curfont->handle,gc,x,y,str);
  if (!frost)
    update();
}

void Canvas::drawPoint(int x,int y) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_point(FastDraw?window:buffer,gc,x,y);
  if (!frost)
    update();
}

void Canvas::drawArc(int x,int y,int w,int h,int angstart,int angend) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_arc(FastDraw?window:buffer,gc,FALSE,x,y,w,h,angstart,angend);
  if (!frost)
    update();
}

void Canvas::fillArc(int x,int y,int w,int h,int angstart,int angend) {
  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_arc(FastDraw?window:buffer,gc,TRUE,x,y,w,h,angstart,angend);
  if (!frost)
    update();
}

void Canvas::drawPolygon(list<int> &x,list<int> &y) {
  list<int>::iterator posx;
  list<int>::iterator posy;
  GdkPoint *pb;
  int i;

  pb=(GdkPoint *)g_malloc(x.size()*sizeof(GdkPoint));

  for(i=0,posx=x.begin(),posy=y.begin();posx!=x.end();posx++,posy++,i++) {
    pb[i].x=*posx;
    pb[i].y=*posy;
  }

  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_polygon(FastDraw?window:buffer,gc,FALSE,pb,x.size());
  g_free(pb);
  if (!frost)
    update();
}

void Canvas::fillPolygon(list<int> &x,list<int> &y) {
  list<int>::iterator posx;
  list<int>::iterator posy;
  GdkPoint *pb;
  int i;

  pb=(GdkPoint *)g_malloc(x.size()*sizeof(GdkPoint));

  for(i=0,posx=x.begin(),posy=y.begin();posx!=x.end();posx++,posy++,i++) {
    pb[i].x=*posx;
    pb[i].y=*posy;
  }

  if (FastDraw) window=GTK_WIDGET(getMe())->window;
  gdk_draw_polygon(FastDraw?window:buffer,gc,TRUE,pb,x.size());
  g_free(pb);
  if (!frost)
    update();
}

gboolean canvas_expose(GtkWidget *widget,
		       GdkEventExpose *gee,
		       gpointer data) {
  Canvas *c;
  c=(Canvas *)data;
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  c->buffer,
		  gee->area.x, gee->area.y,
		  gee->area.x, gee->area.y,
		  gee->area.width, gee->area.height);
  return FALSE;  
}

// font

Font::Font(char *face,int size) {
  char z[256];
  sprintf(z,"-*-%s-medium-r-normal--%d-*-*-*-*-*-*",face,size);
  handle=gdk_font_load(z);
}

Font::Font(char *face,int size,gboolean bold,gboolean italic) {
  char z[256];
  sprintf(z,"-*-%s-%s-%s-normal--%d-*-*-*-*-*-*",face,
	  (bold?"bold":"normal"),(italic?"i":"r"),size);
  handle=gdk_font_load(z);
}

Font::Font(char *fullspec) {
  handle=gdk_font_load(fullspec);
}

Font::~Font() {
  gdk_font_unref(handle);
}


// message box

MessageBox::MessageBox(char *text,char *title,
		       char **icon,int mb) : 
  Window(GTK_WINDOW_DIALOG,title) {
  
  VBox *v1;
  HBox *h1,*h2;
  Label *l;
  Button *b;
  int i,c;

  for(i=0;i<60;i++)
    ids[i]=0;

  setPosition(GTK_WIN_POS_CENTER);
  setBorderWidth(4);
  realize();

  add(v1=new VBox(FALSE,0));
  v1->Gap=6;

  h1=new HBox(FALSE,4);
  v1->packStart(h1);
  
  if (icon!=NULL) {
    h1->packStart(new Pixmap(icon));
  }

  h1->packStart(l=new Label(text));
  l->setJustify(GTK_JUSTIFY_LEFT);

  v1->packStart(new HSeparator());
  v1->packStart(h2=new HBox(TRUE,6));

  c=0;
  if (mb&MsgCancel) {
    b=new Button(" Cancel ");
    h2->packEnd(b);
    b->forward(this);
    ids[(int)MsgCancel]=b->getId();
    c++;
  }
  if (mb&MsgNo) {
    b=new Button(" No ");
    h2->packEnd(b);
    b->forward(this);
    ids[(int)MsgNo]=b->getId();
    c++;
  }
  if (mb&MsgYes) {
    b=new Button(" Yes ");
    h2->packEnd(b);
    b->forward(this);
    ids[(int)MsgYes]=b->getId();
    c++;
  }
  if (mb&MsgOk) {
    b=new Button(" OK ");
    h2->packEnd(b);
    b->forward(this);
    ids[(int)MsgOk]=b->getId();
    c++;
  }
  for(;c<5;c++)
    h2->packEnd(new Label(" "));

  show();
  grabAdd();

  Result=MsgNone;

  while(Result==MsgNone)
    Gtk::MainIteration();

  grabRemove();
  destroy();
}

void MessageBox::clicked(int id) {
  int i;
  Result=MsgCancel;
  for(i=0;i<60;i++) {
    if (ids[i]==id) {
      Result=(MessageButton)i;
      return;
    }
  }
}

// file selection

FileSelection::FileSelection(char *title) :
  Window(1,2,3,4,5) {
  
  GtkFileSelection *s;
  GtkWidget *I;
  I=gtk_file_selection_new(title);
  setMe(GTK_OBJECT(I));

  s=GTK_FILE_SELECTION(I);
  gtk_signal_connect(GTK_OBJECT(s->ok_button),"clicked",
		     GTK_SIGNAL_FUNC(fs_ok_callback),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(s->cancel_button),"clicked",
		     GTK_SIGNAL_FUNC(fs_cancel_callback),(gpointer)this);
}

void FileSelection::setFilename(char *filename) {
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(getMe()),filename);
}

char * FileSelection::getFilename() {
  return(gtk_file_selection_get_filename(GTK_FILE_SELECTION(getMe())));
}

void FileSelection::showFileOp() {
  gtk_file_selection_show_fileop_buttons(GTK_FILE_SELECTION(getMe()));
}

void FileSelection::hideFileOp() {
  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(getMe()));
}

int FileSelection::show() {
  result=-1;
  Widget::show();
  while(result<0)
    Gtk::MainIteration();
  return result;
}

gint FileSelection::deleted() {
  return TRUE;
}

void fs_ok_callback(GtkButton *b,gpointer data) {
  FileSelection *fs;
  fs=(FileSelection *)data;
  fs->result=1;
}

void fs_cancel_callback(GtkButton *b,gpointer data) {
  FileSelection *fs;
  fs=(FileSelection *)data;
  fs->result=0;
}
