
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef BRIGHTONEVENTS_H
#define BRIGHTONEVENTS_H

#define BLASTEvent 35

typedef struct BrightonKey {
	short code, mod;
} brightonKey;

typedef struct BrightonCoord {
	short x, y;
} brightonCoord;

typedef struct BrightonSize {
	int x, y, width, height;
} brightonSize;

#define BRIGHTON_FLOAT 0
#define BRIGHTON_MEM 1
#define BRIGHTON_INT 2

#define BRIGHTON_NONE -1
#define BRIGHTON_RESIZE 0
#define BRIGHTON_MOTION 1
#define BRIGHTON_BUTTONPRESS 2
#define BRIGHTON_BUTTONRELEASE 3
#define BRIGHTON_PARAMCHANGE 4
#define BRIGHTON_KEYPRESS 5
#define BRIGHTON_KEYRELEASE 6
#define BRIGHTON_ENTER 7
#define BRIGHTON_LEAVE 8
#define BRIGHTON_CONFIGURE 9
#define BRIGHTON_CONFIGURE_REQ 10
#define BRIGHTON_EXPOSE 11
#define BRIGHTON_GEXPOSE 12

/*
 * This is an oversimplified conversion of the XEvent strcture for brighton use
 */
typedef struct BrightonEvent {
	unsigned int flags;
	struct BrightonEvent *next;
	int wid;
	int type;
	int command;
	int x, y, w, h;
	int key;
	int mod;
	float value;
	int intvalue;
	void *m;
} brightonEvent;

#endif /* BRIGHTONEVENTS_H */

