/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_features.pike,v 1.42.2.4 2004/03/19 10:09:04 vida Exp $
 */

#include <module.h>
#include <camas/globals.h>

inherit "module";
inherit "caudiumlib";

//
//! module: CAMAS: Features
//!  The Features Module for CAMAS.<br />
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_features.pike,v 1.42.2.4 2004/03/19 10:09:04 vida Exp $
//

constant cvs_version = "$Id: camas_features.pike,v 1.42.2.4 2004/03/19 10:09:04 vida Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Features Module";
constant module_doc  = "The Features Module for CAMAS."
			"<br /><b>This module is automatically "
                        "selected if you select \"CAMAS: Main module\".</b>";

constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)

void create () {

  // --------------[-> Features ... -----------------------

  defvar("dsn", 0, "Outgoing mail:DSN support", TYPE_FLAG,
         "Add DSN (Delivery Status Notification) support when sending mail. This requires "
         "the use of SMTP for outgoing mail (instead of sendmail). You also have to make "
         "sure your SMTP server supports DSN.");

  defvar("composesavemail", 1, "Outgoing mail:By default save composed mail into sentmail folder", TYPE_FLAG,
         "If enabled, mail will by default be saved when sending, but a checkbox with "
         "'Don't save this mail' is shown. If disabled, mail will not be sent by default.");

  defvar ("linkwindow", 1, "Features:Open links in new window",
          TYPE_FLAG, "Enables opening of links in a new window.");

  defvar("extendedabook", 1, "Compatibility: Extended addressbook",
         TYPE_FLAG, "Enables extended addressbook.");

  defvar("extendedabookfields", "Firstname, Lastname, Phone, Snailmail",
         "Compatibility: Extended addressbook fields.",
         TYPE_STRING, "Comma-separated list of field names.",0,hide_ebook);

  defvar("deleteinebook", 1, "Features:Also delete in extended addressbook",
         TYPE_FLAG, "When deleting an entry in the addresbook, also delete "
         "a matching one in the extended addressbook. You probably want "
         "to say yes unless you plan your users to use either plain or "
         "extended addressbook.",0,hide_ebook);

  defvar("addressbook", 1, "Compatibility: Addressbook", TYPE_FLAG,
         "Enables the addressbook. Addressbook is disabled if User setup is.");

  defvar("attachments", 1, "Features:Attachments", TYPE_FLAG,
         "Enables sending of attachments.");

  defvar("logout", 1, "Features:Logout", TYPE_FLAG,
         "Enable the logout button.");

  defvar("usermailpath", 0, "Features:User mail path", TYPE_FLAG,
         "Determines if users should be allowed to set the mail folder. "
         "Is disabled if User setup is.");

  defvar("mailboxes", 1, "Features:Mailboxes", TYPE_FLAG,
         "If disabled, only INBOX can be accessed.");

  defvar("filterbook", 1, "Features:Mail Filter", TYPE_FLAG,
         "Enables the mailfilter. Mail filter is disabled if User setup is.");

  defvar("autofilter", 0, "Features:Auto Filter", TYPE_FLAG,
         "With this option a rule is automatically build when you move a"
         "mail to a specified mailbox. When the same sender come back,"
         "his mail is moved to the mailbox you already specified"
         "Auto Filter will be disable if Mail Filter is");

  defvar("moveanswered", 0, "Features:Move Answered", TYPE_FLAG,
         "When enabled, four more actions are available:<br>"
	 "<ul><li> <b>&lt;camas_replymove&gt;</b> : \"reply and move\"</li>"
         "<li> <b>&lt;camas_replymovemarked&gt;</b> : \"reply all marked messages and move\"</li>"
         "<li> <b>&lt;camas_replytoallmove&gt;</b> : \"reply to all and move\"</li>"
	 "<li> <b>&lt;camas_forwardmove&gt;</b> : \"forward and move\"</li></ul><br>"
         "The mail currently processed is moved into a answered-mail"
         "folder.<br><br>"
	 "It is useful if you have to answer lots of emails. This way, you can "
	 "keep only those not answered in your mailbox.");

  defvar("userautofilter", 1, "Features:User auto filter", TYPE_FLAG,
         "User can disable autofilter in their preferences");


  defvar("usersetup", 1, "Features:User setup", TYPE_FLAG,
         "If enabled, each user has a setup (including addressbook, signature etc.) "
         "saved either in a mailbox or in a file. "
         "Is disabled if mailboxes is disabled and User preferences directory is empty.");

  defvar("usereditsetup", 1, "Features:User can change setup", TYPE_FLAG,
         "Determines if the users should be able to change their own setup. "
         "This option is ignored if \"User setup\" is disabled.");

  defvar("inboxes", 1, "Features:User specified inboxes", TYPE_FLAG,
         "Lets the user specify a list of inboxes which may be presented "
         "as a list in the user interface. ");

  defvar("useraddress", 0, "Features:User specified address", TYPE_FLAG,
         "Enables a user to change his/her email address in the user setup.");

  defvar("mailnotify", 1, "Features:Mail notification window", TYPE_FLAG,
         "Enables a user to open a mail notification window which is reloaded "
         "periodically (every five minutes). This feature is is built on javascript "
         "in the layout file, so make sure you use an updated layout file.");

  defvar("showhtml", 1, "Features:Show HTML messages", TYPE_FLAG,
         "Enables a user to have messages in HTML format shown instead of "
         "of the corresponding text version. HTML messages are parsed and "
         "reformatted so that no unsecure HTML tags are displayed. For "
         "example, links to mailparts are handled but all other links are "
         "removed. Javascript is not allowed. "
         "The parsing may be rather CPU-intensive, and the rendering on the "
         "client side depends on the browser used. Heavily loaded HTML pages "
         "may then cause unpredicted behaviour.");

  defvar("userheaders", 0, "Features:User specified mail headers", TYPE_FLAG,
         "Enables a user to add extra headers to outgoing mail.");

  defvar("userlayouts", 1, "Features:User can choose layout", TYPE_FLAG,
         "Allow a user to choose the layout in the login screen and in his preferences.");

  // XB: Move this somewhere else ? Since this is used only on mailindex and readmail screen...
  defvar("deletemethod", "move to trash", "Features:Delete method", TYPE_STRING_LIST,
         "Choose whether mail is deleted immediately or moved to a trash folder first, or "
         "whether both methods should be available.",
         ({"both","move to trash","delete immediately" }));

  defvar("usercanchangename", 1, "Features:User can change name", TYPE_FLAG,
         "Enable users to change their name in the configuration interface.");

  defvar("userlanguage", 1, "Features:User can choose language", TYPE_FLAG,
         "Enable a user to choose a different language than the one setup in the configuration interface."
         /*,0, hide_feature_language*/);

  defvar("usertrashfolder", 1, "Features:User can specify trash folder", TYPE_FLAG,
         "Enable a user to specify the name of the trash "
         "folder other than <i>\"Trash\"</i>.");

  defvar("usersentfolder", 1, "Features:User can specify sentmail folder", TYPE_FLAG,
         "Enable a user to specify the name of the sent-mail folder "
         "other than <i>\"sent-mail\"</i>.");

  defvar("userdraftsfolder", 0, "Features:User can specify drafts folder", TYPE_FLAG,
         "Enable a user to specify the name of the drafts folder other "
         "than <i>\"Drafts\"</i>.");

  defvar("useransweredfolder", 1, "Features:User can specify answered folder", TYPE_FLAG,
         "Enable a user to specify the name of the answered folder other "
         "than <i>\"answered-mail\"</i>.",
         0, hide_moveanswered);

  defvar("userbcccopy", 1, "Features:User can specify a default Bcc", TYPE_FLAG,
         "When enabled, user can specify a BCC address to be added to all outgoing mail.");
 
  defvar("userblindsend", 1, "Features:User can use 'blind sending'", TYPE_FLAG,
         "When enabled, allow a user who has several recipients in the To header to send a mail for "
         "each one of them, thus the recipients don't see each other email adresses."
         " This is not the same as BCC since the To header is set to the address of the recipient for "
         "each one. Also mutliple BCC doesn't prevent the recipients to see each other email "
         "addresses.<br><i>Note</i>: This is only available when using CAMAS: Tags.");
  
  defvar("defaultpostloginscreen", "mailindex", "Features:User default post login screen", 
          TYPE_MULTIPLE_STRING, "Default login screen after the user successfully authentificated. "
          "Usually it is mailindex but other values like compose or folderlist can be usefull.",
          ({ "mailindex", "compose", "folderlist", "setup", "files", "searchmail" }));

  defvar("showhiddenheaders", 1, "Features:User configurable 'show full headers'-button", TYPE_FLAG,
         "When reading a mail, users can show or hide the hidden headers of the mail. If "
         "this option is enabled, the user can choose whether to show or hide this button.");

  defvar("usersentsaveattachments", 1, "Features:User can choose to save attachments", TYPE_FLAG,
         "Enable a user to specify to save the attachments in the sentmail folder.<br /><b>Note:</b>"
         " if the sent mail folder cannot be specified, then this feature is automaticly disabled"
         " and the attachement <b>will</b> be saved into sentmail folder.");

	defvar("usercanreplyontop", 0, "Features:User can reply on top of messages", TYPE_FLAG,
					"<p>Enable a user to specify wether he can decide to reply on top of messages.</p>"
					"<p><strong>Note:</strong><ul>"
					"<li>replying on top breaks the netiquette</li>"
					"<li>disabling this won't prevent a user to reply on top of a message</li>"
					"<li>if user choose to reply on top in his own preferences, his signature will be put "
					"on top of the message he replies to</li></ul></p>");

  defvar("usersignaturecols", 55, "Features:User signature size", TYPE_INT,
         "Change the max line length for signature box in the preferences page.");

  defvar("usereditfilterbook", 1, "Features:User can edit filters", TYPE_FLAG,
         "Enable a user to do its own filters.");
  
  defvar("userfrom", 0, "Features:User can change his from address", TYPE_FLAG,
  	 "If set to yes, enable a user to change his email address and name in "
	 "the compose page (only available with Camas tags)");

  defvar("showtext", 1, "Features:Show text messages", TYPE_FLAG,
         "Display text attachments.");

  defvar("chgreplymsgprefix", 1, "Features:User can change reply prefix", TYPE_FLAG,
         "If set, then user can change the default prefix added to lines of message they reply to.");

  defvar("feedimapcache", 0, "Features:Feed the IMAP cache at startup", TYPE_FLAG,
          "If set to yes, Camas will launch a background IMAP client each time a user logged in "
          "in order to feed the cache with data. From the user's point Camas looks faster but it will "
          "eat more memory or load on your IMAP server especially if your users usually saw a few "
          "mails while they have lot of other they don't read");
    
  defvar("userfeedimapcache", 0, "Features:User can enable/disable background IMAP client", TYPE_FLAG,
         "If set, the user can choose to enable or disable the background IMAP client when logging into Camas."
         " If not set, the background IMAP client will be started depending on the value of "
         "the option \"Feed the IMAP cache at startup\"",
         0, hide_feedimapcache);

  defvar("organization", 0, "Features:Organization", TYPE_FLAG,
         "Allow the user to specify the organization he belongs to.");

  defvar("displayinlineimages", "gif\njpeg", "Features:Display inline images",
         TYPE_TEXT_FIELD, "List of MIME-subtypes to display inline.<br />"
         "Enter one subtype per line, examples are :<br />"
         "gif, "
         "ief, "
         "jpeg, "
         "png, "
         "tiff, "
         "x-cmu-raster, "
         "x-ms-bmp, "
         "x-portable-anymap, "
         "x-portable-bitmap, "
         "x-portable-graymap, "
         "x-portable-pixmap, "
         "x-rgb, "
         "x-xbitmap, "
         "x-xpixmap, "
         "x-xwindowdump");

  defvar ("jslogout", 0, "Features:Add JavaScript to close the session", TYPE_FLAG,
          "If set, JavaScript code will be added to close the session if the "
          "user closes the window instead of following a 'logout' link.");

  defvar("foldersinfo", 1, "Features:Display folders information", TYPE_FLAG,
         "Show some folders information: number of (total, recent, unseen) messages, folder size, ...");
    
  defvar("scan_folders_call_out", 0, "Features:Scan folders in the mailindex screen", TYPE_INT,
          "It might be convenient for you to search for foldersinfo in the mailindex if you "
          "have a left mail folders info ( la Mozilla or Outlook). As it will require more "
          "ressources you can choose not to run this each time the user go into mailindex "
          "(set this option to 1) or every x times the user go in mailindex (set this option to "
          "x). Set 0 to disable this feature.", 0, hide_scan_folders_call_out);

#if constant(Protocols.LDAP) && constant(Protocols.LDAP.client)
  defvar("ldap", 0, "Compatibility:LDAP Global Addressbook:Use ldap", TYPE_FLAG,
         "Enables a user to search for names in a ldap directory");

  defvar("ldapserver","ldap://localhost","Compatibility:LDAP Global Addressbook:LDAP server",
         TYPE_STRING,
         "Specifies the ldap server to use.");

  defvar("ldapsearchroot", "", "Compatibility:LDAP Global Addressbook:Search root",
         TYPE_STRING,
         "The searchroot for ldap searches. "
         "For example: o=Your company, c=your country. "
         "Could be empty");

  defvar("ldapuser", "", "Compatibility:LDAP Global Addressbook:User", TYPE_STRING,
         "The user you should use connect. NOTE! This is ldap user format. "
         "Could be empty");

  defvar("ldappass", "", "Compatibility:LDAP Global Addressbook:Password", TYPE_STRING,
         "The password you should use to connect. Could be empty.");

  defvar("ldapshowou", 1, "Compatibility:LDAP Global Addressbook:Show ou", TYPE_FLAG,
         "If \"yes\" include last level ou in result");

  defvar("ldapversion", 2, "Compatibility:LDAP Global Addressbook:Version", TYPE_INT_LIST,
         "The LDAP protocol version to use.", ({ 2, 3 }));

  defvar("ldapmail", "mail", "Compatibility:LDAP Global Addressbook:Mail attribute", TYPE_STRING|VAR_EXPERT,
         "The LDAP mail attribute in case it's not the standard \"mail\".");
#endif

  defvar("sitesig", "", "Outgoing mail:Site-wide signature",
         TYPE_TEXT_FIELD, "Piece of text added to every outgoing message.");

  defvar("siteorg", "", "Outgoing mail:Site-wide organization",
         TYPE_STRING, "Site-wide organization.");

  defvar("includeipnumber", 0, "Outgoing mail:Show IP-address", TYPE_FLAG,
         "Include the header field 'X-Originating-IP' in outgoing mail "
         "to indicate from where the mail was sent.");

  defvar("threadsearchafter", "Re: (.*)", "Mailindex: Thread sorting: regexp string",
  	 TYPE_STRING, "When using thread sorting, you want to match one specific pattern only");
	
  defvar("mime_remap",
         "text/rfc822-headers:text/plain\n"
         "message/disposition-notification:text/plain",
         "Readmail Page:Change MIME types",
         TYPE_TEXT_FIELD,
         "Change the MIME type of mail or attachments."
         " Format is old_type/old_subtype:new_type/new_subtype");

  // --------------[-> New Users ... -----------------------

  defvar("newbiesetup", 1, "New users:Enter setup", TYPE_FLAG,
         "Choose whether new users (to CAMAS) will enter preferences screen "
         "when logged in for the first time.");

  defvar("newbiecreatefolder", "", "New users:Create folders",
         TYPE_STRING, "Comma separated list of foldernames which will be "
         "created when logging in for the first time.<br />");

  defvar("newbiecreatesentfolder", 1, "New users:Create sent folder",
         TYPE_FLAG, "Auto create the folder where the outgoing mail is copied.");

  defvar("newbiecreatetrashfolder", 1, "New users:Create trash folder",
         TYPE_FLAG, "Auto create the folder where are the deleted mail is saved.");

  defvar("newbiecreatedraftsfolder", 1, "New users:Create drafts folder",
         TYPE_FLAG, "Auto create the folder where are the draft mail is stored.");

  defvar("newbiecreateansweredfolder", 1, "New users:Create answered folder",
         TYPE_FLAG, "Auto create the folder where are the answered mails is stored.",
         0,hide_moveanswered);
}

// hiding defvars...
private int hide_ebook () {
  return !QUERY (extendedabook);
}

private int hide_buttonpathcaudium () {
  return !sizeof (QUERY (buttonpath));
}

private int hide_moveanswered() {
  return !QUERY (moveanswered);
}

private int hide_scan_folders_call_out() {
  return !QUERY(foldersinfo);
}

private int hide_feedimapcache() {
  return !QUERY(feedimapcache);
}

string check_variable (string var, mixed value) {
#if 0
  switch (var) {
  case "langfiledir":
    if (sizeof (value)) {
      array stat = file_stat (value);
      if (!stat || stat[1] != -2)
        return "Must be a directory or empty string.";
    }
    langs_loaded = 0;
    break;
  }
#endif
}

void start () {
}

#if 0
string status () {
  string out = "CAMAS Language Module.";
  out += "<br />Provides these languages :<ul>";
  foreach (sort (indices (lang_progs)), string lang)
  out += "<li>" + lang + "</li>";
  out += "</ul>";
  return out;
}
#endif

string query_provides () {
  return ("camas_features");
}

int feature (int f) {
  switch(f) {
  case FEAT_MAILFILTER:
    return (QUERY (filterbook) && feature (FEAT_USERSETUP));
    break;
  case FEAT_EDITFILTERBOOK:
    return (QUERY (filterbook) && feature (FEAT_USEREDITSETUP));
    break;
  case FEAT_EXTENDEDABOOK:
    return (QUERY (extendedabook) && feature (FEAT_USEREDITSETUP));
    break;
  case FEAT_USERHEADERS:
    return (QUERY (userheaders) && feature (FEAT_USEREDITSETUP));
    break;
  case FEAT_ADDRESSBOOK:
    return (QUERY (addressbook) && feature (FEAT_USERSETUP));
    break;
  case FEAT_EDITADDRESSBOOK:
    return (QUERY (addressbook) && feature (FEAT_USEREDITSETUP));
    break;
  case FEAT_USERSETUP:
    return (QUERY (usersetup) && QUERY (mailboxes));
    break;
  case FEAT_USEREDITSETUP:
    return (feature (FEAT_USERSETUP) && QUERY (usereditsetup));
    break;
  case FEAT_MAILBOXES:
    return (QUERY (mailboxes));
    break;
  case FEAT_USERMAILPATH:
    return (QUERY (usermailpath) && feature (FEAT_USEREDITSETUP));
    break;
  case FEAT_ATTACHMENTS:
    return (QUERY (attachments));
    break;
  case FEAT_INBOXES:
    return (QUERY (inboxes));
  case FEAT_USERADDRESS:
    return (QUERY (useraddress) && feature (FEAT_USEREDITSETUP));
  case FEAT_LDAP:
#if constant(Protocols.LDAP) && constant(Protocols.LDAP.client)
    return (QUERY (ldap));
#else
    return 0;
#endif
  case FEAT_DSN:
    return (QUERY (dsn));
  case FEAT_MAILNOTIFY:
    return (QUERY (mailnotify));
  case FEAT_SHOWHTML:
    return (QUERY (showhtml));
  case FEAT_USERLANGUAGE:
    return (QUERY (userlanguage) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERTRASHFOLDER:
    return (QUERY (usertrashfolder) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERSENTFOLDER:
    return (QUERY (usersentfolder) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERDRAFTSFOLDER:
    return (QUERY (userdraftsfolder) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERANSWEREDFOLDER:
    return (QUERY (useransweredfolder) && feature (FEAT_USEREDITSETUP) && QUERY(moveanswered));
  case FEAT_USERSENTSAVEATTACHMENTS:
    return (QUERY (usersentsaveattachments) && feature (FEAT_USERSENTFOLDER) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERBCCCOPY:
    return (QUERY (userbcccopy) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERCANCHANGENAME:
    return (QUERY (usercanchangename) && feature (FEAT_USEREDITSETUP));
	case FEAT_USERCANREPLYONTOP:
		return (QUERY (usercanreplyontop));
  case FEAT_SAVEMAILCOPY:
    // Broken
    return (QUERY (composesavemail));
    //  case FEAT_USERSETREPLYPREFIX:
    //    return (QUERY (chgreplymsgprefix) && feature (FEAT_USEREDITSETUP));
  case FEAT_USERSETUPSHOWHIDDENHEADERS:
    return (QUERY (showhiddenheaders) && feature (FEAT_USEREDITSETUP));
    //  case FEAT_FORWARD:
    //    break;
  case FEAT_SHOWTEXT:
    return (QUERY (showtext));
  case FEAT_ORGANIZATION:
    return (QUERY (organization)) && feature (FEAT_USEREDITSETUP);
  case FEAT_USERDEFAULTPOSTLOGINSCREEN:
    return QUERY(defaultpostloginscreen) && feature (FEAT_USEREDITSETUP);
  case FEAT_USERCANDISABLEIMAPCACHEFEEDER:
    return QUERY(userfeedimapcache) && QUERY(feedimapcache);
  default:
    return 0;
  }
}


/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: dsn
//! Add DSN (Delivery Status Notification) support when sending mail. This requires the use of SMTP for outgoing mail (instead of sendmail). You also have to make sure your SMTP server supports DSN.
//!  type: TYPE_FLAG
//!  name: Outgoing mail:DSN support
//
//! defvar: composesavemail
//! If enabled, mail will by default be saved when sending, but a checkbox with 'Don't save this mail' is shown. If disabled, mail will not be sent by default.
//!  type: TYPE_FLAG
//!  name: Outgoing mail:By default save composed mail into sentmail folder
//
//! defvar: linkwindow
//! Enables opening of links in a new window.
//!  type: TYPE_FLAG
//!  name: Features:Open links in new window
//
//! defvar: extendedabook
//! Enables extended addressbook.
//!  type: TYPE_FLAG
//!  name: Features:Extended addressbook
//
//! defvar: extendedabookfields
//! Comma-separated list of field names.
//!  type: TYPE_STRING
//!  name: Features:Extended addressbook fields.
//
//! defvar: deleteinebook
//! When deleting an entry in the addresbook, also delete a matching one in the extended addressbook. You probably want to say yes unless you plan your users to use either plain or extended addressbook.
//!  type: TYPE_FLAG
//!  name: Features:Also delete in extended addressbook
//
//! defvar: addressbook
//! Enables the addressbook. Addressbook is disabled if User setup is.
//!  type: TYPE_FLAG
//!  name: Features:Addressbook
//
//! defvar: attachments
//! Enables sending of attachments.
//!  type: TYPE_FLAG
//!  name: Features:Attachments
//
//! defvar: logout
//! Enable the logout button.
//!  type: TYPE_FLAG
//!  name: Features:Logout
//
//! defvar: usermailpath
//! Determines if users should be allowed to set the mail folder. Is disabled if User setup is.
//!  type: TYPE_FLAG
//!  name: Features:User mail path
//
//! defvar: mailboxes
//! If disabled, only INBOX can be accessed.
//!  type: TYPE_FLAG
//!  name: Features:Mailboxes
//
//! defvar: filterbook
//! Enables the mailfilter. Mail filter is disabled if User setup is.
//!  type: TYPE_FLAG
//!  name: Features:Mail Filter
//
//! defvar: autofilter
//! With this option a rule is automatically build when you move amail to a specified mailbox. When the same sender come back,his mail is moved to the mailbox you already specifiedAuto Filter will be disable if Mail Filter is
//!  type: TYPE_FLAG
//!  name: Features:Auto Filter
//
//! defvar: moveanswered
//! When enabled, four more actions are available:<br /><ul><li> <b>&lt;camas_replymove&gt;</b> : "reply and move"</li><li> <b>&lt;camas_replymovemarked&gt;</b> : "reply all marked messages and move"</li><li> <b>&lt;camas_replytoallmove&gt;</b> : "reply to all and move"</li><li> <b>&lt;camas_forwardmove&gt;</b> : "forward and move"</li></ul><br />The mail currently processed is moved into a answered-mailfolder.<br /><br />It is useful if you have to answer lots of emails. This way, you can keep only those not answered in your mailbox.
//!  type: TYPE_FLAG
//!  name: Features:Move Answered
//
//! defvar: userautofilter
//! User can disable autofilter in their preferences
//!  type: TYPE_FLAG
//!  name: Features:User auto filter
//
//! defvar: usersetup
//! If enabled, each user has a setup (including addressbook, signature etc.) saved either in a mailbox or in a file. Is disabled if mailboxes is disabled and User preferences directory is empty.
//!  type: TYPE_FLAG
//!  name: Features:User setup
//
//! defvar: usereditsetup
//! Determines if the users should be able to change their own setup. This option is ignored if "User setup" is disabled.
//!  type: TYPE_FLAG
//!  name: Features:User can change setup
//
//! defvar: inboxes
//! Lets the user specify a list of inboxes which may be presented as a list in the user interface. 
//!  type: TYPE_FLAG
//!  name: Features:User specified inboxes
//
//! defvar: useraddress
//! Enables a user to change his/her email address in the user setup.
//!  type: TYPE_FLAG
//!  name: Features:User specified address
//
//! defvar: mailnotify
//! Enables a user to open a mail notification window which is reloaded periodically (every five minutes). This feature is is built on javascript in the layout file, so make sure you use an updated layout file.
//!  type: TYPE_FLAG
//!  name: Features:Mail notification window
//
//! defvar: showhtml
//! Enables a user to have messages in HTML format shown instead of of the corresponding text version. HTML messages are parsed and reformatted so that no unsecure HTML tags are displayed. For example, links to mailparts are handled but all other links are removed. Javascript is not allowed. The parsing may be rather CPU-intensive, and the rendering on the client side depends on the browser used. Heavily loaded HTML pages may then cause unpredicted behaviour.
//!  type: TYPE_FLAG
//!  name: Features:Show HTML messages
//
//! defvar: userheaders
//! Enables a user to add extra headers to outgoing mail.
//!  type: TYPE_FLAG
//!  name: Features:User specified mail headers
//
//! defvar: userlayouts
//! Allow a user to choose the layout in the login screen and in his preferences.
//!  type: TYPE_FLAG
//!  name: Features:User can choose layout
//
//! defvar: deletemethod
//! Choose whether mail is deleted immediately or moved to a trash folder first, or whether both methods should be available.
//!  type: TYPE_STRING_LIST
//!  name: Features:Delete method
//
//! defvar: usercanchangename
//! Enables users to change their name in the configuration interface.<br /><i>Yes, this <b>is</b> stupid, but some strange people wants such features...</i>.
//!  type: TYPE_FLAG
//!  name: Features:User can change name
//
//! defvar: userlanguage
//! Enable a user to choose a different language than the one setup in the configuration interface.
//!  type: TYPE_FLAG
//!  name: Features:User can choose language
//
//! defvar: usertrashfolder
//! Enable a user to specify the name of the trash folder other than <i>"Trash"</i>.
//!  type: TYPE_FLAG
//!  name: Features:User can specify trash folder
//
//! defvar: usersentfolder
//! Enable a user to specify the name of the sent-mail folder other than <i>"sent-mail"</i>.
//!  type: TYPE_FLAG
//!  name: Features:User can specify sentmail folder
//
//! defvar: userdraftsfolder
//! Enable a user to specify the name of the drafts folder other than <i>"Drafts"</i>.
//!  type: TYPE_FLAG
//!  name: Features:User can specify drafts folder
//
//! defvar: useransweredfolder
//! Enable a user to specify the name of the answered folder other than <i>"answered-mail"</i>.
//!  type: TYPE_FLAG
//!  name: Features:User can specify answered folder
//
//! defvar: userbcccopy
//! When enabled, user can specify a BCC address to be added to all outgoing mail.
//!  type: TYPE_FLAG
//!  name: Features:User can specify a default Bcc
//
//! defvar: userblindsend
//! When enabled, allow a user who has several recipients in the To header to send a mail for each one of them, thus the recipients don't see each other email adresses. This is not the same as BCC since the To header is set to the address of the recipient for each one. Also mutliple BCC doesn't prevent the recipients to see each other email addresses.<br /><i>Note</i>: This is only available when using CAMAS: Tags.
//!  type: TYPE_FLAG
//!  name: Features:User can use 'blind sending'
//
//! defvar: defaultpostloginscreen
//! Default login screen after the user successfully authentificated. Usually it is mailindex but other values like compose or folderlist can be usefull.
//!  type: TYPE_MULTIPLE_STRING
//!  name: Features:User default post login screen
//
//! defvar: showhiddenheaders
//! When reading a mail, users can show or hide the hidden headers of the mail. If this option is enabled, the user can choose whether to show or hide this button.
//!  type: TYPE_FLAG
//!  name: Features:User configurable 'show full headers'-button
//
//! defvar: usersentsaveattachments
//! Enable a user to specify to save the attachments in the sentmail folder.<br /><b>Note:</b> if the sent mail folder cannot be specified, then this feature is automaticly disabled and the attachement <b>will</b> be saved into sentmail folder.
//!  type: TYPE_FLAG
//!  name: Features:User can choose to save attachments
//
//! defvar: usersignaturecols
//! Change the max line length for signature box in the preferences page.
//!  type: TYPE_INT
//!  name: Features:User signature size
//
//! defvar: usereditfilterbook
//! Enable a user to do its own filters.
//!  type: TYPE_FLAG
//!  name: Features:User can edit filters
//
//! defvar: showtext
//! Display text attachments.
//!  type: TYPE_FLAG
//!  name: Features:Show text messages
//
//! defvar: chgreplymsgprefix
//! If set, then user can change the default prefix added to lines of message they reply to.
//!  type: TYPE_FLAG
//!  name: Features:User can change reply prefix
//
//! defvar: organization
//! Allow the user to specify the organization he belongs to.
//!  type: TYPE_FLAG
//!  name: Features:Organization
//
//! defvar: displayinlineimages
//! List of MIME-subtypes to display inline.<br />Enter one subtype per line, examples are :<br />gif, ief, jpeg, png, tiff, x-cmu-raster, x-ms-bmp, x-portable-anymap, x-portable-bitmap, x-portable-graymap, x-portable-pixmap, x-rgb, x-xbitmap, x-xpixmap, x-xwindowdump
//!  type: TYPE_TEXT_FIELD
//!  name: Features:Display inline images
//
//! defvar: jslogout
//! If set, JavaScript code will be added to close the session if the user closes the window instead of following a 'logout' link.
//!  type: TYPE_FLAG
//!  name: Features:Add JavaScript to close the session
//
//! defvar: foldersinfo
//! Show some folders information: number of (total, recent, unseen) messages, folder size, ...
//!  type: TYPE_FLAG
//!  name: Features:Display folders information
//
//! defvar: scan_folders_call_out
//! It might be convenient for you to search for foldersinfo in the mailindex if you have a left mail folders info ( la Mozilla or Outlook). As it will require more ressources you can choose not to run this each time the user go into mailindex (set this option to 1) or every x times the user go in mailindex (set this option to x). Set 0 to disable this feature.
//!  type: TYPE_INT
//!  name: Features:Scan folders in the mailindex screen
//
//! defvar: ldap
//! Enables a user to search for names in a ldap directory
//!  type: TYPE_FLAG
//!  name: LDAP Global Addressbook:Use ldap
//
//! defvar: ldapserver
//! Specifies the ldap server to use.
//!  type: TYPE_STRING
//!  name: LDAP Global Addressbook:LDAP server
//
//! defvar: ldapsearchroot
//! The searchroot for ldap searches. For example: o=Your company, c=your country. Could be empty
//!  type: TYPE_STRING
//!  name: LDAP Global Addressbook:Search root
//
//! defvar: ldapuser
//! The user you should use connect. NOTE! This is ldap user format. Could be empty
//!  type: TYPE_STRING
//!  name: LDAP Global Addressbook:User
//
//! defvar: ldappass
//! The password you should use to connect. Could be empty.
//!  type: TYPE_STRING
//!  name: LDAP Global Addressbook:Password
//
//! defvar: ldapshowou
//! If "yes" include last level ou in result
//!  type: TYPE_FLAG
//!  name: LDAP Global Addressbook:Show ou
//
//! defvar: ldapversion
//! The LDAP protocol version to use.
//!  type: TYPE_INT_LIST
//!  name: LDAP Global Addressbook:Version
//
//! defvar: ldapmail
//! The LDAP mail attribute in case it's not the standard "mail".
//!  type: TYPE_STRING|VAR_EXPERT
//!  name: LDAP Global Addressbook:Mail attribute
//
//! defvar: sitesig
//! Piece of text added to every outgoing message.
//!  type: TYPE_TEXT_FIELD
//!  name: Outgoing mail:Site-wide signature
//
//! defvar: siteorg
//! Site-wide organization.
//!  type: TYPE_STRING
//!  name: Outgoing mail:Site-wide organization
//
//! defvar: includeipnumber
//! Include the header field 'X-Originating-IP' in outgoing mail to indicate from where the mail was sent.
//!  type: TYPE_FLAG
//!  name: Outgoing mail:Show IP-address
//
//! defvar: userimapport
//! Enable a user to give the port of their imap server.<br />You don't need to give them this choice unless there are 'power users' ;).<br /><b>WARNING:</b> This method has priority among all others
//!  type: TYPE_FLAG
//!  name: Login: User can choose IMAP port number at login prompt
//
//! defvar: threadsearchafter
//! When using thread sorting, you want to match one specific pattern only
//!  type: TYPE_STRING
//!  name: Mailindex: Thread sorting: regexp string
//
//! defvar: mime_remap
//! Change the MIME type of mail or attachments. Format is old_type/old_subtype:new_type/new_subtype
//!  type: TYPE_TEXT_FIELD
//!  name: Readmail Page:Change MIME types
//
//! defvar: newbiesetup
//! Choose whether new users (to CAMAS) will enter preferences screen when logged in for the first time.
//!  type: TYPE_FLAG
//!  name: New users:Enter setup
//
//! defvar: newbiecreatefolder
//! Comma separated list of foldernames which will be created when logging in for the first time.<br />
//!  type: TYPE_STRING
//!  name: New users:Create folders
//
//! defvar: newbiecreatesentfolder
//! Auto create the folder where the outgoing mail is copied.
//!  type: TYPE_FLAG
//!  name: New users:Create sent folder
//
//! defvar: newbiecreatetrashfolder
//! Auto create the folder where are the deleted mail is saved.
//!  type: TYPE_FLAG
//!  name: New users:Create trash folder
//
//! defvar: newbiecreatedraftsfolder
//! Auto create the folder where are the draft mail is stored.
//!  type: TYPE_FLAG
//!  name: New users:Create drafts folder
//
//! defvar: newbiecreateansweredfolder
//! Auto create the folder where are the answered mails is stored.
//!  type: TYPE_FLAG
//!  name: New users:Create answered folder
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

