/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_runtime_admin.pike,v 1.43.2.2 2004/03/19 10:09:04 vida Exp $
 */
//
//! module: CAMAS: Runtime Admin Interface
//!  This module provide CAMAS runtime admin interface.
//! inherits: module
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_runtime_admin.pike,v 1.43.2.2 2004/03/19 10:09:04 vida Exp $
//
#include <module.h>
inherit "module";
#include <camas/globals.h>
#include <camas/msg.h>		// MSG () Language macros

constant cvs_version   = "$Id: camas_runtime_admin.pike,v 1.43.2.2 2004/03/19 10:09:04 vida Exp $";
constant module_type   = MODULE_PROVIDER;
constant module_name   = "CAMAS: Runtime Admin Interface";
constant module_doc    = "This module provide CAMAS runtime admin interface.<br/>"
                         "In order to access it, fill in the login and password below "
                         "and use them to login on Camas as you would do as a normal user.";
constant module_unique = 1;
constant thread_safe = 1;

// Definition to give us an easy way to make the code and understand it :)
#define CAMAS_LOGGER  id->conf->get_provider ("camas_logger")
#define SESSIONS   id->conf->get_provider (CAMAS_MODULE->session_module);

object lock;

// Module creation & configuration
void create()
{
#ifdef CAMAS_DEBUG
  // Debug
  defvar("debug",1,"Debug",TYPE_FLAG,"Debug the call / errors into Caudium "
         "error log ?");
#endif
  // Runtime admin interface configuration
  defvar("adminlogin", "", "Login Name", TYPE_STRING,
         "The CAMAS Runtime Administration Interface can be reached by logging "
         "in using this login name and the specified password.");

  defvar("adminpasswd", "", "Password", TYPE_PASSWORD,
         "The CAMAS Runtime Administration Interface can be reached by logging "
         "in using this password and the specified login name.");
  defvar("enableaif",1,"Enable CAMAS Interface ?", TYPE_FLAG,
         "Enable the admin interface thru CAMAS");
}

// Start of the module
void start(int cnt, object conf)
{
  module_dependencies(conf, ({ "tablify", "business" }));
}

// What's this module provides
string query_provides()
{
  return("camas_adminif");
}

// Head of admin interface
string admin_head(string nexturl)
{
  string ret = "";
  ret+="<imho_doctype>";
  ret+="<html><head><title>CAMAS Runtime Admin</title></head>";
  ret+="<body leftmargin=0 topmargin=0 bottomargin=0 rightmargin=0 marginheight=0 marginwidth=0 bgcolor=\"#ffffff\" text=\"#000000\" link=\"#0000ff\" vlink=\"#0000ff\" alink=\"#ff0000\">";
  ret+="<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>";
  ret+="<imho_image border=\"0\" quant=\"250\" fg=\"white\" bg=\"#3030c0\" align=\"left\" width=\"500\" height=\"32\" image=\"bannerleft\" hspace=\"0\" text=\"CAMAS Runtime Admin\" />";
  ret+="<imho_image width=\"100%\" quant=\"250\" fg=\"&imho_thcolor;\" hspace=\"0\" bg=\"#3030c0\" border=\"0\" height=\"32\" image=\"bannerright\" />";
  ret+="<form action=\""+nexturl+"admin\" method=\"post\" name=\"imhoupdateadmin\">";
  ret+="</td></tr></table>";
  return ret;
}

// Foot of admin if
string admin_foot(object id)
{
  string ret = "";
#ifdef CAMAS_DEBUG
  if (QUERY (debug))
  {
    ret += "<hr /><imho_dumpid>";
    object sess123 = SESSIONS;
    if (objectp (sess123)) {
      mapping sessions = sess123->sessions ();
      ret += "<hr /><pre>";
      ret += sprintf("session=%O\n", sessions);
      ret += "</pre>";
    }
  }
#endif
  ret += "</body></html>";
  return ret;
}

// Display camas main module uptime
string admin_uptime(object id)
{
  object camas_module = CAMAS_MODULE;
  string ret = "";
  int uptime = time () - camas_module->starttime;
  ret += "<br /><gh3>Uptime: " + sprintf ("%.1f hours", ((float) uptime) / 3600.0) + "</gh3></a><br />";
  return ret;
}

// Diplay number of active users
string admin_active_users(object id)
{
  string ret = "";
  object sess123 = SESSIONS;
  int nb_csessions = 0;
  
  if (objectp (sess123))
  {
    mapping sessions = sess123->sessions ();
    foreach (indices (sessions), string s) 
    {
      object csess = sessions[s]->values->CAMAS;
      if(objectp(csess))
      {
         CDEBUG(sprintf("session %s is valid camas session\n", s));
         nb_csessions++;
      }
    }
    CDEBUG(sprintf("nb_csessions=%d\n", nb_csessions));
    ret += sprintf("<a name=activeusers>"+sizeof(sessions)+" Caudium session of which %d appear to be "
      "running Camas session</a><br />", nb_csessions);
  }
  return ret;
}

// Table listing the current users
string admin_current_users(object id, object sessobj, string action)
{
  string ret = "";
  object camas_module = CAMAS_MODULE;

  switch(action)
  {
  case "changesort":
    if (id->variables->col)
      sessobj->adminsortcolumn = (int) id->variables->col;
    if (id->variables->dir)
      sessobj->sortup = (int) id->variables->dir;
    sessobj->users = Array.sort_array(sessobj->users,lambda(array a1,array a2, int col, int dir) {
                                        return( dir?(a1[col] > a2[col]):(a1[col] < a2[col]) ); }, sessobj->adminsortcolumn, sessobj->sortup);
    break;
  case "index":
    sessobj->showfrom = (int) id->variables->showfrom;
    break;
  }
  sessobj->users = ({ });
#if constant(thread_create)
  if(!lock)
    lock = camas_module->global_lock->lock();
#endif
  mixed err = catch {
    object sess123 = SESSIONS;
    if (objectp (sess123)) {
      mapping sessions = sess123->sessions ();

      if (!sessobj->users)
        sessobj->users = ({ });

      foreach (indices (sessions), string s) {
        object csess = sessions[s]->values->CAMAS;
        if(!objectp(csess))
          continue;
        int msgsreceived = 0;
        array user = ({ });
        // get total number of emails. The user have to go in folderinfo before (it's not a bug, it's a feature ;))
        if(csess->foldersinfo) {
          foreach(indices(csess->foldersinfo), string s) {
            msgsreceived += csess->foldersinfo[s][0];
          }
        }

        if (csess->login) {
          user+=({ csess->login });
          user+=({ csess->address });
          user+=({ sprintf("<input type=\"checkbox\" name=\"session_%s\" value=\"1\">", s) });
          user+=({ csess->logintime });
          user+=({ time() - csess->lastusage });
          user+=({ csess->ip });
          user+=({ (csess->mails ? sizeof (csess->mails) : 0) });
          user+=({ (csess->totalsentmaildata ? csess->totalsentmaildata : 0) });
          user+=({ (csess->totalmsgsent ? csess->totalmsgsent : 0) });
          user+=({ (csess->mailboxes ? sizeof(csess->mailboxes) : 0) });
          user+=({ (msgsreceived > 0 ? msgsreceived: 0) });
          user+=({ csess->userstat_to });
          user+=({ csess->userstat_cc });
          user+=({ csess->userstat_subject });
          user+=({ csess->userstat_replymessageid });
          user+=({ csess->userstat_replydate });
          user+=({ csess->userstat_date });
          user+=({ csess->layout });
          user+=({ csess->language });
          user+=({ csess->screen });
          sessobj->users += ({ user });
        }
      }
    }
  };
#if constant(thread_create)
  destruct(lock);
#endif
  if(err)
    report_error("error in camas_runtime_admin.pike: %s\n", describe_backtrace(err));
  sessobj->users = Array.sort_array(sessobj->users,lambda(array a1,array a2, int col, int dir) {
                                      return( dir?(a1[col] < a2[col]):(a1[col] > a2[col]) ); }, sessobj->adminsortcolumn, sessobj->sortup);

  ret+="<tablify nice cellseparator='|' rowseparator='~'>";
  array columns = ({ "IMAP Login", "Address", "Sel", "Login Time", "Idle", "IP-Addr", "User stats", "Layout", "Language", "Screen" });
  for (int i = 0; i < sizeof (columns); i++) {
    ret += "<a href=\"";
    ret += CSESSION->nexturl + "?actionchangesort=1&col=" + i + "&dir=";
    ret += (sessobj->sortup == 0 && sessobj->adminsortcolumn == i ? "1" : "0");
    ret += "\"><imho_image bg=\"#113377\" border=\"0\" alt=\"" + MSG(M_CHANGESORTORDER);
    ret += "\" size=\"60\" scale=\"0.25\" image=\"";
    ret += ((sessobj->adminsortcolumn == i) ? (sessobj->sortup ? "arrowup" : "arrowdown") : "arrownone");
    ret += "\" /><font color=\"#ffffff\"><font size=\"-1\">"+ columns[i]+"</font></font></a>";
    if(i + 1 < sizeof(columns))
      ret += "|";
  }
  int i = 0;

  for (i = sessobj->showfrom; i < sizeof(sessobj->users) && i < sessobj->showfrom+20; i++) {
    array user = sessobj->users[i];
    string detailed_mailstats = "";
    int k = 11;
    for(int j = 0; j < sizeof(user[k]); j++)
    {
      detailed_mailstats += "<tr><td>Mail # " + j + "</td><td>"
        + "To: " + HTML_ENCODE_STRING(user[k][j]) + "<br/>";
      if(sizeof(user[k+1][j]))
        detailed_mailstats += "Cc: " + HTML_ENCODE_STRING(user[k+1][j]) + "<br>";
      detailed_mailstats += "Subject: " + HTML_ENCODE_STRING(user[k+2][j]) + "<br/>"
        + "Reply messageid: " + HTML_ENCODE_STRING(user[k+3][j]) + "<br/>"
        + "Reply date: " + HTML_ENCODE_STRING(user[k+4][j]) + "<br/>"
        + "Date: " + HTML_ENCODE_STRING(ctime(user[k+5][j])) + "<br/>"
        + "</td></tr>";
    }
    ret+="~"+user[0]+"|"+user[1]+"|"+user[2]+"|"+ctime(user[3])+"|"+(user[4]/60)+" mins |";
    ret+=user[5]+"|"
      +"<table border=\"1\">"
      + "<tr><td>Number of mails in current mbox</td><td>" + user[6] + "</td></tr>"
      + "<tr><td>Total mail data sent (Bytes)</td><td>" + user[7] + "</td></tr>"
      + "<tr><td>Total msgs sent</td><td>" +user[8] + "</td></tr>"
      + "<tr><td>Number of mailboxes</td><td>" +user[9] + "</td></tr>"
      + "<tr><td>Number of message received</td><td>" +user[10]+ "</td></tr>"
      + detailed_mailstats + "</table>"
      + "|"+HTML_ENCODE_STRING(user[k+6])+"|"+HTML_ENCODE_STRING(user[k+7])+"|"+user[k+8];
  }
  ret+="</tablify>";
  ret+=sprintf("&nbsp;Showing users %d-%d of %d", sessobj->showfrom+1, sessobj->showfrom+20<sizeof(sessobj->users)?sessobj->showfrom+20:sizeof(sessobj->users),sizeof(sessobj->users));
  if (sessobj->showfrom > 0) {
    ret += "<a href=\"" + CSESSION->nexturl + "?actionindex=1&showfrom=";
    ret += (sessobj->showfrom - 20 > 0 ? sessobj->showfrom - 20 : 0) + "\">[Previous]</a>";
  }
  if (sessobj->showfrom + 20 < sizeof (sessobj->users)) {
    ret += "<a href=\"" + CSESSION->nexturl + "?actionindex=1&showfrom=";
    ret += (sessobj->showfrom + 20) + "\">[Next]</a>";
  }
  ret+="<br />";
  return ret;
}

// Statistics on logger
string admin_logger_stats(object id)
{
  object camas_logger = CAMAS_LOGGER;
  string ret = "";
  if (objectp (camas_logger)) {
    ret += "<hr /><center><a name=stats><gh3>Statistics since last restart of CAMAS main module.</gh3></a><br />";
    ret += "<tablify nice cellseparator='|' rowseparator='~'>";
    ret += " Statistics | &nbsp;";
    ret += "~Logins | "+ camas_logger->stats->nologins;
    ret += "~Failed logins | "+ camas_logger->stats->nofailedlogins;
    ret += "~Logouts | "+ camas_logger->stats->nologouts;
    ret += "~Autologouts | "+ camas_logger->stats->noautologouts;
    ret += "~Messages sent | "+ camas_logger->stats->nomailsent;
    ret += "~Bytes sent | " + camas_logger->stats->nobytessent;
    ret += "~IMAP errors | "+ camas_logger->stats->noimapfailures;
    ret += "~SMTP errors | "+camas_logger->stats->nosmtpfailures;
    ret += "</tablify>";
    ret += "</center>";
  }
  return ret;
}

// Playing with SQL. For this to work, you have to select SQL as method in CAMAS logger
string admin_logger_sql(object id)
{
  object camas_logger = CAMAS_LOGGER;
  object db;
  object res;
  array login;
  string ret = "<hr /><center><a name=stats><gh3>SQL examples statistics of CAMAS.</gh3></a>(work in progress).<br />";
  if (objectp (camas_logger) && camas_logger->QUERY(method) == "sql") {
    db = Sql.Sql(camas_logger->QUERY(dburl));

    // simple table
    string query = sprintf("SELECT * from %s order by date", camas_logger->QUERY(logtable_login));
    if(catch(res = db->big_query(query)))
      return (sprintf("CAMAS ADMIN IF: Error running SQL query '%s'.\n", query));
    int n = res->num_rows();
    string action;
    for (int i = 0; i < n; i++)
    {
      if(i == 0)
      {
        ret += "<tablify nice cellseparator='|' rowseparator='~'>";
        ret += "Date|Login|Action";
      }
      login = res->fetch_row();
      action = replace((string) login[2], ({ "0", "1", "2", "3" }),
                       ({ "login", "failed login", "logout", "autologout" }));
      ret += "~"+login[0]+"|"+login[1]+"|"+action+"\n";
      if(i+1 == n )
        ret += "</tablify>";
    }

    // diagram for proof of concept. Only tested on mysql
    ret += "<diagram type=bar width=800 height=250 name='Login actions by hour' hordgrid>";
    ret += "<data xnamesvert xnames form=column separator=|>";
    for (int h = 0; h < 24; h++)
    {
      ret += "\n h=" + h + "|";
      for (int i = 0; i <= 3; i++)
      {
        string query = sprintf("SELECT count(*) from %s where time > '%d:00:00' and time < '%d:00:00' and action=%d", camas_logger->QUERY(logtable_login), h, h+1, i);
        if(catch(res = db->big_query(query)))
          return (sprintf("CAMAS ADMIN IF: Error running SQL query '%s'.\n", query));
        login = res->fetch_row();
        if(i != 0)
          ret += "|";
        ret += login[0];
      }
    }
    ret += "</data>";
    ret += "<legend separator=,>login,failed login,logout,autologout</legend>";
    ret += "</diagram>";
  }
  ret += "</center>";
  return ret;
}

// display the form to update and logout
string admin_form_updatelogout(object id)
{
  string ret = "";
  ret+="<imho_submit name=\"actionupdate\" value=\"Update\">";
  ret+="<imho_submit name=\"actionlogout\" value=\"Logout\">";
  ret+="<imho_submit name=\"actionerase\" value=\"Erase selected\">";
  ret+="<imho_submit name=\"actionerasesessions\" value=\"Erase all sessions\">";
  ret+="</form>";
  return ret;
}

// The admin interface itself

array getselected(object id)
{
  array(string) res = ({ });
    foreach (indices (id->variables), string var) {
      if (id->variables[var] == "1") {
        int n; string nr;
        if (n = sscanf (var, "session_%s", nr)) {
          if(n) {
            res += ({ nr });
          }
        }
     }
  }
  return res;
}

string handle_admin_interface(object id, object sessobj){
  string ret = "";
  string action = "";

  object camas_module = CAMAS_MODULE;

  if (!objectp(camas_module)) {
    // CAMAS main module is not present... Exiting...
    return "";
  }

  CDEBUG("Admin if called from "+id->remoteaddr );

  if(!QUERY(enableaif)) {
    CDEBUG("Interface is not enabled... Throw user out of there.");
    ret += "<html><head><title>CAMAS Admin Interface</title></head>"
           "<body bgcolor=white text=black >"
           "<b> The CAMAS Runtime Admin Interface is not enabled.</b>"
           "<br /> Please enable it using Caudium Configuration Interface"
           "<end_session>"
           "</body></html>";
    return ret;
  }
  foreach(indices(id->variables),string var) {
    string foo;
    if (var)
      if(sscanf(var,"action%s",foo))
        action=foo;
  }

  switch(action) {
  case "logout":
    CDEBUG("Logout from " + id->remoteaddr);
    CAMAS.Tools.destroy_csession(id);
    ret+="<br /><br />";
    ret+=MSG(M_LOGOUTMSG);
    ret+="</body></html>";
    return ret;
    break;
  case "erase":
  case "erasesessions":
    object sess123 = SESSIONS;
    int nb_deleted = 0;
    if (objectp (sess123)) {
      mapping sessions = sess123->sessions ();
      array todelete;
      if(action == "erase")
      {
        ret += "<a href=\"" + CSESSION->nexturl + "admin\">Back</a>";
        todelete = getselected(id);
      }
      if(action == "erasesessions")
        todelete = indices (sessions);
      foreach (todelete, string s) {
        object csess;
        if(sessions[s])
          csess = sessions[s]->values->CAMAS;
        if(csess && objectp(csess))
        {
          CAMAS.Tools.low_destroy_session(csess);
          m_delete(sessions[s]->values, "CAMAS");
          nb_deleted++;
        }
      }
    }
    CDEBUG("Erased sessions from " + id->remoteaddr);
    ret += "<br /><br />";
    ret += sprintf("%d session(s) have been erased\n", nb_deleted);
    ret += "</body></html>";
    return ret;
  }
  ret += admin_head(CSESSION->nexturl);
  ret += admin_uptime(id);
  ret += admin_active_users(id);
  ret += admin_current_users(id, sessobj, action);
  ret += admin_logger_stats(id);
  ret += admin_logger_sql(id);
  ret += admin_form_updatelogout(id);
  ret += admin_foot(id);
  return ret;
}


/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! Debug the call / errors into Caudium error log ?
//!  type: TYPE_FLAG
//!  name: Debug
//
//! defvar: adminlogin
//! The CAMAS Runtime Administration Interface can be reached by logging in using this login name and the specified password.
//!  type: TYPE_STRING
//!  name: Login Name
//
//! defvar: adminpasswd
//! The CAMAS Runtime Administration Interface can be reached by logging in using this password and the specified login name.
//!  type: TYPE_PASSWORD
//!  name: Password
//
//! defvar: enableaif
//! Enable the admin interface thru CAMAS
//!  type: TYPE_FLAG
//!  name: Enable CAMAS Interface ?
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

