/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_layoutimho_default.pike,v 1.1.2.3 2004/02/18 13:09:00 vida Exp $
 */

#include <module.h>
#include <camas/defaultlayout.h>

inherit "module";
inherit "caudiumlib";

//
//! module: CAMAS: Default Layout
//!  This module handle default layout (e.g. skin) for CAMAS.<br />
//!  <b>This module is automatically selected if you select "CAMAS: Main
//!  module".</b>
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_layoutimho_default.pike,v 1.1.2.3 2004/02/18 13:09:00 vida Exp $
//

constant cvs_version = "$Id: camas_layoutimho_default.pike,v 1.1.2.3 2004/02/18 13:09:00 vida Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Default IMHO Layout (DEPRECATED)";
constant module_doc  = "This module handle default layout (e.g. skin) for "
                       "CAMAS IMHO screens. These screens are the screens used "
                       "in Camas 1.0 and in IMHO. "
                       "<br /><b>This module is automatically selected if "
                       "you select \"CAMAS: IMHO Screens\".</b>";
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)
// this is a default Camas layout
constant is_default = 1;

void create () {
   defvar("loginlayout", 1, "Default layout for the login prompt",
     TYPE_FLAG, "Is this layout the layout used for the login prompt ?<br />"
     "Obviously only one layout can have this flag set to yes.<br/>"
     "<i>Note</i>: You need to reload this module or restart Caudium once you "
     "modify the login layout");
}

void start (int num, object conf) {
  module_dependencies (conf, ({ "camas_layout_manager" }));
  conf->get_provider ("camas_layout_manager")->add_layout (this_object ());
}

void stop () {
  my_configuration ()->get_provider ("camas_layout_manager")->remove_layout (this_object ());
}

string status () {
  return "CAMAS Default Layout Module.<br />";
}

string query_provides ()
{
  return ("camas_layout");
}

string name () {
  return "IMHO";
}

string get_layout_data (string layout, void|int screen) {
  return DEFAULTLAYOUT;
}


/*
 * If you visit a file that doesn't contain these lines at its end, please     
 * cut and paste everything from here to that file.                            
 */                                                                            

/*
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: loginlayout
//! Is this layout the layout used for the login prompt ?<br />Obviously only one layout can have this flag set to yes.
//!  type: TYPE_FLAG
//!  name: Default layout for the login prompt
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

