//
//  CBPerlObjectInternals.m
//  Camel Bones - a bare-bones Perl bridge for Objective-C
//  Originally written for ShuX
//
//  Copyright (c) 2002 Sherm Pendley. All rights reserved.

#import "CBPerlObjectInternals.h"
#import "Conversions.h"

@implementation CBPerlObject (Internals)

+ (CBPerlObject *) objectWithSV: (SV *)newSV {
    return [[[CBPerlObject alloc] initObjectWithSV: newSV] autorelease];
}

- (CBPerlObject *) initObjectWithSV: (SV *)newSV {
    // Define a Perl context
    dTHX;

    self = [super init];

    // Is it an object reference?
    if (self && sv_isobject(newSV)) {
        HV *stash;
        char *packageName;

        // Store the object and its reference
        _mySV = newSV;
        _myHV = SvRV(newSV);

        // Increment the reference count to keep Perl from releasing it
        SvREFCNT_inc((SV *)_mySV);

        // Find the class name
        stash = SvSTASH((HV*)_myHV);
        packageName = HvNAME(stash);
        className = [[NSString alloc] initWithUTF8String: packageName];
        return self;
    }

    return nil;
}

- (SV *)getSV {
    return _mySV;
}

- (HV *)getHV {
    return _myHV;
}

@end
