#import <EOAccess/EOAccess.h>
#import "VHFGenericRecord.h"

@interface DBConnection:NSObject
{
    NSString	*languageTable;
}

+ (void)initClassWithModel:(NSString*)modelName;
+ (EOModel*)mainModel;
+ (EOModel*)geoModel;
+ (EOModel*)getModelFromName:(NSString*)modelName;
+ (EODatabaseContext*)getContextFromModel:(EOModel*)model;
+ (EODatabaseChannel*)getChannelFromContext:(EODatabaseContext*)context;
+ (EOEntity*)getEntity:(NSString*)entityName;
+ (NSNumber*)getUniqueKeyFor:(EOEntity*)theEntity;

- init;
- (EOModel*)mainModel;
- (EOModel*)geoModel;
- (EOEntity*)getEntity:(NSString*)entityName;

- (NSNumber*)getUniqueKeyFor:(EOEntity*)theEntity;
- (NSNumber*)getUniqueBinaryKey:(NSString*)entityName;

/* geography
 */
- (NSString*)getState:(NSNumber*)stateId language:(NSString*)language;
- (NSArray*)getCountriesForState:(int)stateId language:(NSString*)language addString:(NSString*)string;
//- (NSDictionary*)getCitiesForState:(int)stateId lat:(float)lat long:(float)lon language:(NSString*)language addString:(NSString*)string index:(int*)ix;
- (VHFGenericRecord*)getObjectForCity:(NSString*)city withZip:(NSString*)zip;
- (NSNumber*)getCityIdForCity:(NSString*)city withZip:(NSString*)zip;

- (NSString*)getLocalValueFor:theObject name:(NSString*)name language:(NSString*)language;

/* other
 */
- (NSArray*)getEntriesFromEntity:(NSString*)entityName where:(NSString*)where key:(NSString*)key value:(NSString*)val addString:(NSString*)string;
- (NSDictionary*)getDictFromEntity:(NSString*)entityName key:(NSString*)key value:(NSString*)val addString:(NSString*)string;
- (NSArray*)getEntriesFromEntity:(NSString*)entityName key:(NSString*)key value:(NSString*)val addString:(NSString*)string;
- (NSArray*)addEntriesFromEntity:(NSString*)entityName key:(NSString*)key value:(NSString*)val to:(NSArray*)array;
- (NSArray*)getEntriesFromEntity:(NSString*)entityName key:(NSString*)key values:(NSArray*)vals prefixes:(NSArray*)prefixes addString:(NSString*)string;
- (NSArray*)getEntriesFromEntity:(NSString*)entityName where:(NSString*)qString key:(NSString*)key values:(NSArray*)vals prefixes:(NSArray*)prefixes addString:(NSString*)string;
- (NSArray*)getEntriesFromEntity:(NSString*)entityName where:(NSString*)qString key:(NSString*)key values:(NSArray*)vals prefixes:(NSArray*)prefixes addString:(NSString*)string language:(NSString*)language;

- (NSString*)replaceUmlautIn:(NSString*)string with:(NSString*)subst;
- (NSArray*)sortDict:(NSDictionary*)dict;
+ (NSArray*)sortDictArray:(NSArray*)array;
- (NSArray*)sortDictArray:(NSArray*)array;

- (void)addPrefix:(NSString*)prefix toArray:(NSMutableArray*)array;
- (void)addArray:(NSArray*)array1 toArray:(NSMutableArray*)array;

NSNumber *getSwitchesFromEnv(char *str, NSDictionary* dict);

- (id)getSQLObjectFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
- (NSArray*)getSQLObjectsFromEntityName:(NSString*)entityName where:(NSString*)where sort:(NSString*)sortKey context:(EOEditingContext*)ec;
+ (id)getObjectFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
- (id)getObjectFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
- (NSArray*)getSQLObjectsFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
+ (NSArray*)getObjectsFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
- (NSArray*)getObjectsFromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
- (NSArray*)getObjectsFromEntityName:(NSString*)entityName where:(NSString*)where sort:(NSString*)sortKey context:(EOEditingContext*)ec;
- (NSArray*)getObjectsFromEntityName:(NSString*)entityName where:(NSString*)where sort:(NSString*)sortKey limit:(int)limit context:(EOEditingContext*)ec;
- (id)getAttribute:(NSString*)attributeName fromEntityName:(NSString*)entityName where:(NSString*)where context:(EOEditingContext*)ec;
+ (BOOL)deleteRowsWhere:(NSString*)where entityName:(NSString*)entityName;

- (EODatabaseChannel*)startFetch:(NSString*)entityName where:(NSString*)where offset:(int)offset sort:(NSString*)sortKey context:(EOEditingContext*)ec;
- (NSArray*)fetchObjects:(int)count channel:(EODatabaseChannel*)channel;

- (void)setAttribute:(NSString*)key inObjects:(NSArray*)objects to:(id)value;

- (NSMutableArray*)translateArrayToHTML:(id)array;
- (NSMutableDictionary*)translateDictionaryToHTML:(NSMutableDictionary*)dict;
- (NSMutableDictionary*)translateDictionaryFromHTML:(NSMutableDictionary*)dict;


- (NSString*)formatCurrency:(NSNumber*)value currency:currency format:(int)format;
- (NSString*)formatNumber:(NSNumber*)value res:(int)res prefix:(NSString*)prefix separator:(NSString*)separator suffix:(NSString*)suffix;
- (NSString*)formatFloat:(float)value res:(int)res prefix:(NSString*)prefix separator:(NSString*)separator suffix:(NSString*)suffix;

@end
