/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_envelope_options.h  -  description
                             -------------------
    begin                : Fri Mar 29 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_ENVELOPE_OPTIONS_H
#define INTERFACE_WIDGET_ENVELOPE_OPTIONS_H

#include <gtk--/pixmap.h>
#include <gtk--/checkbutton.h>
#include <gtk--/label.h>
#include <gtk--/separator.h>
#include <gtk--/spinbutton.h>
#include <gtk--/adjustment.h>
#include <gtk--/box.h>
#include <gtk--/menu.h>
#include <gtk--/menuitem.h>
#include <gtk--/optionmenu.h>
#include <gtk--/table.h>
#include "interface_widget_envelope.h"

#include "envelope.h"
#include "lfo.h"

/**
  *@author Juan Linietsky
  */

class Interface_widget_envelope_options : public Gtk::VBox  {

   Envelope_Editor *envelope_editor;
   Gtk::CheckButton *checkbutton_loop;
   Gtk::CheckButton *chckbutton_sustain;
   Gtk::Label *label177;
   Gtk::Label *label178;
   Gtk::Label *label179;
   Gtk::Label *label180;
   Gtk::HSeparator *hseparator145;
   Gtk::HSeparator *hseparator146;
   Gtk::Adjustment *spnbutton_begin_adj;
   Gtk::SpinButton *spnbutton_begin;
   Gtk::Adjustment *spinbutton_end_adj;
   Gtk::SpinButton *spinbutton_end;
   Gtk::Adjustment *spinbutton_sus_begin_adj;
   Gtk::SpinButton *spinbutton_sus_begin;
   Gtk::Adjustment *spinbutton_sus_end_adj;
   Gtk::SpinButton *spinbutton_sus_end;
   Gtk::Label *label181;
   Gtk::Adjustment *spinbutton_lfo_delay_adj;
   Gtk::SpinButton *spinbutton_lfo_delay;
   Gtk::HBox *hbox49;
   Gtk::Label *label182;
   Gtk::OptionMenu *option_lfo_wave;
   Gtk::HBox *hbox50;
   Gtk::Label *label183;
   Gtk::Adjustment *spinbutton_lfo_speed_adj;
   Gtk::SpinButton *spinbutton_lfo_speed;
   Gtk::HBox *hbox51;
   Gtk::Label *label184;
   Gtk::Adjustment *spinbutton_lfo_depth_adj;
   Gtk::SpinButton *spinbutton_lfo_depth;
   Gtk::HBox *hbox52;
   Gtk::CheckButton *checkbutton_lfo_sync;
   Gtk::CheckButton *checkbutton_enable;
   Gtk::CheckButton *checkbutton_lfo_enabled;
   Gtk::HBox *hbox87;
   Gtk::Table *table34;
   Gtk::Label *label295;
   Gtk::Adjustment *spinbutton186_adj;
   Gtk::SpinButton *spinbutton186;
   Gtk::HSeparator *hseparator220;
   Gtk::HBox *hbox90;
   Gtk::VBox *vbox17;


   Envelope *envelope;
   LFO *lfo;

   bool updating;
   void update();
   void update_spin_rules();

	void on_checkbutton_loop_toggled();
	void on_chckbutton_sustain_toggled();
	void on_spnbutton_begin_changed();
	void on_spinbutton_end_changed();
	void on_spinbutton_sus_begin_changed();
	void on_spinbutton_sus_end_changed();
	void on_spinbutton_lfo_delay_changed();
	void on_spinbutton_lfo_speed_changed();
	void on_spinbutton_lfo_depth_changed();
	void on_checkbutton_lfo_sync_toggled();
	void on_checkbutton_enable_toggled();
	void on_checkbutton_lfo_enabled_toggled();
	void on_spinbutton_fadeout_changed();
	gint on_envelope_editor_clicked(GdkEventButton* event);
   	
public:

	void set_envelope(Envelope *p_envelope);
	void set_LFO(LFO *p_lfo);
	

	Interface_widget_envelope_options();
	~Interface_widget_envelope_options();
};

#endif
