(use-package :gl)
;;;
;;; BOUNCE.LSP
;;;
;;; Translation of "bounce.c" by Brian Paul
;;;

(defun sind (x)
 (sin (* x (/ pi 180.))))

(defun cosd (x)
 (cos (* x (/ pi 180.))))

(setq Ball nil
      Zrot 0.0 Zstep 6.0
      Xpos 0.0 Ypos 1.0
      Xvel 0.2 Yvel 0.0
      Xmin -4.0 Xmax 4.0
      Ymin -3.8 Ymax 4.0
      G -0.1)

(defun make-ball ()
 (let (list
       a b
       (da 18.0) (db 18.0)
       (radius 1.0)
       color
       x y z)

  (setq list (glGenLists 1))
  (glNewList list GL_COMPILE)

  (setq color 0)
  (do ((a -90.0 (+ a da))) ((> (+ a da) 90.0))
   ;;
   (glBegin GL_QUAD_STRIP)
   (do ((b 0.0 (+ b db))) ((> b 360.0))

    (if (> color 0)
	(glColor3d 1.0 0.0 0.0)
	(glColor3d 1.0 1.0 1.0))

    (setq x (* (cosd b) (cosd a)))
    (setq y (* (sind b) (cosd a)))
    (setq z (sind a))
    (glVertex3f x y z)

    (setq x (* radius (cosd b) (cosd (+ a da))))
    (setq y (* radius (sind b) (cosd (+ a da))))
    (setq z (* radius (sind (+ a da))))
    (glVertex3f x y z)

    (setq color (- 1 color)))

   (glEnd))

  (glEndList)

  list))

(defun reshape (width height)
 (glViewport 0 0 width height)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 (glOrtho -6.0 6.0 -6.0 6.0 -6.0 6.0)
 (glMatrixMode GL_MODELVIEW))

(setq vel0 -100.0) ; static variable in idle function
(defun idle ()

 (setq zrot (+ zrot zstep))

 (setq xpos (+ xpos xvel))
 (when (>= xpos xmax)
  (setq xpos xmax)
  (setq xvel (- xvel))
  (setq zstep (- zstep)))
 ;;
 (when (<= xpos xmin)
  (setq xpos xmin)
  (setq xvel (- xvel))
  (setq zstep (- zstep)))
 ;;
 (setq ypos (+ ypos yvel))
 (setq yvel (+ yvel g))
 (when (< ypos ymin)
  (setq ypos ymin)
  (when (= vel0 -100.0) (setq vel0 (abs yvel)))
  (setq yvel vel0)))


(defun draw (display window)
 (let (i j)
  
  (glClear GL_COLOR_BUFFER_BIT)
  

  ;;TK_SETCOLOR( Mode, TK_CYAN );
  (glColor3d 1.0 1.0 0.0)
  (glBegin GL_LINES)
  (do ((i -5 (+ i 1))) ((> i 5))
   (glVertex2i i -5) (glVertex2i i 5))
  ;;
  (do ((i -5 (+ i 1))) ((> i 5))
   (glVertex2i -5 i) (glVertex2i 5 i))
  ;;
  (do ((i -5 (+ i 1))) ((> i 5))
   (glVertex2i i -5) (glVertex2f (* i 1.15) -5.9))
  ;;
  (glVertex2f -5.3 -5.35)  (glVertex2f 5.3 -5.35)
  (glVertex2f -5.75 -5.9)  (glVertex2f 5.75 -5.9)
  (glEnd)
  
  (glPushMatrix)
  (glTranslatef Xpos Ypos 0.0)
  (glScalef 2.0 2.0 2.0)
  (glRotatef 8.0 0.0 0.0 1.0)
  (glRotatef 90.0 1.0 0.0 0.0)
  (glRotatef Zrot 0.0 0.0 1.0)
  
  (glCallList Ball)
  (glPopMatrix)
  (glFlush)
  (glxSwapBuffers display window)))

(defun event-loop (display window)
 (let ((animate? t)
       (done? nil)
       (debug t)
       (event (xlib:make-xevent)))
  ;;
  ;; Main event loop
  (loop
   ;;
   ;; If we are animating, calc and redraw each frame until an event occurs
   (when animate?
    (when debug (format t "Animate...~%"))
    (loop
     (draw display window)
     (idle)
     (usleep 0)
     (when (> (xlib:xeventsqueued display xlib:queuedafterflush) 0)
      (return))))
   ;;
   ;; Handle events.  If we are not animating, we wait here for event.
   (when debug (format t "Waiting for event..."))
   (xlib:xnextevent display event)
   (let ((event-type (xlib:xanyevent-type event)))
    (when debug (format t "Event:~a~%" event-type))
    (cond
      ;;
      ;; Expose
      ((eq event-type xlib:expose)
       ;;
       ;; Gobble all other expose events
       (loop
	(when (zerop (xlib:xeventsqueued display xlib:queuedalready))
	 (return))
	(xlib:xnextevent display event)
	(let ((event-type (xlib:xanyevent-type event)))
	 (unless (eq event-type xlib:expose)
	  (xlib:xputbackevent display event)
	  (return)))
	(when debug (format t "Gobble event:~a~%" event-type)))
       (draw display window))
      ;;
      ;; Resize
      ((eq event-type xlib:configurenotify)
       (reshape (xlib:xconfigureevent-width event)
		(xlib:xconfigureevent-height event)))
      ((eq event-type xlib:buttonpress)
       (let ((button (xlib:xbuttonevent-button event)))
	(when debug (format t "Button:~a~%" button))
	(cond ((eq button xlib:button1)
	       (setf animate? (not animate?)))
	      ((eq button xlib:button3)
	       (setf done? t)))))))
   ;;
   (when done? (return)))))

(defun bind-gl-to-window (display screen window)
 (let ((debug t))
  (when debug (format t "Bind-gl-to-current-window.~%"))
  ;;
  (when debug (format t "XGetWindowAttributes..."))
  (let* ((attr (xlib:make-xwindowattributes))
         (foo (xlib:xgetwindowattributes display window attr))
         (class (xlib:xwindowattributes-class attr))
         (depth (xlib:xwindowattributes-depth attr))
         (visual (xlib:xwindowattributes-visual attr))
         (visual-class (xlib:visual-class visual)))
   (when debug
    (format t "screen:~a, " screen)
    (format t "class:~a, depth:~a, " class depth)
    (format t "visual-class:~a~%" visual-class))
   ;;
   (when debug (format t "XMatchVisualInfo..."))
   (let* ((visualinfo (xlib:make-xvisualinfo))
          (num-visuals (xlib:xmatchvisualinfo display screen depth
                                               visual-class visualinfo)))
    (unless (> num-visuals 0)
     (error "BIND-GL-TO-WINDOW: Could not get visual of class:~a, depth~a!"
	    visual-class depth))
    (when debug (format t "~a visuals found.~%" num-visuals))
    ;;
    (when debug (format t "glXCreateContext..."))
    (let ((glx-context (glxcreatecontext display visualinfo
					 XLIB:NULL GL_TRUE)))
     (when debug (format t "~%glXMakeCurrent..."))
     (glxmakecurrent display window glx-context))))
  (when debug (format t "~%Done.~%"))))

(defun create-gl-simple-window (display width height)
 (let* ((screen (xlib:xdefaultscreen display))
        (root (xlib:xrootwindow display screen))
        (black-pixel (xlib:xblackpixel display screen))
        (white-pixel (xlib:xwhitepixel display screen))
        (window (xlib:xcreatesimplewindow display root 0 0 width height
					  1 black-pixel white-pixel)))
  ;; Enable events
  (xlib:xselectinput display window
		     (+ xlib:structurenotifymask
			xlib:exposuremask
                        xlib:buttonpressmask))
  ;; Bind to GL
  (bind-gl-to-window display screen window)
  ;; Map window
  (xlib:xmapwindow display window)
  (xlib:xflush display)
  ;; Return window
  window))

(defun main ()
 ;;
 (let* ((display (xlib:xopendisplay ""))
	(window (create-gl-simple-window display 300 300)))
  ;; used by draw routine.
  (setq ball (make-ball))
  ;;
  (glcullface GL_BACK)
  (glenable GL_CULL_FACE)
  (gldisable GL_DITHER)
  (glshademodel GL_FLAT)
  ;;(glcolor3f 1 1 1)
  ;;
  ;; Initial state of animation.
  (event-loop display window)))
