(in-package :odcl)

(defregression (:string 1)
    "first-char match letter"
  (unless (equal (first-char "ZOTZ") #\Z)
    (error "first-char")))

(defregression (:string 2)
    "first-char on empty string"
  (unless (equal (first-char "") nil)
    (error "first-char")))

(defregression (:string 3)
    "last char matching return"
  (unless (equal (last-char "last-char") #\r)
    (error "last-char")))

(defregression (:string 4)
    "last-char on empty string"
  (unless (equal (last-char "") nil)
    (error "last-char")))

(defregression (:string 5)
    "two random strings shouldn't match"
  (when (equal (random-string) (random-string))
    (error "random-string")))

(defregression (:string 6)
    "ensure-string with symbol"
  (assert-string= (ensure-string :foo) ":FOO"))

(defregression (:string 7)
    "ensure-string with number"
  (assert-string= (ensure-string 10022444) "10022444"))

(defregression (:string 8)
    "ensure-string with string"
  (assert-string= (ensure-string "foobar") "foobar"))

(defregression (:string 8.1)
    "ensure-string with char"
  (assert-string= (ensure-string #\Space) " "))

(defregression (:string 8.2)
    "ensure-string with seq"
  (assert-string= (ensure-string '("foo" "bar"))
                  "(\"foo\" \"bar\")"))

(defregression (:string 9)
    "truncate-string"
  (assert-string= (string-truncate "foobar" 5) "fooba"))

(defregression (:string 10)
    "truncate-string where string under limit"
  (assert-string= (string-truncate "foobar" 10) "foobar"))

(defregression (:string 11)
    "truncate-string, limit 0"
  (assert-string= (string-truncate "foobar" 0) ""))

(defregression (:string 12)
    "string-pretty-truncate"
  ;; does it seem wrong that truncated string is longer than the original?
  (assert-string= (string-pretty-truncate "foobar" 5) "fooba..."))

(defregression (:string 13)
    "filter-list"
  (assert (equal (filter-list #'stringp (list "foo" 1 "bar"))
                (list "foo" "bar"))))

(defregression (:string 14)
    "split-string"
  (assert (equal (split-string #\Space "foo bar") (values "foo" "bar"))))

(defregression (:string 15)
    "split on space"
  (assert (equal (split "foo bar baz  blee" #\Space)
                (list "foo" "bar" "baz" "blee"))))

(defregression (:string 16)
    "split with escape"
  (assert (equal (split "foo\\ bar baz" #\Space :escape #\\)
                (list "foo\\ bar" "baz"))))

(defregression (:string 17)
    "split preserving empty"
  (assert (equal (split "foo bar baz  blee" #\Space :preserve-empty-strings t)
                (list "foo" "bar" "baz" "" "blee"))))

(defregression (:string 18)
    "split-counted"
  (assert (equal (split-counted "foo  bar baz blee" #\Space 3)
                (list "foo" "bar" "baz"))))

(defregression (:string 19)
    "string-join"
  (assert-string= (string-join (list "foo" "bar" "" "baz"))
                  "foo bar  baz"))

(defregression (:string 20)
    "string-join with delim"
  (assert-string= (string-join (list "foo" "bar" "" "baz") "xx")
                  "fooxxbarxxxxbaz"))

(defregression (:string 21)
    "char-replace"
  (assert-string= (char-replace #\a #\b "facamoca")
                  "fbcbmocb"))

(defregression (:string 22)
  "overlay"
  (assert-string= (overlay "1234567890" "456" 0)
                  "4564567890"))

(defregression (:string 23)
    "overlay off the end"
  (assert-string= (overlay "0987654321" "000" 8)
                  "09876543000"))

(defregression (:string 24)
    "char-count"
  (assert (eql (char-count #\f "baffle")
              2)))

(defregression (:string 25)
    "string-or-nil returning nil"
  (assert (not (string-or-nil "    ")))
  (assert (not (string-or-nil (list 'a 'b)))))

(defregression (:string 26)
    "string-or-nil"
  (assert-string= (string-or-nil " foo ")
                  "foo"))

(defregression (:string 27)
    "strcat"
  (assert-string= (strcat (list " " "foo" "bar"))
                  "foo bar"))

(defregression (:string 28)
    "strcat with delim"
  (assert-string= (strcat (list "" " bar") "")
                  " bar"))
