;;;;;;;;;;;;;;;;;;
;;; Some tests ;;;
;;;;;;;;;;;;;;;;;;

(in-package :cl-user)

(defun test (host port)
  (ssl:initialize-ssl-library)
  (let* (#+sbcl
	 (socket (connect-to-tcp-server host port))
	 (ssl-stream (make-instance 'ssl-internal:ssl-client-socket 
                                   :fd #+lispworks (comm:connect-to-tcp-server host port :errorp nil)
                                       #+cmu (ext:connect-to-inet-socket host port)
				       #+sbcl (sb-bsd-sockets:socket-file-descriptor socket)
                                   ))
                                       
        (request (format nil "GET / HTTP/1.0~%Host: ~a~%~%" host)))
    (loop for c across request
          do (ssl-internal:ssl-socket-write-byte (char-code c) ssl-stream))
    (ssl-internal:flush-output-buffer ssl-stream)

    (loop with result = (make-array 0 :element-type 'base-char :fill-pointer 0 :adjustable t)
          for byte = (ssl-internal:ssl-socket-read-byte ssl-stream)
          until (eq byte :eof)
          do (vector-push-extend (code-char byte) result 10)
          finally (return result))))

(defun test-streams (host port)
  (ssl:initialize-ssl-library)
  (let* (#+sbcl
	 (socket (connect-to-tcp-server
		  host port))
	 (fd #+lispworks (comm:connect-to-tcp-server host port :errorp nil)
            #+cmu (ext:connect-to-inet-socket host port)
	     #+sbcl (sb-bsd-sockets:socket-file-descriptor socket)
            ))
    (with-open-stream (s (ssl:make-ssl-client-stream fd :format :text))
      (format s "GET / HTTP/1.0~%Host: ~a~%~%" host)
      (force-output s)
      (let ((buf (make-array 1024 :element-type 'base-char)))
        (read-sequence buf s)
        buf))))

#+sbcl
(defun connect-to-tcp-server (host port)
  (let ((s (make-instance 'sb-bsd-sockets:inet-socket :type :stream :protocol :tcp)))
    (sb-bsd-sockets:socket-connect
     s (car (sb-bsd-sockets:host-ent-addresses
	     (sb-bsd-sockets:get-host-by-name host))) port)
    s))

(defun test-client (host port)
  (ssl:initialize-ssl-library)
  (let* (#+sbcl
	 (socket (connect-to-tcp-server
		  host port))
	 (fd #+lispworks (comm:connect-to-tcp-server host port :errorp nil)
	     #+cmu (ext:connect-to-inet-socket host port)
	     #+sbcl (sb-bsd-sockets:socket-file-descriptor socket)))
    (with-open-stream (s (ssl:make-ssl-client-stream fd :format :text))
      (format s "Hallo Welt")
      (force-output s)
      (sleep 5))))

#+lispworks
(defun test-server (local-port)
  (format t "Server starting...~%")(force-output t)
  (ssl:initialize-ssl-library)
  (let* ((server-socket (comm::create-tcp-socket-for-service local-port)
                        
                        ))
    (with-open-stream (s (ssl::make-ssl-server-stream (comm::accept-connection-to-socket server-socket)
                                                      :certificate "/home/jsc/ssl/server.pem"
                                                      :key "/home/jsc/ssl/server.pem"
                                                      :format :text))
      (format t "Accepted connection ~A...~%" s)(force-output t)
      (loop with result = (make-array 10 :element-type 'base-char)
            for n = (read-sequence result s)
            until (zerop n)
            finally (format t "~%~A read ~%" result)(force-output t)))))
