use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my $prog = '
@@@z
@@@K
@@@z
@@@K
@@@K
@@@z
@@@K
@@@z
@@
';

print "1..36\n";
my @stdin = ('@@', '@',
	     '@@@@',
	     '@@@@');
my @foo;
my @faa;

compile Language::INTERCAL 'prog', $prog;
@foo = ();
@faa = @stdin;
eval { prog(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 4 ? "" : "not ", "ok 2\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 3\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 4\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 5\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 6\n");

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo = ();
@faa = @stdin;
eval { prog_o(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 7\n";
print @foo == 4 ? "" : "not ", "ok 8\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 9\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 10\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 11\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 12\n");

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo = ();
@faa = @stdin;
eval { prog_q(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 4 ? "" : "not ", "ok 14\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 15\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 16\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 17\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 18\n");

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo = ();
@faa = @stdin;
eval { prog_p(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 19\n";
print @foo == 4 ? "" : "not ", "ok 20\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 21\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 22\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 23\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 24\n");

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo = ();
@faa = @stdin;
eval { prog_qp(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 25\n";
print @foo == 4 ? "" : "not ", "ok 26\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 27\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 28\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 29\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 30\n");

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
@faa = @stdin;
_run_db(prog_d(\&faa, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 31\n";
print @foo == 4 ? "" : "not ", "ok 32\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 33\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 34\n");
print (shift(@foo) eq "xiiCCCXLV\n" ? "" : "not ", "ok 35\n");
print (shift(@foo) eq "lxviiDCCCXC\n" ? "" : "not ", "ok 36\n");

sub foo {
    push @foo, join('', @_);
}

sub faa {
    shift @faa;
}

