#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

GtkWidget *entry[1];
GtkWidget *entry_gb[1];
extern gchar gtk_font[STR_BUFFER_SIZE];
extern gchar gtk_font_gb[STR_BUFFER_SIZE];

void action(GtkWidget *pre_button, gpointer data)
{
		strcpy(gtk_font,gtk_entry_get_text(GTK_ENTRY(entry[0])));
		save_gtk_fonts(gtk_font,0);
}

void action_gb(GtkWidget *pre_button, gpointer data)
{
		strcpy(gtk_font,gtk_entry_get_text(GTK_ENTRY(entry_gb[0])));
		save_gtk_fonts(gtk_font_gb,1);
}

void process_3(GtkWidget *pre_button, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *hbox;

	win = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(win),10);
	gtk_window_set_title(GTK_WINDOW(win),_("Setting GTK+ fonts"));

	hbox = make_fonts_opt(_("Set GTK+ fonts (Simplified Chinese) to: "),entry_gb,0,gtk_font_gb,win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),hbox,FALSE,FALSE,1);

	button = gtk_button_new_with_label(_("Next"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(action_gb),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(set_locale_opt),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	gtk_widget_grab_default(button);

	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_grab_add(win);
	gtk_widget_show_all(win);
}


void process_2(GtkWidget *pre_button, gpointer data)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *hbox;

	win = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(win),10);
	gtk_window_set_title(GTK_WINDOW(win),_("Setting GTK+ fonts"));

	hbox = make_fonts_opt(_("Set GTK+ fonts (Traditional Chinese) to: "),entry,0,gtk_font,win);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),hbox,FALSE,FALSE,1);

	button = gtk_button_new_with_label(_("Next"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(action),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(process_3),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	gtk_widget_grab_default(button);

	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_grab_add(win);
	gtk_widget_show_all(win);
}

void init_process(void)
{
	GtkWidget *win;
	GtkWidget *label;
	GtkWidget *button;

	win = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(win),_("Welcome to CPanel"));
	gtk_container_set_border_width(GTK_CONTAINER(win),10);
	gtk_signal_connect(GTK_OBJECT(win),"destroy",
		GTK_SIGNAL_FUNC(close_win),win);

	label = gtk_label_new(_("Welcome! CPanel will now help you to configure your system.\nYou'll be asked to setup the follow 3 things:\n\n1. GTK+ fonts for Triditional Chinese\n2. GTK+ fonts for Simplified Chinese\n3. Locales & Window Manager\n\nTo activate all the settings, please restart X\nPlease click the Next button..."));

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,0);

	button = gtk_button_new_with_label(_("Next"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
		GTK_SIGNAL_FUNC(process_2),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
		GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_widget_grab_default(button);
		
	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
		GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_grab_add(win);
	gtk_widget_show_all(win);
}
