/*****************************************************************
 *
 *   search_file.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include <sys/stat.h>

/* Programs & files */
gboolean is_zh_TW_linked;
gboolean is_zh_CN_linked;
gboolean is_crxvt;
gboolean is_crxvt_gb;
gboolean is_xcin;
gboolean is_xcin23;
gboolean is_xacv;
gboolean is_pydict;
gboolean is_chdrv;
gboolean is_xcingb;
gboolean is_chinput;
gboolean is_bsmi00lp;
gboolean is_bkai00mp;
gboolean is_gbsn00lp;
gboolean is_gkai00mp;

/* Window Managers */
gboolean wmaker;
gboolean enlightenment;
gboolean afterstep;
gboolean blackbox;
gboolean icewm;
gboolean sawmill;
gboolean gnome_session;
gboolean kde;
gboolean kde2;

void search_program(void)
{
	is_zh_TW_linked = isfile("/usr/lib/locale/zh_TW/LC_ADDRESS");
	is_zh_CN_linked = isfile("/usr/lib/locale/zh_CN/LC_ADDRESS");
	is_crxvt = (isfile("/usr/X11R6/bin/crxvt")||isfile("/usr/bin/crxvt"));
	is_crxvt_gb = (isfile("/usr/X11R6/bin/crxvt-gb")||isfile("/usr/bin/crxvt-gb"));
	is_xcin = (isfile("/usr/bin/xcin")||isfile("/usr/X11R6/bin/xcin"));
	is_xcin23 = (isfile("/usr/bin/xcin2.3")||isfile("/usr/bin/xcin2.3"));
	is_xacv = isfile("/usr/bin/xa");
	is_pydict = (isfile("/usr/X11R6/bin/pydict")||isfile("/usr/bin/pydict"));
	is_chdrv = isfile("/usr/bin/chdrv");
	is_xcingb = (isfile("/usr/X11R6/bin/xcingb")||isfile("/usr/bin/xcingb"));
	is_chinput = (isfile("/usr/bin/chinput"));
	is_bsmi00lp = (isfile("/usr/X11R6/lib/X11/fonts/TrueType/bsmi00lp.ttf"));
	is_bkai00mp = (isfile("/usr/X11R6/lib/X11/fonts/TrueType/bkai00mp.ttf"));
	is_gbsn00lp = (isfile("/usr/X11R6/lib/X11/fonts/TrueType/gbsn00lp.ttf"));
	is_gkai00mp = (isfile("/usr/X11R6/lib/X11/fonts/TrueType/gkai00mp.ttf"));
}

void search_file(void)
{
	wmaker = (isfile("/usr/X11R6/bin/wmaker") || isfile("/usr/bin/wmaker"));
	enlightenment = (isfile("/usr/X11R6/bin/enlightenment")||isfile("/usr/bin/enlightenment"));
	afterstep = (isfile("/usr/X11R6/bin/afterstep")||isfile("/usr/bin/afterstep"));
	blackbox = (isfile("/usr/bin/blackbox")||isfile("/usr/X11R6/bin/blackbox"));
	icewm = (isfile("/usr/X11R6/bin/icewm")||isfile("/usr/bin/icewm"));
	sawmill = (isfile("/usr/X11R6/bin/sawmill")||isfile("/usr/bin/sawmill"));
	gnome_session = (isfile("/usr/X11R6/bin/gnome-session")||isfile("/usr/bin/gnome-session"));
	kde = (isfile("/usr/X11R6/bin/kde")|| isfile("/usr/bin/kde"));
	kde2 = (isfile("/usr/X11R6/bin/kde2")|| isfile("/usr/bin/kde2"));
}

gboolean isfile(char *s)
{
   struct stat st;

   if ((!s)||(!*s)) return 0;
	if (stat(s,&st)<0) return 0;
		if (S_ISREG(st.st_mode)) return 1;
   return 0;
}
