/*  
    solarisAudio.c:

    Copyright (C) 1998 John ffitch, ????

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/audioio.h>
#include "text.h"

/*  #include "solarisAudio.h" */
audio_info_t* audioGetDevInfo(int);
void audioSetDevInfo(int, audio_info_t*);
void audioPrintPlayInfo(int);

void audioDie(int fd, char *message)
{
    fprintf(stderr, Str(X_245,"Die: %s\n"), message);
    perror("errno");
    longjmp(cglob.exitjmp,1);
}

void audioPausePlay(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    ai->play.pause = 1;
    audioSetDevInfo(fd, ai);
}

void audioResumePlay(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    ai->play.pause = 0;
    audioSetDevInfo(fd, ai);
}

void audioPauseRecord(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    ai->record.pause = 1;
    audioSetDevInfo(fd, ai);
}

void audioResumeRecord(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    ai->record.pause = 0;
    audioSetDevInfo(fd, ai);
}


int audioGetPlayDevice(char *devName)
{
    int fd;
    printf(Str(X_498,"Trying to get solaris audio device..."));
    fd = open(devName, O_NONBLOCK || O_RDONLY);
    if (fd == -1)
      audioDie(fd, Str(X_228,"Could not open /dev/audio for reading"));
    printf(Str(X_174,"...done!\n"));
    return fd;
}

int audioGetRecordDevice(char *devName)
{
    int fd;
    fd = open(devName, O_NONBLOCK || O_WRONLY);
    if (fd == -1)
      audioDie(fd, Str(X_229,"Could not open /dev/audio for writing"));
    return fd;
}

audio_info_t* audioGetDevInfo(int fd)
{
    audio_info_t *ai;

    ai = (audio_info_t*)malloc(sizeof(audio_info_t));
    if (ioctl(fd, AUDIO_GETINFO, ai) != 0)
      audioDie(fd, Str(X_227,"Could not get audio information"));
    return ai;
}

void audioSetDevInfo(int fd, audio_info_t* ai)
{
    if (ioctl(fd, AUDIO_SETINFO, ai) != 0)
      audioDie(fd, Str(X_230,"Could not set audio information"));
}

audio_prinfo_t audioGetPlayInfo(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    return ai->play;
}

audio_prinfo_t audioGetRecordInfo(int fd)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);
    return ai->record;
}

void audioSetPlayInfo(int fd,
                      uint_t sampleRate,
                      uint_t nOfChannels,
                      uint_t precision,
                      uint_t bufferSize)
{
    audio_info_t *ai;
    ai = audioGetDevInfo(fd);

    ai->play.sample_rate = sampleRate;
    ai->play.channels = nOfChannels;
    ai->play.precision = precision;
    ai->play.encoding = AUDIO_ENCODING_LINEAR;
    ai->play.buffer_size = bufferSize;

    audioSetDevInfo(fd, ai);
    audioPrintPlayInfo(fd);
}

void audioSetRecordInfo(int fd,
                        uint_t sampleRate,
                        uint_t nOfChannels,
                        uint_t precision,
                        uint_t bufferSize)
{
    audio_info_t *ai;

    ai = audioGetDevInfo(fd);

    ai->record.sample_rate = sampleRate;
    ai->record.channels = nOfChannels;
    ai->record.precision = precision;
    ai->record.encoding = AUDIO_ENCODING_LINEAR;
    ai->record.buffer_size = bufferSize;

    audioSetDevInfo(fd, ai);
}

void audioPrintDevInfo(int fd)
{
    int ir;
    audio_device_t *ad;

    ad = (audio_device_t*)malloc(sizeof(audio_device_t));
    ir = ioctl(fd, AUDIO_GETDEV, ad);
    printf(Str(X_946,"ioctl: %d\n"), ir);

    printf(Str(X_351,"Name   : %s\n"), ad->name);
    printf(Str(X_523,"Version: %s\n"), ad->version);
    printf(Str(X_225,"Config : %s\n"), ad->config);
}

void audioPrintPlayInfo(int fd)
{
    audio_prinfo_t playInfo;

    playInfo = audioGetPlayInfo(fd);;
    printf(Str(X_404,"PLAY........................................\n"));
    /* The following values describe the audio data encoding */
    printf(Str(X_1174,"sample_rate:%d\n"), playInfo.sample_rate); /* samples per second */
    printf(Str(X_659,"channels:%d\n"),
           playInfo.channels);  /* number of interleaved channels */
    printf(Str(X_1135,"precision:%d\n"),
           playInfo.precision); /* number of bits per sample */
    printf(Str(X_711,"encoding:%d\n"), playInfo.encoding);      /* data encoding method */
    /* The following values control audio device configuration */
    printf(Str(X_790,"gain:%d\n"), playInfo.gain);          /* volume level */
    printf(Str(X_1134,"port:%d\n"), playInfo.port);          /* selected I/O port */
    printf(Str(X_621,"buffer_size:%d\n"), playInfo.buffer_size);   /* I/O buffer size */

    /* The following values describe the current device state */
    printf(Str(X_1175,"samples:%d\n"), playInfo.samples);/* number of samples converted */
    printf(Str(X_721,"eof:%d\n"), playInfo.eof); /* End Of File counter (play only) */
    printf(Str(X_1120,"pause:%d\n"),
           playInfo.pause); /* non-zero if paused, zero to resume */
    printf(Str(X_746,"error:%d\n"), playInfo.error); /* non-zero if overflow/underflow */
    printf(Str(X_1376,"waiting:%d\n"),
           playInfo.waiting); /* non-zero if a process wants access */
    printf(Str(X_615,"balance:%d\n"), playInfo.balance); /* stereo channel balance */

  /* The following values are read-only device state flags */
    printf(Str(X_1092,"open:%d\n"), playInfo.open);/* non-zero if open access granted */
    printf(Str(X_583,"active:%d\n"), playInfo.active);        /* non-zero if I/O active */
    printf(Str(X_610,"avail_ports:%d\n"), playInfo.avail_ports); /* available I/O ports */
}

void audioPrintRecordInfo(int fd)
{
    audio_prinfo_t recordInfo;

    recordInfo = audioGetRecordInfo(fd);

    printf(Str(X_434,"RECORD........................................\n"));
    /* The following values describe the audio data encoding */
    printf(Str(X_1174,"sample_rate:%d\n"),
           recordInfo.sample_rate);   /* samples per second */
    printf(Str(X_659,"channels:%d\n"),
           recordInfo.channels);      /* number of interleaved channels */
    printf(Str(X_1135,"precision:%d\n"),
           recordInfo.precision);     /* number of bits per sample */
    printf(Str(X_711,"encoding:%d\n"),
           recordInfo.encoding);      /* data encoding method */
    /* The following values control audio device configuration */
    printf(Str(X_790,"gain:%d\n"), recordInfo.gain);          /* volume level */
    printf(Str(X_1134,"port:%d\n"), recordInfo.port);          /* selected I/O port */
    printf(Str(X_621,"buffer_size:%d\n"), recordInfo.buffer_size);   /* I/O buffer size */

    /* The following values describe the current device state */
    printf(Str(X_1175,"samples:%d\n"), recordInfo.samples);/* number of samples converted */
    printf(Str(X_721,"eof:%d\n"), recordInfo.eof);    /* End Of File counter (play only) */
    printf(Str(X_1120,"pause:%d\n"),
           recordInfo.pause); /* non-zero if paused, zero to resume */
    printf(Str(X_746,"error:%d\n"), recordInfo.error); /* non-zero if overflow/underflow */
    printf(Str(X_1376,"waiting:%d\n"),
           recordInfo.waiting); /* non-zero if a process wants access */
    printf(Str(X_615,"balance:%d\n"), recordInfo.balance);      /* stereo channel balance */

    /* The following values are read-only device state flags */
    printf(Str(X_1092,"open:%d\n"), recordInfo.open);/* non-zero if open access granted */
    printf(Str(X_583,"active:%d\n"), recordInfo.active); /* non-zero if I/O active */
    printf(Str(X_610,"avail_ports:%d\n"),
           recordInfo.avail_ports);   /* available I/O ports */
}
