/***************************************************************************
                          bilddatei.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include <cstdio>

#include <qimage.h>
#include <qpainter.h>

#include "cuyointl.h"
#include "bilddatei.h"
#include "leveldaten.h"
#include "fehler.h"
#include "pfaditerator.h"
#include "inkompatibel.h"

#include "xpmladen.h"


Bilddatei::Bilddatei() {
}
Bilddatei::~Bilddatei() {
}


/** Ldt das Bild mit dem angegebenen Namen. Sucht in verschiedenen
    Pfaden danach.Throwt ggf. */
void Bilddatei::laden(__String name) {
  QImage im;

  __String s;
  s.sprintf("pics/%s", name.data());

  /* Bild in verschiedenen Pfaden suchen... (Der Pfaditerator throwt ggf.)
     ladXPM kann auch throwen: Wenn eine .xpm.gz-Datei existiert, die
     von meiner Routine nicht geladen werden kann. */
  //for (PfadIterator pi(s); !bild.load(pi.pfad()); ++pi);
  for (PfadIterator pi(s); !ladXPM(im, pi.pfad()); ++pi);


  mBild.convertFromImage(im, __ColorOnly);
}


/** malt das k-te Viertel vom n-te Bildchen an xx,yy. Oder evtl. das
    ganze Bildchen */
void Bilddatei::malBildchen(QPainter & p, int xx, int yy,
			    int n, int k /*= viertel_alle*/) const {

  /* bitBlt geht ein kleines bisschen schneller als drawPixmap... */

  QPoint pos = bildchenPos(n);
  if (k == viertel_alle)
    bitBlt(p.device(), QPoint(xx, yy), &mBild, QRect(pos, QSize(gric, gric)));
    //p.drawPixmap(QPoint(xx, yy), mBild, QRect(pos, QSize(gric, gric)));
  else {
    /* Richtiges Viertel in Datei whlen */
    if (k & viertel_qr) pos += QPoint(gric/2, 0);
    if (k & viertel_qu) pos += QPoint(0, gric/2);
    /* Richtiges Ziel-Viertel whlen */
    if (k & viertel_zr) xx += gric/2;
    if (k & viertel_zu) yy += gric/2;
    bitBlt(p.device(), QPoint(xx, yy), &mBild, QRect(pos, QSize(gric/2, gric/2)));
    //p.drawPixmap(QPoint(xx, yy), mBild, QRect(pos, QSize(gric/2, gric/2)));
  }
}


/** liefert die Pos des Bildchens Nr. n */
QPoint Bilddatei::bildchenPos(int n) const {

  if (n >= anzBildchen())
    throw Fehler(_("Pixmap too small for Icon %d"), n);

  int bpr = mBild.width() / gric; /* Bildchen pro Reihe... */
  int y = n / bpr;
	
  return QPoint(gric * (n % bpr), gric * y);
}

/** liefert zurck, wie viele Bildchen in dieser Datei sind. */
int Bilddatei::anzBildchen() const{
  return (mBild.width() / gric) * (mBild.height() / gric);
}

/** liefert die Gesamthoehe in Pixeln zurck */
int Bilddatei::getBreite() const {
  return mBild.width();
}

/** liefert die Gesamthoehe in Pixeln zurck */
int Bilddatei::getHoehe() const {
  return mBild.height();
}

/** malt das gesamte Bild */
void Bilddatei::malBild(QPainter & p, int xx, int yy) const {
  p.drawPixmap(QPoint(xx, yy), mBild);
}


/** Speziell fr die Debug-Output-Ziffern: Malt Ziffer n. */
void Bilddatei::malZiffer(QPainter & p, int xx, int yy, int n) const {
  p.drawPixmap(QPoint(xx, yy), mBild, QRect(n * gric/4, 0, gric/4, gric/2));
}
