/***************************************************************************
                          pfaditerator.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inkompatibel.h"

#include <cstdlib>
#include <cstdio>
#include <cstring>

#include "fehler.h"
#include "pfaditerator.h"
#include "cuyointl.h"
#include "global.h"


#define pfad_default 0
#define pfad_uebergeben 1
#define pfad_aktueller 2
#define pfad_uninstalliert 3
#define pfad_installation 4
#define anz_pfade 5


int PfadIterator::gDefaultPfad = -1;


PfadIterator::PfadIterator(__String dat, bool setzDefault /*= false*/):
  mPos(-1), mDatei(dat), mSetzDefault(setzDefault),
  mIstAbsolut(dat[0] == '/')
{
  /* Damit wir hier nicht auch nochmal die ganzen berspringungen testen
     mssen, die in operator++() stehen, setzen wir mPos als erstes auf
     -1 und fhren dann gleich ein ++ aus. */
  ++(*this);
}
PfadIterator::~PfadIterator() {
  /** Soll der default-Pfad gesetzt werden? */
  if (mSetzDefault) {

    if (mIstAbsolut) {
      /* Gepfuscht: Absolute Pfade knnen nicht als default-Pfad gesetzt
         werden. Einzige Ausnahme: Es handelt sich um den bergebenen Pfad. */
      if (nimmPfad(gLevelDatei) == nimmPfad(mDatei)) {
	/* Uff, Glck gehabt. */
        gDefaultPfad = pfad_uebergeben;
      } else
        throw Fehler(_("Internal error: got confused with all those paths I have to deal with."));
    } else {
      /* Alles normal. Kein absoluter Pfad. */
      if (mPos != pfad_default && mPos < anz_pfade)
	gDefaultPfad = mPos;
    }
  }
}


/** Nchster Pfad */
PfadIterator & PfadIterator::operator++() {
  mPos++;
  
  if (mIstAbsolut) {
    /* Bei absolutem Pfad ist nicht viel zu tun; ++ sollte nur
       einmal vom Constructor aufgerufen werden; wenn es nochmal
       aufgerufen wird, bedeutet das, dass die Datei nicht existiert.
       Gut, dass mPos die Aufrufe zhlt... */
       
    if (mPos > 0) {
      /* Dann wird weiter unten die Fehlermeldung ausgegeben. */
      mPos = anz_pfade;
    }
  
  } else {

    /* Wenn es noch keinen Default-Pfad gibt, dann berspringen */
    if (mPos == pfad_default && gDefaultPfad == -1)
      mPos++;

    /* Wenn keine ld-Datei an cuyo bergeben wurde, dann haben wir
       da auch keinen Pfad, in dem wir suchen knen. Also in dem
       Fall berspringen. */
    if (mPos == pfad_uebergeben && !gDateiUebergeben)
      mPos++;

    /* Nicht noch ein zweites Mal im Default-Pfad suchen */
    if (mPos == gDefaultPfad) mPos++;
  } // Ende von: kein absoluter Pfad

  if (mPos >= anz_pfade)
    throw Fehler(_("Could not find \"%s\"."), mDatei.data());
  return *this;
}

	
/** Aktueller Pfad */
__String PfadIterator::pfad() const {

  /* Wenn absoluter Pfad angegeben, dann den auch zurckliefern. */
  if (mIstAbsolut)
    return mDatei.data();

  /* Als erstes im default-Pfad nachschauen */
  int n = mPos;
  if (n == pfad_default) n = gDefaultPfad;

  __String r;
  switch (n) {
    case pfad_uebergeben:
      CASSERT(gDateiUebergeben);
      /* gLevelDatei enthlt Pfad und Name einer ld-Datei. Wir nehmen
	 uns davon den Pfad: */
      r.sprintf("%s%s", nimmPfad(gLevelDatei).data(), mDatei.data());
      break;

    case pfad_installation:
      /* PKGDATADIR wird mit -D bergeben. (Siehe src/Makefile.am)
	 Unter WIN32 wird PKGDATADIR als "cuyo-x.xx\\data" definiert,
	 falls es nicht bergeben wurde. */
      r.sprintf("%s/%s", PKGDATADIR, mDatei.data());
      break;

    case pfad_uninstalliert:
      r.sprintf("%s../data/%s", gCuyoPfad.data(), mDatei.data());
      break;

    case pfad_aktueller:
      r.sprintf("./%s", mDatei.data());
      break;

    default:
      CASSERT(false);
  }
  // Debug-Ausgabe:
  // printf("%s\n", r.data());fflush(stdout);
  return r;
}



/** Vergisst, welcher Pfad als default gesetzt wurde */
void PfadIterator::loescheDefault() {
  gDefaultPfad = -1;
}



