<?php
/**
 * Class to handle HTML page template
 * This class is derived by themes
 *
 * daCode http://www.dacode.org/
 * src/phplib/html.php3
 * $Id: html.php3,v 1.149.2.5 2002/08/17 19:37:25 pterjan Exp $
 */
class Html {
	/**
	 * Parses a template
	 * Read a template file, replace all <!-- daCode: ... -->
	 * expressions by PHP expressions, displays output text and
	 * returns this text
	 * Called in every access script
	 *@param string name of the template
	 *@return string the template, with substitutions made.
	 *@access public
	 */
	Function parsetemplate($template) {
		global $config,$HTTP_GET_VARS,$HTTP_POST_VARS;
		global $session, $user;
		//   All global variables used in template files must
		//   be declared below
		//global $admin,$backends,$board,$cache,$comments,$db,$fortune,
		//  $hits,$html,$message,$news,$nospider,$poll,$redirects,
		//  $search,$session,$sidebox,$user,$utils,$webcam,$tips,$cal;
		//global $section,$topic,$news_id,$date,$view,$com_id,$title,$a,$table,
		//  $pageday,$pagemonth,$pageyear, $res_type;
		//global $HTTP_REFERER,$text,$nobanner;
		//global $submitComment;

		$file = $config->libdir.'themes/'.
			$config->theme_name.'/'.$template;
		if (! file_exists($file)) {
			//   Look into third-party themes
			$file = $config->libdir.'themes/'.$config->theme_subdir.
				$config->theme_name.'/'.$template;
		}
		if (! file_exists($file)) {
			//  Load default templates
			$theme = $config->dft_prefs['theme'];
			$file = $config->libdir.'themes/'.
				$config->listofthemes[$theme].'/'.$template;
			if (! file_exists($file)) {
				return;
			}
		}

		$output = "";
		$input_lines = file($file);

		$tmp_lines = implode ("",$input_lines);

		$user_boxes_config = 0;
		//preg_match("/<!-- daCode: USERBOX -->(.*)<!-- daCode:
		//					\/USERBOX -->/is",$tmp_lines,$match);
		if ($session->has_user_boxes) {
			$user_boxes_config = 1;
		} else {
			$user_boxes_config = 0;
		}

		$tmp_ok=0;
		$basic_tmp=array();
		while ($t=each($input_lines)) {
			if (ereg('^[ 	]*#', $t[1])) {
				continue;
			}
			if (ereg('^(.*)<!-- daCode: USERBOX -->(.*)$',$t[1]) &&
				$user_boxes_config) {
				$tmp_ok=1;
				continue;
			} elseif (ereg('^(.*)<!-- daCode: USERBOX -->(.*)$',$t[1]) &&
				!$user_boxes_config) {
				$tmp_ok=2;
				continue;
			}

			/*
			 * If user has chosen user boxes in his prefs
			 */
			if (ereg('^(.*)<!-- daCode: /USERBOX -->(.*)$',$t[1]) &&
				$tmp_ok==1) {

				// Don't remove this !
				reset($basic_tmp);
				$a = "";
				while($d = each($basic_tmp)) {
					$a .= $d[1][2];
					if(next($basic_tmp)) {
						$a .= ":";
					}
				}

				$output .= "<!-- USERBOXES:$a -->\n";

				reset($user->user_boxes);
				/*
				 * This should probably be optimised
				 */
				while($e=each($user->user_boxes)) {
					reset($config->user_boxes);
					while($cur = current($config->user_boxes)) {
						if (key($config->user_boxes) == $e[1]) {
							$to_eval = $cur['function'];
							$this->utils->debug("Html:".__LINE__." parsetemplate: ".
								"eval (userboxes): ".$to_eval."\n");

							//Fuck the vars scope in PHP. Now we shall detect
							//vars out of current scope and declare them global...
							$matches = array();
							preg_match_all('/\$(\w+)\b/', $to_eval, $matches, PREG_SET_ORDER);

							//Now we run through the matches to determine which vars to
							//copy or access through GLOBALS
							while ( list(,$setOfMatches) = each($matches) ) {
								if (!isset($$setOfMatches[1])) {
									global $$setOfMatches[1];
								}
							}

							eval("\$tempo = $to_eval;");
							echo $tempo;
							next($config->user_boxes);
							break(1);
						}
						next($config->user_boxes);
					}
				}

				// Don't remove this !
				$output .= "<!-- /USERBOXES -->\n";

				$tmp_ok=0;
				continue;
			/*
			 * He didn't so we use default one.
			 */
			} elseif (ereg('^(.*)<!-- daCode: /USERBOX -->(.*)$',$t[1]) &&
				$tmp_ok==2) {

				// Don't remove this !
				reset($basic_tmp);
				$a = "";
				while($d = each($basic_tmp)) {
					$a .= $d[1][2];
					if(next($basic_tmp)) {
						$a .= ":";
					}
				}

				$output .= "<!-- USERBOXES:$a -->\n";

				/*
				 * There is default box in template
				 */
				if (count($basic_tmp) > 0) {
					reset($basic_tmp);
					while ($d = each($basic_tmp)) {
						$to_eval = $config->user_boxes[$d[1][2]]['function'];
						if (!empty($to_eval)) {
							$this->utils->debug("Html:".__LINE__." parsetemplate: ".
								"eval (defboxestmpl): ".$to_eval."\n");

							//Fuck the vars scope in PHP. Now we shall detect
							//vars out of current scope and declare them global...
							$matches = array();
							preg_match_all('/\$(\w+)\b/', $to_eval, $matches, PREG_SET_ORDER);

							//Now we run through the matches to determine which vars to
							//copy or access through GLOBALS
							while ( list(,$setOfMatches) = each($matches) ) {
								if (!isset($$setOfMatches[1])) {
									global $$setOfMatches[1];
								}
							}
							eval("\$eval = $to_eval;");
							echo $d[1][1] . $eval . $d[1][3];
							$output .= $d[1][1] . $eval . $d[1][3];
						}
					}

				/*
				 * There isn't so we use default from config file
				 */
				} elseif (gettype($config->default_user_boxes) == "array") {
					reset($config->default_user_boxes);
					while ($d = each($config->default_user_boxes)) {
						$to_eval = $config->user_boxes[$d[1]]['function'];
						$this->utils->debug("Html:".__LINE__." parsetemplate: ".
							"eval (defboxes_conf): ".$to_eval."\n");

							//Fuck the vars scope in PHP. Now we shall detect
							//vars out of current scope and declare them global...
							$matches = array();
							preg_match_all('/\$(\w+)\b/', $to_eval, $matches, PREG_SET_ORDER);

							//Now we run through the matches to determine which vars to
							//copy or access through GLOBALS
							while ( list(,$setOfMatches) = each($matches) ) {
								if (!isset($$setOfMatches[1])) {
									global $$setOfMatches[1];
								}
							}

						eval("\$eval = $to_eval;");
						echo $eval;
						$output .= $eval;
					}

				}

				// Don't remove this !
				$output .= "<!-- /USERBOXES -->\n";

				$tmp_ok=0;
				continue;
			}

			if (ereg('^(.*)<!-- daCode: boxes:(.*) -->(.*)$', $t[1], $res) &&
				$tmp_ok==0) {
				$to_eval = $config->user_boxes[$res[2]]['function'];
				$this->utils->debug("Html:".__LINE__." parsetemplate: eval (boxes): ".
					$res[2]."\n");

							//Fuck the vars scope in PHP. Now we shall detect
							//vars out of current scope and declare them global...
							$matches = array();
							preg_match_all('/\$(\w+)\b/', $to_eval, $matches, PREG_SET_ORDER);

							//Now we run through the matches to determine which vars to
							//copy or access through GLOBALS
							while ( list(,$setOfMatches) = each($matches) ) {
								if (!isset($$setOfMatches[1])) {
									global $$setOfMatches[1];
								}
							}

				eval("\$eval = $to_eval;");
				$out = $res[1].$eval.$res[3];
				echo $out;
				$output .= $out;
				continue;
			} elseif (ereg('^(.*)<!-- daCode:(.*) -->(.*)$', $t[1], $res) &&
				$tmp_ok==0) {
				$this->utils->debug("Html:".__LINE__." parsetemplate: eval (.*): ".$res[2].
					(isset($res_type)?" (res_type = ".$res_type:'').
					(isset($news_id)?"; news_id = ".$news_id:'').")\n");


				//Fuck the vars scope in PHP. Now we shall detect
				//vars out of current scope and declare them global...
				$matches = array();
				preg_match_all('/\$(\w+)\b/', $res[2], $matches, PREG_SET_ORDER);

				//Now we run through the matches to determine which vars to
				//copy or access through GLOBALS
				while ( list(,$setOfMatches) = each($matches) ) { //Yes arrays suck...
					if (!isset($$setOfMatches[1])) {
						global $$setOfMatches[1];
					}
				}

				eval("\$eval = $res[2];");
				$out = $res[1].$eval.$res[3];
				echo $out;
				$output .= $out;
				continue;
			} elseif (ereg('^(.*)<!-- daCode: boxes:(.*) -->(.*)$', $t[1], $res) &&
				($tmp_ok==1 || $tmp_ok==2)) {
				$res[0] = "";
				$basic_tmp[] = $res;
				continue;
			} else {
				echo $t[1];
				$output .= $t[1];
				continue;
			}
		}

		return $output;
	}

	/**
	 * The 'posted by' header in a news box
	 *@param array a row of news table
	 *@param integer if 1, displays Proposed instead of Approved
	 *@return string the HTML for the header.
	 *@access private
	 */
	Function newsbox_posted_by($row,$preview) {
		global $config;

		$name = $row['name'];
		$contact = htmlspecialchars($row['contact']);
		$timestamp = (isset($row['timestamp'])?$row['timestamp']:'');

		$out = lecho("Posted by")." ";

		if (eregi("^http://", $contact) || eregi("^ftp://", $contact)) {
			$out .= $this->redirect->make($name,$contact,"");
		} elseif (preg_match('/^[\w_\-\.]+@[\w_\-\.]+$/',$contact)) {
			$out .= $this->redirect->make($name,"mailto:$contact","");
		} else {
			$out .= $name;
		}

		if ($preview=='1') {
			$out .= ". " . lecho("Proposed on") . " " .
			$this->utils->stamp2date($timestamp,"long",2);
		} else {
			$out .= ". " . lecho("Approved on") . " " .
			$this->utils->stamp2date($timestamp,"long");
		}

		if (isset ($row['id'])) {
			$out .= ' <a href="'.$config->basehref.
				'news/view_modero.'.$config->php.'?news_id='.$row['id'].
				'" onclick="window.open(\''.$config->basehref.
				'news/view_modero.'.$config->php.'?news_id='.$row['id']."','M',".
				"'toolbar=no,location=no,directories=no,status=no,".
				'alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,'.
				"resizable=no,width=100,height=50'); return false\" ".
				"onmouseout=\"javascript: window.status=''; return true;\" ".
				"onmouseover=\"javascript: window.status='".
				lecho("Look at the moderators")."'; return true;\">[M]</a> ";
		}

		return $out;
	}

	/**
	 * Creates the html for news links
	 *@param array a row of news table
	 *@param integer if 1, displays Proposed instead of Approved
	 *@return stringthe HTML for the links.
	 *@access private
	 */
	Function newsbox_show_links($row,$preview) {
		global $config;

		$out = '';
		if ($preview) {
			$out .= "<ul>\n";
			for ($k=0;$k<$config->numberoflinks;$k++) {
				if (empty($row['url'.$k])) {
					break;
				}
				$lank = ereg_replace('^[0-9]+:', '', $row['lan'.$k]);
				$out .= '<li><img src="'.
					$this->session->imgurl($lank).
					'" alt="['.$lank.']" /> - ';
				$out .= '<a href="'.$row['url'.$k].'">'.$row['nom'.$k].'</a></li>';
			}
			$out .= "</ul>\n";
		} elseif (gettype($row['links']) == "array" && count($row['links']) > 0) {
			$out .= "<ul>\n";
			reset($row['links']);
			while($urls = current($row['links'])) {
				$out .= '<li><img src="'.
					$this->session->imgurl($urls['lang']).
					'" alt="['.$urls['lang'].'] " /> - ';
				$out .= $this->hits->make($urls) . '</li>';
				next($row['links']);
			}
			$out .= "</ul>\n";
		} else {
			$out .= '&nbsp;';
		}
		return $out;
	}

	/**
	 * Computes the file size in the correct unit (Mo if size > 1 Mo, Ko otherwise)
	 *@param integer the file size
	 *@return string file size converted, with prefix (Mega- or Kilo-) appended.
	 *@access private
	 */
	Function size_unit($file_size) {
		if ($file_size >= 1048576) {
			$file_size = round($file_size / 1048576 * 100) / 100 . 'Mega-';
		} elseif ($file_size >= 1024) {
			$file_size = round($file_size / 1024 * 100) / 100 . 'Kilo-';
		}
		return $file_size;
	}

	/**
	 * Creates links to attachements
	 *@param array a row in the attachement table.
	 *@return string the HTML code.
	 *@access private
	 */
	Function newsbox_show_attachments($row) {
		global $config;

		$out = '';
		if (isset($row['attach']) &&
				gettype($row['attach']) == "array") {
			reset($row['attach']);
			while ($attach = current($row['attach'])) {
				// Test to check if content-type.png exists
				// if so use it, else use default icon
				$img = str_replace("/", "-",
					$attach['content_type']);
				$imgsrc = $this->session->imgurl($img);
				$tmp = str_replace($config->basehref,
					$config->topdir, $imgsrc);
				if (!file_exists($tmp)) {
					$imgsrc = $this->session->imgurl("default_attach");
				}

				if ($attach['size'] <= 1) {
					$out .= '<a name="attach" href="'.$config->basehref.'">';
					$out .= '<img src="'.$imgsrc.
						'" alt="'.$attach['size'] .' '. lecho("byte") .' '.
						lecho("in body") .
						'" border="0" hspace="0" vspace="0" />'."\n";
					$out .= '</a>';
				} else {
					$out .= '&nbsp;<a name="attach" href="'.
						$config->basehref.
						'view_attach.'.$config->php.'?id='.$attach['id'].'">';
					$out .= '<img src="'.$imgsrc.
						'" alt="'.$this->size_unit($attach['size']).lecho("bytes") .' '.
						lecho("in body") .
						'" border="0" hspace="0" vspace="0" />'."\n";
					$out .= "</a>\n";
				}

				next($row['attach']);
			}
		}
		return $out;
	}

	/**
	 * Creates the HTML for "1 comment in 654"
	 *@param array ???
	 *@param string the section
	 *@param string the topic
	 *@param integer the year of publication
	 *@param integer the month of publication
	 *@param integer the day of publication
	 *@return string HTML code
	 *@access private
	 */
	Function newsbox_count_comments($row,$section,$topic,$year,$month,$day) {
		if (isset($row['comment'])) {
			$comment = $row['comment'];
		} else {
			$comment = 0;
		}
		if (isset($row['score_comment'])) {
			$score_comment = $row['score_comment'];
		} else {
			$score_comment = 0;
		}

		$out = '<a href="'.
			$this->session->newsurls($row['id'],$section,$topic,$year,$month,$day,-2,0).
			'">';
		if ($score_comment <= 1) {
			$out .= $score_comment.' '.lecho("comment");
		} else {
			$out .= $score_comment.' '.lecho("comments");
		}
		$out .= '</a>';
		if ($score_comment < $comment) {
			$out .= ' '.lecho("on ").' <a href="'.
				$this->session->newsurls($row['id'],$section,$topic,$year,$month,
																$day,0,0).
				'">'.$comment.'</a>';
		}
		return $out;
	}

	/**
	 * Creates a lonk to a topic (withg pretty image)
	 *@param string the name ofthe topic
	 *@return string HTML code for the link.
	 *@access private
	 */
	Function linkto_topic($topic) {
		global $config;

		$name_tmp = '<img src="'.$this->session->imgurl("section/".$topic).
			'" hspace="10" border="0" '.
			'alt="'.$topic.'" align="right" />';
		$url_tmp = $config->basehref.($config->visiblenewsfile ?
			$config->newsfile ."/" : "");
		if ($topic == 'notopic') {
			$out = $this->redirect->make($name_tmp);
		} else {
			$out = $this->redirect->make($name_tmp,
				$url_tmp.'topic/'.urlencode($topic).$config->extraopts.$config->ext);
		}
		return $out;
	}
}

	//   Derived classes are loaded by libdacode.php3
?>
