<?php
/**
 * Class to manage users
 *
 * daCode http://www.dacode.org/
 * src/phplib/users.php3
 * $Id: users.php3,v 1.265.2.31 2003/02/09 17:44:57 ruffy Exp $
 *
 * Depends: Config Db Html
 *
 *@author Laurent Desarmes <laurent@linuxfr.org>
 *@author Fabien Penso <penso@linuxfr.org>
 */
Class User {

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * Sessions handling instance
	 *@var object Session
	 */
	var $session;

	/**
	 * HTML rendering package
	 *@var object Html
	 */
	var $html;

	/**
	 * LDAP access package
	 *@var object Ldap
	 */
	var $ldap;

	/**
	 * Id of the current user
	 *@var integer
	 */
	var $user_id;

	/**
	 * First name of user
	 *@var string
	 */
	var $fname;

	/**
	 * Last name of user
	 *@var string
	 */
	var $lname;

	/**
	 * Login of user
	 *@var string
	 */
	var $login;

	/**
	 * Email of current user
	 *@var string
	 */
	var $email;

	/**
	 * Credentials
	 *@var integer ?
	 */
	var $level;

	/**
	 * Preferences
	 *@var integer ?
	 */
	var $param;

	/**
	 * Dunno
	 *@var string
	 */
	var $timestamp;

	/**
	 * Lest visit (timestamp)
	 *@var string
	 */
	var $last;

	/**
	 * 1 if logged
	 *@var boolean
	 */
	var $checked;

	/**
	 * ID of user's signature
	 *@var integer
	 */
	var $sig_id;

	/**
	 * User's homesite
	 *@var string
	 */
	var $homesite;

	/**
	 * User's sig
	 *@var string
	 */
	var $signature;

	/**
	 * Whether the user wants to hide other's sigs
	 *@var boolean
	 */
	var $hide_sig;

	/**
	 * Whether the user refuses check on HTTP_REFERER (unsafe!)
	 *@var boolean
	 */
	var $skip_referer;

	/**
	 * Pasword the user has typed
	 *@var string
	 */
	var $password;

	/**
	 * Unused??????? FIXME:
	 *@var mixed FIXME:
	 */
	var $status;

	/**
	 * Score threshold
	 *@var integer
	 */
	var $score;

	/**
	 * Array of supplementary infos
	 *@var array
	 */
	var $supp_info;

	/**
	 * Id of current news FIXME:
	 *@var integer
	 */
	var $news_id;

	/**
	 * Last time we've seen the user (timestamp)
	 *@var string
	 */
	var $lastseen;

	/**
	 * Whether user has chosen his boxes 
	 *@var boolean
	 */
	var $user_boxes;

	/**
	 * Class constructor
	 */
	Function User() {
		global $HTTP_COOKIE_VARS, $HTTP_SERVER_VARS, $config, $text;
		global $news_id;

		if (isset ($news_id)) {
			$this->news_id = $news_id;
			$update_ok = 1;
		} else {
			$this->news_id = (isset ($config->news_id)) ? $config->news_id : "";
			$update_ok = 0;
		}

		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->cache = LoadClass('Cache');
		$this->utils = LoadClass('Utils');
		$this->html  = LoadClass('Html');

		if ($config->ldap_hostname) {
			$this->ldap = LoadClass('Ldap');
		}

		if ($config->nodb == 1) {
			global $html, $nobanner, $title;
			$text = lecho("Sorry but the site is currently down for maintenance.<br />\n").
				lecho ("Thank you to come back in a few minutes!");
			$nobanner = false;
			$title = '';
			$html = $this->html;
			$this->html->parsetemplate("basic.tmpl");
			exit;
		}


		$this->user_id=$this->session->user_id;
		$this->fname=$this->session->fname;
		$this->lname=$this->session->lname;
		$this->login=$this->session->login;
		$this->email=$this->session->email;
		$this->level=$this->session->level;
		$this->param=$this->session->param;
		$this->timestamp=$this->session->timestamp;
		$this->lastseen=$this->session->lastseen;
		$this->homesite=$this->session->homesite;
		$this->last=$this->session->last;
		$this->checked=$this->session->checked;
		$this->sig_id=$this->session->sig_id;
		$this->status=$this->session->status;
		$this->score=$this->session->score;
		$this->signature=$this->session->signature;
		$this->password=$this->session->password;
		$this->supp_info=$this->session->supp_info;
		$this->user_boxes=$this->session->user_boxes;
		$this->HTTP_REFERER = '';

		if (isset ($HTTP_SERVER_VARS['HTTP_REFERER'])) {
			$this->HTTP_REFERER = $HTTP_SERVER_VARS['HTTP_REFERER'];
		}

		/*
		 * If user is logged, we do get his last visit depending of news_id and
		 * score.
		 */
		if ($this->checked && $this->news_id) {

			$sqlc_q = "SELECT timestamp FROM ".
				$config->tables['user_lastseen'].
				" WHERE user_id='". addslashes($this->user_id)."' AND ".
				"news_id='".addslashes($this->news_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo " SQL failed: ".$this->db->error(). " \n";
				echo "<br />$sqlc_q<br />\n";
			}

			if ($this->db->num_rows()) {
				$c=$this->db->fetch_array();
				$this->lastseen = $c['timestamp'];
				$this->db->free();

				if ($update_ok) {
					$sqlc_q = "UPDATE ".$config->tables['user_lastseen'].
						" SET timestamp=CURRENT_TIMESTAMP ".
						" WHERE user_id='". addslashes($this->user_id)."' AND ".
						"news_id='".addslashes($this->news_id)."'";

					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						echo " SQL failed: ".$this->db->error(). " \n";
						echo "<br />$sqlc_q<br />\n";
					}
				}
			} else {
				$sqlc_q = "INSERT INTO ".$config->tables['user_lastseen'].
					" VALUES ('". addslashes($this->user_id)."',".
					"'".addslashes($this->news_id)."',CURRENT_TIMESTAMP)";

				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo " SQL failed: ".$this->db->error(). " \n";
					echo "<br />$sqlc_q<br />\n";
				}

				$this->lastseen = "19700101000000";

			}

		}
		//echo "</td></tr></table>\n";
	}

	/**
	 * Display user information based on his parameter
	 *@return string login or first name / last name
	 *@access public
	 */
	Function identity() {
		if (($this->param & pow(2,0)) &&
			(!empty ($this->fname) || !empty ($this->lname)))
			return $this->fname.' '.$this->lname;
		return $this->login;
	}

	/**
	 * Get the user_id from users table
	 *@param string $login the login of the user
	 *@return mixed Error message or HTML about the user
	 *@access public
	 */
	Function get_infologin($login) {
		global $config;

		if (!isset ($login) ||
			!preg_match('/^[a-z]{1}[a-z0-9_]+$/i',$login)) {
			return;
		}

		/* SQL Command */
		$sqlc_q = 'SELECT '.
			$config->tables['users'].'.id'.
			' FROM '.$config->tables['users'].
			' WHERE '.
		$config->tables['users'].'.login="'.addslashes($login).'"';

		$ret = $this->db->query($sqlc_q);

		if ($this->db->num_rows() == 0) {
			return lecho("This user doesn't exist.<br />\n");
		} else {
			$c=$this->db->fetch_array();
			return $this->get_info($c['id']);
		}
	}

	/**
	 * Get informations about a user
	 *@param integer $id the user_id of the user
	 *@return mixed Error message or HTML if ok
	 *@access public
	 */
	Function get_info($id=0) {
		global $config;

		if ($id == '0' ||
			!ereg("^[0-9]+$",$id)) {
			return;
		}

		/* We build SQL */
		$sqlc_q = "SELECT ".
			$config->tables['users'].".id,".
			$config->tables['users'].".login,".
			$config->tables['users'].".lname,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".created,".
			$config->tables['users'].".homesite,".
			$config->tables['sig'].".sig".
			" FROM ".$config->tables['users'].",".$config->tables['sig'].
			" WHERE ".
			$config->tables['users'].".sig_id=".
			$config->tables['sig'].".id AND ".
			$config->tables['users'].".id='".addslashes($id)."'";
		/***********************/

		/* We build another SQL */
		$sqlc_q2 = "SELECT ".
			$config->tables['sessions'].".lastseen".
			" FROM ".$config->tables['users'].",".$config->tables['sessions'].
			" WHERE ".
			$config->tables['users'].".id=".
			$config->tables['sessions'].".user_id AND ".
			$config->tables['users'].".id='".addslashes($id)."'".
			" ORDER BY ".$config->tables['sessions'].".lastseen DESC";
		/***********************/

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error(). " -->\n";
			return lecho("Problem. Please contact the webmaster.<br />\n");
		}

		if ($this->db->num_rows() == 0) {
			$this->db->free();
			return lecho("This id doesn't exist.<br />\n");
		}

		$c=$this->db->fetch_array();
		// So we don't have warnings
		$c['homesite'] = (isset ($c['homesite'])) ? $c['homesite'] : "";
		$c['fname'] = (isset ($c['fname'])) ? $c['fname'] : "";
		$c['lname'] = (isset ($c['lname'])) ?  $c['lname'] : "";

		$ret = $this->db->query($sqlc_q2);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error(). " -->\n";
			return lecho("Problem. Please contact the webmaster.<br />\n");
		}

		if ($this->db->num_rows() != 0) {
			$d = $this->db->fetch_array();
			$c['lastseen'] = $d['lastseen'];
		}

		$out = "<table width=\"100%\"><tr><td class=\"newstext\">".
			"ID</td><td class=\"newstext\">".$c['id']."</td></tr>".
			"<tr><td class=\"newstext\">".lecho("Login").
			"</td><td class=\"newstext\">".
			htmlentities($c['login'])."</td></tr>".
			"<tr><td class=\"newstext\">".lecho("Last Name").
			"</td><td class=\"newstext\">".
			htmlentities($c['lname'])."</td></tr>".
			"<tr><td class=\"newstext\">".lecho("First Name").
			"</td><td class=\"newstext\">".
			htmlentities($c['fname'])."</td></tr>".
			"<tr><td class=\"newstext\">".lecho("Homesite").
			"</td><td class=\"newstext\"><a href=\"".$c['homesite']."\">".
			htmlentities($c['homesite'])."</a></td></tr>".
			"<tr><td class=\"newstext\">".lecho("Signature").
			"</td><td class=\"newstext\">".
			nl2br($c['sig'])."</td></tr>".
			"<tr><td class=\"newstext\">".lecho("Created Date").
			"</td><td class=\"newstext\">".
			$this->utils->stamp2date($c['created'],"longwyear")."</td></tr>";

		if (isset($c['lastseen'])) {
			$out .= "<tr><td class=\"newstext\">".lecho("Lastseen Date").
				"</td><td class=\"newstext\">".
				$this->utils->stamp2date($c['lastseen'],"longwyear")."</td></tr>";
		}
		$out .= "<tr><td class=\"newstext\" align=\"center\"><br /><a href=\"".
			$config->basehref."messages/post.".$config->php.
			"?user_id_dest=".$c['id']."\"><img alt=\"message\" border=\"0\" src=\"".
			$this->session->imgurl('mail')."\" /> ".lecho("Send a message").
			"</a></td>";

		if (!$config->disable_view_comments) {
			$out .= "<td class=\"newstext\" align=\"center\"><br /><a href=\"".
				$config->basehref.
				"users/posts.".$config->php."?order=id&amp;user_id=".$c['id']."\">".
				"<img alt=\"view comments\" border=\"0\" src=\"".
				$this->session->imgurl('view')."\" /> ".lecho("View comments")."</a>";
		}
		$out .= "</td></tr>";

		if ($config->moderation_type == 2) {
			$sqlc_q = "SELECT vote_nb,vote_nb_orig,experience FROM ".
				$config->tables['karma_user']." WHERE user_id='".
				addslashes($c['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$sqlc_q.$this->db->error()." -->";
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}

			$karma_user_tmp = $this->db->fetch_array();
			reset($config->level_values);
			$i=0;
			while (list(,$val) = each($config->level_values)) {
				if ($karma_user_tmp['experience'] >= $val['xp']) {
					$i++;
					continue;
				} elseif ($karma_user_tmp['experience'] < $val['xp']) {
					if ($i > 0) {
						$i--;
					}
					$level_values = lecho($config->level_values[$i]['name']);
					break;
				}
			}

			$out .= "<tr><td colspan=\"2\" align=\"center\"><br />".
				"<hr width=\"50%\" /><br /></td></tr>\n";


			$out .= "<tr><td class=\"newstext\">".lecho("Level").
					"</td><td class=\"newstext\">".
					$level_values . "</td></tr>".
					"<tr><td class=\"newstext\">".lecho("Votes per day").
					"</td><td class=\"newstext\">".
					$karma_user_tmp['vote_nb_orig'] . "</td></tr>".
					"<tr><td class=\"newstext\">".lecho("Rest of votes").
					"</td><td class=\"newstext\">".
					$karma_user_tmp['vote_nb'] . "</td></tr>".
					"<tr><td class=\"newstext\">".lecho("Experience").
					"</td><td class=\"newstext\">".
					$karma_user_tmp['experience'] . "</td></tr>";
		}

		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$tmp = "";

			$sqlc_q = "SELECT supp_info FROM ".$config->tables['users_supp'].
				" WHERE user_id='".addslashes($c['id'])."'";
			$ret = $this->db->query($sqlc_q);

			if (!$ret) {
				echo "<!-- SQL failed: ".$sqlc_q.$this->db->error()." -->";
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}

			if ($this->db->num_rows()) {
				$c=$this->db->fetch_array();
				$supp_info = unserialize($c['supp_info']);

				if (gettype($supp_info) == "array") {
					reset($supp_info);
					while (list($key,$val) = each($supp_info)) {
						if ($val != "") {
							if (!$config->supp_fields[$key]['public'] && !$this->checked) {
								$mytmp = lecho("Must be logged...");
							} else {
								$sf_typestempo = $config->supp_fields[$key]['type'];
								eval("\$mytmp=".
									$config->supp_fields_types[$sf_typestempo]['method']);
							}
							$tmp .= "<tr><td class=\"newstext\">".ucfirst($key).
								"</td><td class=\"newstext\">";
							$tmp .= nl2br($mytmp)."</td></tr>";
						}
					}
				}
			}
			if ($tmp != "") {
				$out .= "<tr><td colspan=\"2\" align=\"center\"><br />".
					"<hr width=\"50%\"><br /></td></tr>\n";
			}
			$out .= $tmp;
		}

		/// finished supp. fields ///
		$out .= "</table>\n";

		return $this->html->simplebox($out);

	}

	/**
	 * Get the user's experience
	 *@param int the user_id of the user
	 *@return int XP of the user
	 *@access public
	 */
	Function get_xp($id) {
		global $config;

		if ($id == '0' || !ereg("^[0-9]+$",$id)) {
			return;
		}

		if ($config->moderation_type == "2") {
			$sqlc_q = "SELECT experience FROM ".
				$config->tables['karma_user']." WHERE user_id='".
				addslashes($id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp = "<!-- SQL failed: ".$sqlc_q.$this->db->error()." -->";
				$tmp .= "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
				return $tmp;
			}

			$karma_user = $this->db->fetch_array();

			return $karma_user['experience'];
		}
	}

	/**
	 * Get last people connected (authentified people)
	 *@param integer number of last users connected
	 *@return string html to be displayed
	 *@access public
	 */
	Function get_lastconnected($nb=10) {
		global $config;
		$out="";

		if (!is_integer($nb) or $nb<1 or $nb>5000) {
			$nb = 10; // sqlchecked: it must be in [1..5000];
		}
		$cachetmp = Array($nb, $config->depth);

		$fcontents = $this->cache->check_box("60","user_lastconnected",$cachetmp);
		if (!empty ($fcontents)) {
			return $fcontents;
		}

		$sqlc_q = "SELECT ".
			$config->tables['users'].".id,".
			$config->tables['users'].".login,".
			$config->tables['users'].".lname,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".param,".
			$config->tables['users'].".lastseen FROM ".
			$config->tables['users'].
			" ORDER BY lastseen DESC ".$this->db->compat_limit($nb);

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return '<div class="newstext">'. lecho("Something went wrong. ").
				lecho("Please contact the webmaster."). '</div><br />';
		}

		while ($c=$this->db->fetch_array()) {
			if ($c['lastseen'] > 1) {
				if ($c['param'] & pow(2,4)) {
					continue;
				}
				// Now we choose to show login or fname/lname
				if (($c['param'] & pow(2,0)) && $c['id'] != 1 &&
					(!empty ($c['lname']) || !empty ($c['fname']))) {
					$usermask = $c['fname']." ".$c['lname'];
				} else {
					$usermask = $c['login'];
				}

				$out .= '&nbsp;'.$this->utils->stamp2time($c['lastseen'],'short').
					' <a href="'.$config->basehref.'users/?a=vu&amp;user_id='.
					$c['id'].'">'.htmlentities($usermask)."</a><br />\n";
			}
		}
		$this->db->free();

		if (empty ($out)) {
			$out = lecho("No logged user yet.");
		}

		$this->cache->write_box("user_lastconnected",$cachetmp,$out);
		return $out;

	}

	/**
	 * Returns the sessions of a user
	 * @param string $id the session id
	 * @return string the HTML to be displayed
	 * @access public
	 */
	Function get_sessions($id) {
		global $config;
		$out = '';

		$sqlc_q = 'SELECT '.
			$config->tables['sessions'].'.id,'.
			$config->tables['sessions'].'.ip,'.
			$config->tables['sessions'].'.lastseen,'.
			$config->tables['sessions'].'.expire'.
			' FROM '.
			$config->tables['sessions'].
			' WHERE '.
			$config->tables['sessions'].'.user_id='.addslashes($id).
			' ORDER BY lastseen DESC';

		$ret = $this->db->query($sqlc_q);

		$out .= '<form method="post" action="'.$config->basehref.
			'users/delsess.'.$config->php.'">'.
			'<table border="0" cellspacing="1" cellpadding="1" width="100%">'.
			'<tr><td>&nbsp;</td>'.
			'<td class="sboxtext">'.lecho("Session ID").'</td>'.
			'<td class="sboxtext">'.lecho("Session Last IP").'</td>'.
			'<td class="sboxtext">'.lecho("Last Seen").'</td>'.
			'<td class="sboxtext">'.lecho("Expire").'</td></tr>';

		while ($c = $this->db->fetch_array()) {
			$out .= '<tr>';
			$out .= '<td><input type="checkbox" name="table[]" value="'.$c['id'].
				'" /></td>'.
				'<td class="sboxtext">'.$c['id'].'</td>'.
				'<td class="sboxtext">'.$this->utils->convertip($c['ip']).'</td>'.
				'<td class="sboxtext">'.$this->utils->stamp2datetime($c['lastseen']).
				'</td>'.
				'<td class="sboxtext">'.$this->utils->stamp2datetime($c['expire']).
				'</td>';
			$out .=	'</tr>';
		}

		$out .= '<tr><td colspan="5" class="sboxtext" align="center">'.
			'<input type="submit" name="submit" value="'.
			lecho("Delete").'" /></td></tr></table></form>';

		return $out;
	}

	/**
	 * Text displayed in authentication box
	 *@return string html to be displayed
	 *@access public
	 */
	Function logintext() {
		global $config;

		$text = "<form method=\"post\" action=\"".$config->basehref.
			"users/login.".$config->php."\">".
			"<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" ".
			"width=\"100%\">\n<tr><td class=\"newstext\">\n<center>".
			"<select name=\"table[time]\">".
			"<option value=\"3600\">1 ".lecho("hour")."</option>".
			"<option value=\"86400\">1 ".lecho("day")."</option>".
			"<option value=\"2592000\">1 ".lecho("month")."</option>".
			"<option value=\"31104000\" selected=\"selected\">1 ".lecho("year").
			"</option>".
			"</select></center></td></tr>".

			"<tr><td class=\"newstext\"><center>".
			"<input type=\"text\" name=\"table[login]\" value=\"".lecho("Login").
			"\" size=\"10\" maxlength=\"20\" ".
			"onfocus=\"if (this.value=='".lecho("Login").
			"') this.value=''\" /></center></td></tr>".

			"<tr><td class=\"newstext\"><center>".
			"<input type=\"password\" name=\"table[passwd]\" size=\"10\"".
			" maxlength=\"20\" value=\"passwordez\" onfocus=\"this.value=''\" />".
			"</center></td></tr>".

			"<tr><td class=\"newstext\">\n<center>".
			"<input type=\"image\" src=\"".$this->session->imgurl('submit').
			"\" alt=\"".lecho("Submit")."\"".
			" style=\"border: 0px\" />".
			"</center>".
			"</td></tr>\n".
			"</table></form><br />\n".

			'<center><span class="newstext">';
		if (isset ($config->restricted_registration) && !$config->restricted_registration) {
			$text .= '<a href="'.$config->basehref.
			'users/?a=na">'.lecho("New Account").'</a><br />';
		}
		if (!$config->nis_domain) {
			$text .= '<a href="'.$config->basehref.'users/?a=rp">'.
				lecho("Forgot your Password?").'</a><br />';
		}

		$text .= "</span></center>";
		return $text;
	}

	/**
	 * Sidebox to display when a user is logged successfully.
	 *@return string html to be displayed
	 *@access public
	 */
	Function loginbox() {
		global $config;

		if ($this->checked) {
			// in the loginbox, a new entry: comments
			$tmp = "<center>\n".
				' <a href="'.$config->basehref.
					'users/?a=mu">'.lecho("Preferences")."</a>\n".
				" <br />\n".
				' <a href="'.$config->basehref.
					'users/?a=cs">'.lecho("Close your Session")."</a>\n".
				" <br />\n".
				' <a href="'.$config->basehref.'users/posts.'.
					$config->php.'?order=id">'.lecho("Comments")."</a>\n".
				" <br />\n".
				' <a href="'.$config->basehref.
					'messages/">'.lecho("Messages")."</a>\n".
				" <br />\n";
			if ($config->moderation_type == 2) {
				$tmp .= lecho("XP: "). $this->session->experience. "<br />";
				if ($this->session->vote_nb_orig > 1) {
					$tmp .= $this->session->vote_nb_orig ." ". lecho("votes per day").
					"<br />";
				} else {
					$tmp .= $this->session->vote_nb_orig ." ". lecho("vote per day").
					"<br />";
				}
				$tmp .= lecho("left") . ": " . $this->session->vote_nb . "<br />";
				$tmp .= lecho("you are a ") . $this->session->karma_name ."<br />";

			}

			$tmp .=	"</center>\n";
			$title = '<u>'.$this->identity().'</u>';
		} else {
			$tmp = $this->logintext();
			$title = lecho("Authentication");
		}
		return $this->html->sidebox($title,$tmp,'login');
	}

	/**
	 * Function used to log in
	 *@param array contains fields : login, passwd, time
	 *@return integer 1 if success, -1 else 
	 *@access public
	 */
	Function do_login($row) {
		global $config;

		$unique_id=$this->utils->makerand(19);

		if ($row['login'] && $row['passwd'] && $row['time']) {

			$ip=$this->utils->ip();

			if ($this->ident($row['login'],$row['passwd'])==1) {

				$expire=$row['time'];
				if ($this->login!=$row['login']) {
					setcookie("login",$this->login,time()+$expire,"/",
						$config->cookiedomain);
				}

				$sqlc_q = "INSERT INTO ".$config->tables['sessions'].
					" (id,user_id,ip,lastseen,expire) VALUES ('".
					addslashes($unique_id)."','".
					addslashes($this->user_id)."','".
					addslashes($ip)."',CURRENT_TIMESTAMP,".
					$this->db->compat_date_add($expire).")";

				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "<!-- SQL failed: ".$this->db->error(). " -->\n";
					return -1;
				}

				if ($this->db->affected_rows()==1) {
					unset($row['passwd']);
					setcookie("session_id",$unique_id,time()+$expire,"/",
						$config->cookiedomain);
					return 1;
				}

			} else {
				echo lecho("Wrong password...\n");
				return -1;
			}
		} else {
			header("Cache-Control: no-cache, must-revalidate");
			header("Pragma: no-cache");
			header("Location: ".$config->basehref);
			exit;
		}
	}

	/**
	 * Test if ident is right
	 *@param string login
	 *@param string passwd
	 *@return integer 1 if success, 0 else 
	 */
	Function ident($login,$passwd) {
		global $config;

		if ($config->ldap_hostname) {
			$this->ldap->search("(login=$login)");
			$attrs = $this->ldap->fetch();
			$ldap_passwd = $attrs['userpassword'][0];
			$ldap_passwd = strtok($ldap_passwd,'}');
			$ldap_passwd = strtok('}');

			if ($this->utils->crypt_dacode($passwd, $ldap_passwd) == 1) {
				$this->lname=$attrs['lname'][0];
				$this->fname=$attrs['fname'][0];
				$this->login=$attrs['login'][0];
				$this->email=$attrs['email'][0];
				$this->user_id=$attrs['id'][0];
				$this->level=(int) $attrs['level'][0];
				$this->timestamp=$attrs['created'][0];
				return 1;
			}
			return 0;
		} elseif ($config->nis_domain) {

			$sqlc_q = "SELECT id,lname,fname,email,level,".
					"created FROM ".$config->tables['users']." WHERE login='".
					addslashes($login)."'";
			$ret = $this->db->query($sqlc_q);

			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error(). " -->\n";
				return -1;
			}
			if ($this->db->num_rows() == 0) {
				$this->db->free();
				return 0;
			}

			$c=$this->db->fetch_array();

			$nis_entry = yp_match($config->nis_domain,"passwd.byname",$login);
			if (!$nis_entry) {
				return 0;
			}
			$nis_array = explode(":",$nis_entry);
			$nis_passwd = $nis_array[1];

			//lname and fname may be NULL...
			if ($this->utils->crypt_dacode($passwd, $nis_passwd) == 1) {
				$this->user_id=$c['id'];
				$this->lname=isset ($c['lname'])?$c['lname']:"";
				$this->fname=isset ($c['fname'])?$c['fname']:"";
				$this->login=$login;
				$this->email=$c['email'];
				$this->level= (int) $c['level'];
				$this->timestamp=$c['created'];
				return 1;
			}
			$this->db->free();

			return 0;

		} else {
			$sqlc_q = "SELECT id,lname,fname,passwd,email,level,".
				"created FROM ".$config->tables['users']." WHERE login='".
				addslashes($login)."'";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error(). " -->\n";
				return -1;
			}
			if ($this->db->num_rows() == 0) {
				$this->db->free();
				return 0;
			}

		  
			$c=$this->db->fetch_array();
			//Lname and fname may be null!
			if ($this->utils->crypt_dacode($passwd, $c['passwd']) == 1) {
				$this->user_id=$c['id'];
				$this->lname=isset ($c['lname'])?$c['lname']:"";
				$this->fname=isset ($c['fname'])?$c['fname']:"";
				$this->login=$login;
				$this->email=$c['email'];
				$this->level= (int) $c['level'];
				$this->timestamp=$c['created'];
				return 1;
			}
			$this->db->free();

			return 0;
		}
	}

	/**
	 * Create a new account
	 *@param string form  
	 *@return mixed html to display or -1 if error
	 */
	Function newaccount($form) {
		global $HTTP_REFERER;
		global $config;

		$out = '';
		if (!preg_match('/^\w{3,20}$/i',$form['login2'])) {
			$out .= "<span class=\"newstext\">-&nbsp;".
				lecho("Login must be 3 characters long").
				$form['login']."</span><br />\n";
			$form['login'] = "";
		}

		// If we have supplementary fields, we verify they are
		// not too big
		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$table_tmp = array();
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				if (strlen($form[$key]) > $val['max_length']) {
					$out .= "<span class=\"newstext\">&nbsp;".
						$key.lecho(" can't be that big.").
						lecho(" Sorry."). "</span><br />\n";
				}
			}
		}

		// TODO Make a real RFC822 compliant check
		if (!preg_match('/^[\w_\-\+\.\']+@[\w_\-\.]+$/',$form['email'])) {
			$out .= "<span class=\"newstext\">-&nbsp;".lecho("Email looks wrong").
				"</span><br />\n";
			$form['email'] = "";
		} else {
			$sqlc_q = "SELECT login FROM ". $config->tables['users'].
				" WHERE email='".addslashes($form['email'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				return -1;
			}
			if ($this->db->num_rows()) {
				$out .= '<br />'.lecho("An account use already this mail");
				$form['email'] = "";
			}
			$this->db->free();
		}
		$sqlc_q = "SELECT login FROM ".$config->tables['users'].
			" WHERE login='".addslashes($form['login2'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		if ($this->db->num_rows()) {
			$out .= '<br /><br />'.
				lecho("An account already exists with this login");
			$form['login'] = "";
		}

		if ($config->nis_domain &&
			!yp_match($config->nis_domain,"passwd.byname",$form['login2'])) {
			$out .= '<br /><br />'.lecho("NIS entry doesn't exist");
			$form['login'] = "";
		}

		$this->db->free();

		if (!empty ($out)) {
			return $out;
		}

		//   Make sure there is no HTML sequence in user table
		$form['passwd'] = '';
		if (!$this->utils->html_safe($form)) {
			return '<br />'.lecho("Invalid &lt; sign in datas");
		}

		$form['passwd'] = $this->utils->makerand();

		$encrypted_passwd = $this->utils->crypt_dacode($form['passwd']);

		$sqlc_q = "INSERT INTO ".$config->tables['users'].
			" (lname,fname,login,passwd,email,created,level,theme) ".
			"VALUES ('".
			addslashes($form['lname'])."','".
			addslashes($form['fname'])."','".
			addslashes($form['login2'])."','".
			addslashes($encrypted_passwd)."','".
			addslashes($form['email'])."',".
			"CURRENT_TIMESTAMP,'".
			addslashes($config->usersdefaultlevel)."','".
			addslashes($config->dft_prefs['theme'])."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$sqlc_q.$this->db->error()." -->";
			return -1;
		}

		$user_id = $this->db->last_insert_id();

		if ($config->ldap_hostname) {
			$sqlc_q = "SELECT created FROM ".$config->tables['users'].
				" WHERE id='".addslashes($user_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return -1;
			}
			$row=$this->db->fetch_array();

			$this->ldap->cd($config->ldap_basedn);
			$this->ldap->mkdir("login",addslashes($form['login2']));
			$node = "login=".addslashes($form['login2']).",".$config->ldap_basedn;
			$this->ldap->cd($node);

			$attrs['objectClass'] = "dacode";
			$attrs['login'] = $form['login2'];
			$attrs['id'] = $user_id;
			$attrs['lname'] = $form['lname'];
			$attrs['fname'] = $form['fname'];
			$attrs['userpassword'] = "{crypt}".$encrypted_passwd;
			$attrs['email'] = $form['email'];
			$attrs['score'] = $form['score'];
			$attrs['theme'] = $config->dft_prefs['theme'];
			$attrs['created'] = $row['created'];

			$this->ldap->modify($attrs);
		}

		// If we have supplementary fields
		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$table_tmp = array();
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				$table_tmp[$key] = $form[$key];
			}

			reset($table_tmp);
			$tmp_serialize = serialize($table_tmp);

			//   Make sure there is no HTML sequence in user table
			if (!$this->utils->html_safe($tmp_serialize)) {
				return '<br />'.lecho("Invalid &lt; sign in datas");
			}

			$sqlc_q = "INSERT INTO ".$config->tables['users_supp'].
				" (user_id,supp_info) VALUES ('".
				addslashes($user_id)."','".
				addslashes($tmp_serialize)."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
		}
		/// finished supp. fields ///

		/*
		 * If we use the moderation system 2 we insert karma ...
		 */
		$sqlc_q = "INSERT INTO ".$config->tables['karma_user'].
			" (vote_nb,vote_nb_orig,experience,user_id) VALUES ".
			"('0','0','0','".addslashes($user_id)."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("It looks like admins are working on the server");
			exit;
		}
		/// finished karma user ///

		$text = lecho("You asked for an account.  In order to validate it, you'll need to authenticate yourself at least one time during this week, or your account will be deleted.")."\n\n";

		$text .= lecho("Login") . ": ".$form['login2']."\n";
		if (!$config->nis_domain) {
			$text .= lecho("Password") . ": ".$form['passwd']."\n";
		} else {
			$text .= lecho("Password") . ": ".lecho("your NIS passwd")."\n";
		}
		$text .= "URL: ".$config->baseurl."\n";

		if ($this->utils->send_email($form['email'],lecho("New Account"),$text)) {
			return lecho("Your password was sent to the address ").$form['email'];
		} else {
			return lecho("Error, the email couldn't be send.<br />Perhaps the mail server is not up?");
		}
	}

	/**
	 * Show form for people who forgot their password
	 *@return string html simplebox to display 
	 */
	Function show_forget () {
		global $config;

		$tmp = lecho("Fill only one field").
			'<br /><br /><form method="post" action="'.
			$config->basehref.'users/password.'.$config->php.'">'.
			'<table border="0" cellspacing="1" '.
			'cellpadding="1" width="100%">'.
			'<tr align="center"><td>'.lecho("Login").'</td>'.
			'<td><input type="text" name="al_login" value="'.
			$this->login.'" size="10" maxlength="20" /></td></tr>'.
			'<tr align="center"><td>'.lecho("E-Mail").'</td>'.
			'<td><input type="text" name="al_email" size="10"'.
			' value="'.$this->email.'" /></td></tr>'.
			'<tr align="center"><td colspan="2">'.
			'<input type="submit" name="submit" value="'.
			lecho("Receive Password").'" /></td></tr>'.
			'</table></form>';

		return $this->html->simplebox($tmp);
	}

	/**
	 * Send password to a user
	 *@param string login
	 *@param string passwd
	 *@return mixed html to display or -1 if error
	 */
	Function send_password ($login="",$email="") {
		global $config;

		$out = ''; 

		if ((empty ($login) && empty ($email)) || ($login==lecho("Anonymous"))) {
			header('Location: '.$this->HTTP_REFERER);
			exit;
		}

		// As we don't know the clear password, we generate one and we send it
		// again.
		// But first let's check if user exists
		if (!empty ($login)) {
			$sqlc_q = "SELECT email,login FROM ".$config->tables['users'].
			" WHERE login='".addslashes($login)."'";
		} else {
			$sqlc_q = "SELECT email,login FROM ".$config->tables['users'].
			" WHERE email='".addslashes($email)."'";
		}

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error(). " -->";
			return -1;
		}

		if ($this->db->num_rows()!=1) {
			$out = lecho("Not Found");
			return $out;
		}

		$tmp = $this->db->fetch_array();

		$passwd_new = $this->utils->makerand();
		$encrypted_passwd = $this->utils->crypt_dacode($passwd_new);

		$sqlc_q = "UPDATE ".$config->tables['users']." SET passwd='".
			addslashes($encrypted_passwd)."', created=created WHERE login='".
			addslashes($tmp['login'])."' AND email='".addslashes($tmp['email'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error(). " -->";
			return -1;
		}

		$text = lecho("Login") . ": ".$tmp['login']."\n".
				lecho("Password") . ": ".$passwd_new."\n";

		if ($this->utils->send_email($tmp['email'],$config->titledefault.": ".
																lecho("Password"),$text)) {
			$out.= lecho("Password Sent");
		} else {
			$out.= lecho("Error, the email couldn't be send.<br />Perhaps the mail server is not up?");
		}
		return $out;
	}

	/**
	 * Get signature
	 *@param integer user id
	 *@return string signature of the user
	 */
	Function get_sig($id) {
		global $config;

		$tmp = "";

		$sqlc_q = "SELECT sig FROM ".$config->tables['sig']." WHERE id='".
				addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}

		if ($this->db->num_rows()==1) {
			$c=$this->db->fetch_array();
			if ($c['sig']) {
				$this->signature=$c['sig'];
			}
		}
		$this->db->free();
		return $this->signature;
	}

	/**
	 * Print table for settings
	 *@return string html to display
	 */
	Function print_setting() {
		global $config;

		$tmp = "";
		if (!$this->checked) {
			$tmp .=  lecho("Must be logged...")."<br />\n";
			return $tmp;
		}

		$tmp = "<form method=\"post\" action=\"".$config->basehref.
			"users/settings.".$config->php."\">".
			"<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\"".
			" width=\"100%\"><tr><td class=\"sboxtext\">".lecho("Login").
			"</td><td class=\"sboxtext\">".htmlentities($this->login).
			"</td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("Last Name")."</td>".
			"<td class=\"sboxtext\"><input type=\"text\" name=\"table[lname]\" ".
			"size=\"30\" value=\"".htmlspecialchars($this->lname)."\" /></td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("First Name")."</td>".
			"<td class=\"sboxtext\"><input type=\"text\" name=\"table[fname]\" ".
			"size=\"30\" value=\"".htmlspecialchars($this->fname)."\" /></td></tr>".

			"<tr><td class=\"sboxtext\" colspan=\"2\"><br />".
			lecho("If you want to change your E-mail address, then change ").
			lecho("it in the following field and click on the Confirm button.").
			"<br />".
			lecho("You will receive an E-mail to your <b>new</b> address asking").
			lecho(" you to confirm that you want to change your E-Mail address.").
			"<br />".
			lecho("Just click on the url written in the mail to valid changes.").
			"</td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("E-Mail")."</td>".
			"<td class=\"sboxtext\"><input type=\"text\" name=\"table[email]\" ".
			"size=\"30\" value=\"".htmlspecialchars($this->email)."\" /></td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("Homesite")."</td>".
			"<td class=\"sboxtext\"><input type=\"text\" name=\"table[homesite]\" ".
			"size=\"30\" value=\"".htmlspecialchars($this->homesite).
			"\" /></td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("Signature")."</td>".
			"<td class=\"sboxtext\"><textarea name=\"table[signature]\" cols=\"30\"".
			" rows=\"2\">\n".$this->get_sig($this->sig_id)."</textarea></td></tr>".

			"<tr><td class=\"sboxtext\">".lecho("Theme")."</td>".
			"<td class=\"sboxtext\">".
			"<select name=\"table[theme]\">\n";

		reset($config->listofthemes);
		while (list($i, $theme) = each ($config->listofthemes)) {
			$tmp .= '<option value="'.$i.'"';
			if ($theme == $config->theme_name) {
				$tmp .= " selected=\"selected\"";
			}
			$tmp .= ">".$theme."</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Score")."</td><td>".
			"<select name=\"table[score]\">\n";
		for ($i=-1;$i<=5;$i++) {
			$tmp .= '<option value="'.$i.'"';
			if ($i == $this->score) {
				$tmp .= " selected=\"selected\"";
			}
			$tmp .= ">$i</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Hide signatures").
			"</td><td><select name=\"table[hide_sig]\">\n".
			"<option value=\"1\"".($this->param & pow(2,2) ?
			" selected=\"selected\"" : "").
			">".lecho("Yes")."</option>\n".
			"<option value=\"0\"".($this->param & pow(2,2) ? "" :
			" selected=\"selected\"").
			">".lecho("No")."</option>\n";
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Display").
			"</td><td class=\"sboxtext\"><select name=\"table[identity]\">\n".
			"<option value=\"1\"".($this->param & pow(2,0) ?
			" selected=\"selected\"" : "").
			">".lecho("First Name")." ".lecho("Last Name")."</option>\n".
			"<option value=\"0\"".($this->param & pow(2,0) ? "" :
			" selected=\"selected\"").
			">".lecho("Login")."</option>\n";
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Skip referer").
			"</td><td class=\"sboxtext\"><select name=\"table[skip_referer]\">\n".
			"<option value=\"1\"".
			($this->param & pow(2,3) ? " selected=\"selected\"" : "").
			">".lecho("Yes")."</option>\n".
			"<option value=\"0\"".
			($this->param & pow(2,3) ? "" : " selected=\"selected\"").
			">".lecho("No")."</option>\n";
		$tmp .= "</select></td></tr>\n";


		$tmp .= "<tr><td class=\"sboxtext\">".
			lecho("Don't be listed in last users").
			"</td><td><select name=\"table[no_last_users]\">\n".
			"<option value=\"1\"".($this->param & pow(2,4) ?
			" selected=\"selected\"" : "").
			">".lecho("Yes")."</option>\n".
			"<option value=\"0\"".($this->param & pow(2,4) ? "" :
			" selected=\"selected\"").
			">".lecho("No")."</option>\n";
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".
			lecho("Be anonymous in board").
			"</td><td><select name=\"table[no_board]\">\n".
			"<option value=\"1\"".
			($this->param & pow(2,6) ?  " selected=\"selected\"" : "").
			">".lecho("Yes")."</option>\n".
			"<option value=\"0\"".
			($this->param & pow(2,6) ? "" : " selected=\"selected\"").
			">".lecho("No")."</option>\n";
		$tmp .= "</select></td></tr>\n";

		// If we have supplementary fields
		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$tmp .= "<tr><td colspan=\"2\"><center>".
				"<hr width=\"50%\"></center></td></tr>";
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				
				//The supplementary info may no be set... 
				//In this case we skip to next iteration
				//if (!isset ($this->supp_info[$key])) continue;

				$tmp .= '<tr><td class="sboxtext">'.ucfirst($key)."</td>\n".
					'<td class="newstext">';
				if ($val['type'] == "text") {
					$tmp .= "<input type=\"".$val['type']."\" size=\"".
						$val['length']."\" maxlength=\"".
						$val['max_length']."\" name=\"table[".$key."]\" value=\"".
						htmlspecialchars(isset($this->supp_info[$key])?$this->supp_info[$key]:'')."\" />";
				} elseif ($val['type'] == "textarea") {
					list($cols,$rows) = split (",", $val['length'], 2);
					$tmp .= "<textarea cols=\"".$cols."\" ".
						"rows=\"".$rows."\" name=\"table[".$key."]\">".
						(isset($this->supp_info[$key])?$this->supp_info[$key]:'')."</textarea>\n";
				} else {
					$tmp .= "<input type=\"text\" size=\"".
						$val['length']."\" maxlength=\"".
						$val['max_length']."\" name=\"table[".$key."]\" value=\"".
						htmlspecialchars(isset($this->supp_info[$key])?$this->supp_info[$key]:'')."\" />";
				}
				$tmp .= "</td></tr>\n";
			}
		}
		/// finished supp. fields ///

		$tmp .= "<tr><td>&nbsp;</td></tr>\n".
			"<tr align=\"center\"><td colspan=2><input type=\"submit\"".
			" name=\"submit\" value=\"".lecho("Confirm")."\" /></td></tr>";



		$tmp .= "</table>";

		$out = $this->html->simplebox($tmp) . "<br /><br />";


		/*
		 * This is for user configurable function
		 */

		if (gettype($config->user_boxes) == "array" &&
			count($config->user_boxes) > 0) {
			$tmp = "<table border=\"1\" cellspacing=\"1\" cellpadding=\"1\"".
				"width=\"100%\"><tr>";
			$tmp .= "<td colspan=\"2\" class=\"sboxtext\"><center>";
			$tmp .= lecho("Here you can choose which boxes you ").
				lecho("want on the main page, and their vertical order.");
			$tmp .= "</center></td></tr><tr>";
			$tmp .= "<td class=\"sboxtext\">";
			$tmp .= "<center><b>".
				lecho("Available boxes")."</b></center><br /><br />\n";

			reset($config->user_boxes);

			while ($cur = current($config->user_boxes)) {
				$key = key($config->user_boxes);

				if (gettype($cur) == "array" &&
					isset ($cur['function']) &&
					strlen($cur['function']) != 0) {

					/*
					 * This should probably be optimized
					 */
					if (gettype($this->user_boxes) == "array") {
						reset($this->user_boxes);
						$checked = "";
						while ($cur2 = current($this->user_boxes)) {
							if ($cur2 == $key) {
								$checked = ' checked="checked"';
								break;
							}
							next($this->user_boxes);
						}
					}

					if (!empty ($checked)) {
						next($config->user_boxes);
						continue;
					}

					$tmp .= '<input type="checkbox" name="table[user_'.$key.']" />';

						if (isset ($cur['url'])) {
							$tmp .= '<a href="'.$cur['url'].'">'.
								(( isset ($cur['info']) && strlen($cur['info']) != 0 ) ?
									$cur['info'] : $key ) . '</a><br />';
						} else {
							$tmp .= (( isset ($cur['info']) && strlen($cur['info']) != 0 ) ?
									$cur['info'] : $key ).'<br />';
						}

				}

				next($config->user_boxes);
			}

			$tmp .= "</td><td class=\"sboxtext\"><center><b>".lecho("Used boxes").
				"</b></center><br /><br />\n";

			$tmp_ok=0;
			if (gettype($this->user_boxes) == "array") {
				reset($this->user_boxes);
				while ($cur = current($this->user_boxes)) {

					reset($config->user_boxes);
					while ($cur2 = current($config->user_boxes)) {
						if (key($config->user_boxes) == $cur) {
							$tmp .= lecho("Activated").
							": <input type=\"checkbox\" name=\"table[user_".
								key($config->user_boxes)."]\" checked=\"checked\" />\n";

							if ($tmp_ok) {
								$tmp .= lecho("Up").
								": <input type=\"checkbox\" name=\"table[up_".
									key($config->user_boxes)."]\" />\n";
							}

							if (isset ($cur2['url'])) {
								$tmp .= '<a href="'.$cur2['url'].'">'.
									(( isset ($cur2['info']) && strlen($cur2['info']) != 0 ) ?
										$cur2['info'] : $key ) . '</a><br />';
							} else {
								$tmp .= ((isset ($cur2['info']) && strlen($cur2['info']) != 0)
									? $cur2['info'] : $key ).'<br />';
							}

							$tmp_ok=1;
							break;
						}

						next($config->user_boxes);
					}

					next($this->user_boxes);
				}
			}



			$tmp .= "</td></tr><tr><td class=\"sboxtext\" colspan=\"2\">";
			$tmp .= "<center><br /><input type=\"submit\" name=\"submit\" value=\"".
				lecho("Confirm")."\" /></center>";

			$tmp .= "</td></tr></table>\n";

			$out .= $this->html->simplebox($tmp);
		}
		$out .= "</form>";

		if (!$config->nis_domain) {
			$tmp = "<form method=\"post\" action=\"".$config->basehref.
				"users/modpasswd.".$config->php."\">".
				"<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\"".
				"width=\"100%\"><tr><td class=\"sboxtext\">".lecho("Old Password").
				"</td><td class=\"sboxtext\">".
				"<input type=\"password\" name=\"table[oldpasswd]\" ".
				"size=\"30\" /></td></tr>".
				"<tr><td class=\"sboxtext\">".lecho("New Password").
				"</td><td class=\"sboxtext\">".
				"<input type=\"password\" name=\"table[newpasswd]\" size=\"30\" />".
				"</td></tr>".
				"<tr><td class=\"sboxtext\">".lecho("New Password again").
				"</td><td class=\"sboxtext\">".
				"<input type=\"password\" name=\"table[newpasswd2]\" size=\"30\" />".
				"</td></tr><tr><td>&nbsp;</td></tr>\n<tr align=\"center\">".
				"<td colspan=\"2\" class=\"sboxtext\">".
				"<center><input type=\"submit\" name=\"submit\" value=\"".
				lecho("Confirm")."\" /></center></td></tr></table></form>\n";
			$out .= $this->html->simplebox($tmp);
		}

		/*  
		 *   Sessions management
		 */
		$tmp = $this->get_sessions($this->user_id);
		$out .= $this->html->simplebox($tmp) . "<br /><br />";

		return $out;
	}

	/**
	 * Delete a number of sessions
	 *@param array $row all the sessions
	 *@return mixed exit if successful, string (error message) if not.
	 *@access public
	 */
	Function do_delete_sessions($row) {
		global $config;

		if (!$this->checked) {
			$tmp .=  lecho("Must be logged...")."<br />\n";
			return $tmp;
		}

		while ($c = each($row)) {
			$sqlc_q = "DELETE FROM ".$config->tables['sessions'].
				 " WHERE id='".addslashes($c[1])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}
		}
		
		header("Location: ".$config->basehref);
		exit;
	
	}	
	
	/**
	 * Change password into DB
	 *@param array fields oldpasswd, newpasswd, newpasswd2
	 *@return mixed exit if successful, string (error message) if not.
	 */
	Function do_change_password($row) {
		global $config;

		if (!$this->checked) {
			$tmp .=  lecho("Must be logged...")."<br />\n";
			return $tmp;
		}

		if (!$this->utils->crypt_dacode($row['oldpasswd'], $this->password)) {
			$tmp .= lecho("Wrong old password!");
			return $tmp;
		}
		if (($row['newpasswd'] != $row['newpasswd2'])
				|| empty ($row['newpasswd'])) {
			$tmp .= lecho("Passwords don't match! Try again...")."<br />\n";
			$tmp .= lecho("Maybe password empty?");
			return $tmp;
		}

		$encrypted_passwd = $this->utils->crypt_dacode($row['newpasswd']);

		$sqlc_q = "UPDATE ".$config->tables['users']." SET passwd='".
			addslashes($encrypted_passwd)."', created=created WHERE id='".
			addslashes($this->user_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}

		if ($config->ldap_hostname) {
			$this->ldap->cd("login=".$this->login.",".$config->ldap_basedn);
			$attrs['userpassword'] = "{crypt}".$encrypted_passwd;
			$this->ldap->modify($attrs);
		}

		header("Location: ".$config->basehref);
		exit;
	}

	/**
	 * Change settigs into DB
	 *@param array fields with settings
	 *@return mixed exit if successful, string (error message) if not.
	 */
	Function do_change_setting ($row) {
		global $config;

		$out = '';

		if (!$this->checked) {
			$tmp .=  lecho("Must be logged...")."<br />\n";
			return $tmp;
		}
		if (!preg_match('/^http:\/\//U',$row['homesite'],$matches) &&
				!empty ($row['homesite'])) {
			echo lecho("Homesite must start with http://");
			exit;
		}

		// If we have supplementary fields, we verify they are not too big
		if (gettype($config->supp_fields) == "array") {
			$table_tmp = array();
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				if (strlen($row[$key]) > $val['max_length']) {
					$out .= "<span class=\"newstext\">-&nbsp;".
						$key.lecho(" can't be that big.").
						lecho(" Sorry."). "</span><br />\n";
				}
			}
		}

		if (strlen($out) > 0) {
			echo $out;
			exit;
		}

		$sqlc_q = "SELECT id FROM ".$config->tables['sig']." WHERE sig='".
				addslashes($row['signature'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}

		if ($this->db->num_rows()==1) {
			$c=$this->db->fetch_array();
			if ($c['id']) {
				$new_sig_id=$c['id'];
			}
			$this->db->free();
		} else {
			$this->db->free();
			if (!$this->utils->html_safe($row['signature'])) {
				return '<br />'.lecho("Invalid &lt; sign in datas");
			}
			$sqlc_q = "INSERT INTO ".$config->tables['sig']." (sig) VALUES ('".
				addslashes($row['signature'])."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				exit;
			}
			$new_sig_id=$this->db->last_insert_id();
		}

		/*
		 * If the user has chosen user boxes
		 */
		if (gettype($config->user_boxes) == "array" &&
			count($config->user_boxes) > 0) {

			reset($config->user_boxes);

			$tmp_boxes = 0;
			$tmp_boxes_array = array();
			while ($cur = current($config->user_boxes)) {
				$key = key($config->user_boxes);

				if (isset ($row['user_'.$key]) ||
						isset ($cur['force']) && $cur['force'] == 1) {

					if (!isset ($cur['force']) ||
						$cur['force'] != 1) {
						$tmp_boxes = 1;
					}

					$tmp_boxes_array[] = $key;
				}
				next($config->user_boxes);
			}

			if ($tmp_boxes) {
				$sqlc_q = "SELECT user_boxes FROM ".
						$config->tables['users_boxes'].
						" WHERE user_id='".addslashes($this->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "<!-- SQL failed: ".$sqlc_q.$this->db->error()." -->";
					return "<span class=\"newstext\">".
						lecho("Something went wrong. ").
						lecho("Please contact the webmaster.")."</span><br />";
				}

				if ($this->db->num_rows() > 0) {
					$c = $this->db->fetch_array();
					$this->user_boxes = unserialize($c['user_boxes']);
					$this->has_user_boxes = 1;
				} else {
					$this->user_boxes = array();
				}
				$this->db->free();

				/*
				 * Already had user boxes. Let's try to not mess up the order
				 */
				if (isset ($this->user_boxes) &&
						gettype($this->user_boxes) == "array" &&
						$this->user_boxes[0] != "") {
					/*
					 * This might look a bit ugly, but the two first
					 * conditions are always true ..
					 *
					 */
					reset($this->user_boxes);

					/*
					 * Probably a little slow ...
					 */
					$tempo_array_old = array();
					reset($tmp_boxes_array);
					$tmp_ok=array();
					while ($cur = current($this->user_boxes)) {
						next($this->user_boxes);

						reset($tmp_boxes_array);
						$tmp_ok[$cur]=0;
						while ($cur2 = current($tmp_boxes_array)) {
							if ($cur2 == $cur) {
								$tempo_array_old[] = $cur;
								$tmp_ok[$cur]=1;
								continue(2);
							}
							next($tmp_boxes_array);
						}
					}
					reset($tmp_boxes_array);
					while ($cur = current($tmp_boxes_array)) {
						if ($tmp_ok[$cur] != 1) {
							$tempo_array_old[]=$cur;
						}
						next($tmp_boxes_array);
					}

					/*
					 * We do modify the order if user has asked for it.
					 */
					reset($tempo_array_old);
					$tempo_array_tmp = array();
					$oldcur="";
					while ($cur = current($tempo_array_old)) {

						$nonext=0;
						if (!next($tempo_array_old)) {
							$nonext = 1;
							$nextkey = "";
							$nextcur = "";
						} else {
							$nextkey = key($tempo_array_old);
							$nextcur = $tempo_array_old[$nextkey];
						}


						if (isset ($row['up_'.$nextcur]) &&
								$row['up_'.$nextcur] == "on") {
							$tempo_array_tmp[] = $nextcur;
							if (empty ($oldcur)) {
								$oldcur = $cur;
							}
							if ($nonext) {
								$tempo_array_tmp[] = $oldcur;
							}
							continue;
						} else {
							if (!empty ($oldcur)) {
								$tempo_array_tmp[] = $oldcur;
								$oldcur = "";
								continue;
							}
							$tempo_array_tmp[] = $cur;
						}
					}

					reset($tempo_array_tmp);
					$sqlc_q = "UPDATE ".$config->tables['users_boxes'].
							" SET user_boxes='".addslashes(serialize($tempo_array_tmp)).
							"' WHERE user_id='".addslashes($this->user_id)."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						echo lecho("SQL Failed: ").$this->db->error();
						exit;
					}

				} else {
					$tmp_serialize = serialize($tmp_boxes_array);

					$sqlc_q = "INSERT INTO ".$config->tables['users_boxes'].
						" VALUES ('".addslashes($this->user_id)."','".
						addslashes($tmp_serialize)."')";
					$ret = $this->db->query($sqlc_q);

					$this->has_user_boxes = 1;
					$this->user_boxes = $tmp_serialize;

					if (!$ret) {
						echo lecho("SQL Failed: ").$this->db->error();
						exit;
					}
				}
			} else {

				if ($this->user_boxes) {
					$sqlc_q = "DELETE FROM ".$config->tables['users_boxes'].
						" WHERE user_id='".addslashes($this->user_id)."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						echo lecho("SQL Failed: ").$this->db->error();
						exit;
					}
				}
			}
		}

		$param = "";
		$param = $param | ($row['identity'] ? pow(2,0) : 0);
		$param = $param | ($row['hide_sig'] ? pow(2,2) : 0);
		$param = $param | ($row['skip_referer'] ? pow(2,3) : 0);
		$param = $param | ($row['no_last_users'] ? pow(2,4): 0);
		$param = $param | ($tmp_boxes ? pow(2,5) : 0);
		$param = $param | ($row['no_board'] ? pow(2,6) : 0);


		if (!$this->utils->html_safe($row)) {
			return '<br />'.lecho("Invalid &lt; sign in datas");
		}
		$sqlc_q = "UPDATE ".$config->tables['users']. " SET ".
			"fname='".addslashes($row['fname'])."',".
			"lname='".addslashes($row['lname'])."',".
			"homesite='".addslashes($row['homesite'])."',".
			"sig_id='".addslashes($new_sig_id)."',".
			"theme='".addslashes($row['theme'])."',".
			"score='".addslashes($row['score'])."',".
			"param='".addslashes($param)."',".
			"created=created WHERE id='".
			addslashes($this->user_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}

		// If we have supplementary fields
		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$table_tmp = array();
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				$table_tmp[$key] = $row[$key];
			}

			reset($table_tmp);
			$tmp_serialize = serialize($table_tmp);

			$sqlc_q = "SELECT user_id FROM ".$config->tables['users_supp'].
				" WHERE user_id='".addslashes($this->user_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				exit;
			}
			if (!$this->utils->html_safe($tmp_serialize)) {
				return '<br />'.lecho("Invalid &lt; sign in datas");
			}
			if ($this->db->num_rows() == '0') {
				$sqlc_q = "INSERT INTO ".$config->tables['users_supp'].
					" (user_id,supp_info) VALUES ('".addslashes($this->user_id)."','".
					addslashes($tmp_serialize)."')";
			} else {
				$sqlc_q = "UPDATE ".$config->tables['users_supp'].
					" set supp_info='". addslashes($tmp_serialize)."' WHERE ".
					"user_id='".addslashes($this->user_id)."'";
			}
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo '<!-- SQL failed: '.$sqlc_q.$this->db->error().' -->';
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
		}
		/// finished supp. fields ///

		// Then we check if real mail has been changed.

		if ($row['email'] != $this->email) {
			$sqlc_q = "SELECT email FROM ".$config->tables['users']." WHERE ".
				"email LIKE '".addslashes($row['email'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo '<!-- SQL failed: '.$sqlc_q.$this->db->error().' -->';
				return '<span class="newstext">'. lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). '</span><br />';
			}

			if ($this->db->num_rows()) {
				echo lecho("Someone else use this mail address already. Please go back and use another one, or click on I forgot my password.");
				exit;
			}
			$tempo_id = $this->utils->makerand(40);

			if (!$this->utils->html_safe($row['email'])) {
				return '<br />'.lecho("Invalid &lt; sign in datas");
			}
			$sqlc_q = "INSERT INTO ".$config->tables['users_tempo'].
			" (user_id,email,tempo_id) ".
				" VALUES ('".addslashes($this->user_id)."','".
				addslashes($row['email']).
				"','".addslashes($tempo_id)."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo '<!-- SQL failed: '.$sqlc_q.$this->db->error().' -->';
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}

			$text = $this->login.
				lecho (" has asked to change the email address from:\n").
				$this->email."\n".lecho("to:\n").$row['email']."\n\n";

			$text .= lecho("For the change to take effect, please visit:\n")."\n".
				$config->baseurl."users/valid.".$config->php."?tempo_id=".
				$tempo_id."\n\n".
				lecho("If you didn't ask this modification, ").
				lecho("please ignore it or contact sysadmin:\n").
				$config->mailadmin;

			if (!$this->utils->send_email($row['email'],
					lecho("Account change"),$text)) {
				return lecho("Error, the email couldn't be send.<br />Perhaps the mail server is not up?");
			}

		}


		if ($config->ldap_hostname) {

			$this->ldap->cd("login=".$this->login.",".$config->ldap_basedn);

			$attrs['lname'] = $row['lname'];
			$attrs['fname'] = $row['fname'];
			$attrs['email'] = $row['email'];
			$attrs['homesite'] = $row['homesite'];
			$attrs['theme'] = $row['theme'];
			$attrs['score'] = $row['score'];

			$this->ldap->modify($attrs);
		}

	}

	/**
	 * Get form to valid a change of user's email
	 *@param mixed integer user's id or empty string
	 *@return string form if success, else error message.
	 */
	Function show_email_form($tempo_id="") {
		global $config;

		$sqlc_q = "SELECT email,user_id FROM ".$config->tables['users_tempo'].
			" WHERE tempo_id='".addslashes($tempo_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
			return "<span class=\"newstext\">". lecho("Something went wrong. ").
				lecho("Please contact the webmaster."). "</span><br />";
		}
		if (!$this->db->num_rows()) {
			return lecho("This id doesn't exist.<br />\n");
		} else {
			$c=$this->db->fetch_array();
			// We fetch the last email address used.
			$sqlc_q = "SELECT email,login FROM ".$config->tables['users']." WHERE ".
				"id='".addslashes($c['user_id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
			if (!$this->db->num_rows()) {
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
			$c_old = $this->db->fetch_array();


			$tmp = "<form method=\"post\" action=\"".
				$config->basehref."users/valid_send.".$config->php."\">".
					"<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\"".
					" width=\"100%\"><tr><td class=\"sboxtext\">".
					lecho("Enter your password to valid the change from ").
				htmlentities($c_old['email']).lecho(" to ").$c['email'].lecho(" for the account ").
				$c_old['login']."</td><td class=\"sboxtext\">".
				"<input type=\"password\" ".
				"name=\"table[password]\" size=\"30\" value=\"\" />".
				"<input type=\"hidden\" name=\"table[tempo_id]\" value=\"".
				htmlentities($tempo_id)."\" /></td></tr>".
				"<tr><td colspan=\"2\" align=\"center\">".
				"<input type=\"submit\" value=\"".lecho("Submit").
				"\" /></td></tr></table></form>";
			return $tmp ;
		}
	}

	/**
	 * Validate the change of a user's email
	 *@param array with users'id, password 
	 *@return string success or error message.
	 */
	Function show_email_valid($tempo_id='') {
		global $config;

		$sqlc_q = "SELECT email,user_id FROM ".$config->tables['users_tempo'].
		" WHERE "."tempo_id='".addslashes($tempo_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
			return "<span class=\"newstext\">". lecho("Something went wrong. ").
				lecho("Please contact the webmaster."). "</span><br />";
		}
		if (!$this->db->num_rows()) {
			return lecho("This id doesn't exist.<br />\n");
		} else {
			$c=$this->db->fetch_array();
			// We fetch the last email address used.
			$sqlc_q = "SELECT passwd,login FROM ".$config->tables['users']." WHERE ".
				"id='".addslashes($c['user_id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
			if (!$this->db->num_rows()) {
				return "<span class=\"newstext\">". lecho("Something went wrong. ").
					lecho("Please contact the webmaster."). "</span><br />";
			}
			$c_old = $this->db->fetch_array();

			if (!$this->utils->html_safe($c['email'])) {
				return '<br />'.lecho("Invalid &lt; sign in datas");
			}
			if ($this->utils->crypt_dacode($row['password'], $c_old['passwd']) == 1) {

				$sqlc_q = "UPDATE ".$config->tables['users']." SET created=created,".
					"email='".addslashes($c['email'])."' WHERE id='".addslashes($c['user_id'])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "!-- SQL failed: $sqlc_q".$this->db->error()." -->";
					return "<span class=\"newstext\">". lecho("Something went wrong. ").
						lecho("Please contact the webmaster."). "</span><br />";
				}
				$sqlc_q = "DELETE FROM ".$config->tables['users_tempo']." WHERE ".
					"user_id='".addslashes($c['user_id'])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
					return "<span class=\"newstext\">". lecho("Something went wrong. ").
						lecho("Please contact the webmaster."). "</span><br />";
				}

				if ($config->ldap_hostname) {

					$this->ldap->cd("login=".$c_old['login'].",".$config->ldap_basedn);
					$attrs['email'] = $c['email'];
					$this->ldap->modify($attrs);
				}

				return lecho("Your email address has been changed...\n");
			} else {
				return lecho("Wrong password...\n");
			}
		}
	}

	/**
	 * Text to read before creating an account.
	 *@return string the message to read.
	 */
	Function create_account_text () {
		return "<span class=\"newstext\"><br />".
			lecho("This form allows you to create an user account.  An user account gives you access to additional features, as choosing your default theme, the summary of all your comments and their answers, and the ability to submit tips.").
			"<br /><br />".
			lecho("The authentication system used is based on cookies.  Neither your login nor your password are stocked on your computer, only an unique id, generated during the validation of the browser's informations, is saved in your cookies. You don't have to type your password each time you visit the site.").
			"<br /><br />".

			lecho("In order to validate your account's application, a message will be sent at the e-mail address you'll give.  It'll give you a random password, and will remind you the login you asked for. You'll then only need to come back here within a week to authenticate yourself, else the account will be deleted.").
			"<br /><br />".

			lecho("Warning, the field called <b>Login</b> must contain from 3 to 20 unmarked letters.").
			"<br /><br /></span>";
	}

	/**
	 * Form to fill to create an account
	 *@param mixed array information to create account or empty string
	 *@return string the form.
	 */
	Function create_account ($table="") {
		global $config;

		if (is_array($table)) {
			return $this->newaccount($table);
		}

		$out = "<form method=\"post\" action=\"".$config->basehref.
			"users/?a=na\">".
			"<table><tr><td class=\"newstext\">".lecho("Login")."</td>".
			"<td class=\"newstext\"><input type=\"text\" ".
			"name=\"table[login2]\" size=\"20\" maxlength=\"20\" /></td>\n".
			"<td class=\"newstext\"><b>".lecho("Mandatory")."</b></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("E-Mail")."</td>".
			"<td class=\"newstext\"><input type=\"text\" ".
			"name=\"table[email]\" size=\"30\" maxlength=\"128\" /></td>".
			"<td class=\"newstext\"><b>".lecho("Mandatory")."</b></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("Last Name").
			"</td><td colspan=\"2\" class=\"newstext\"><input type=\"text\" ".
			"name=\"table[lname]\" size=\"30\" maxlength=\"40\" /></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("First Name").
			"</td><td colspan=\"2\" class=\"newstext\"><input type=\"text\" ".
			"name=\"table[fname]\" size=\"30\" maxlength=\"40\" /></td></tr>\n";

		// If we have supplementary fields
		if (gettype($config->supp_fields) == "array" &&
			count($config->supp_fields) > 0) {
			$out .= "<td colspan=\"3\"><center><hr width=\"50%\"></center></td>";
			reset($config->supp_fields);
			while (list($key,$val) = each($config->supp_fields)) {
				$out .= "<tr><td class=\"newstext\">".ucfirst($key)."</td>\n".
					"<td colspan=\"2\" class=\"newstext\">";
				if ($val['type'] == "text") {
					$out .= "<input type=\"".$val['type']."\" size=\"".
						$val['length']."\" maxlength=\"".
						$val['max_length']."\" name=\"table[".$key."]\" />";
				} elseif ($val['type'] == "textarea") {
					list($cols,$rows) = split (",", $val['length'], 2);
					$out .= "<textarea cols=\"$cols\" ".
					"rows=\"".$rows."\" name=\"table[".$key."]\"></textarea>\n";
				} else {
					$out .= "<input type=\"text\" size=\"".
						$val['length']."\" maxlength=\"".
						$val['max_length']."\" name=\"table[".$key."]\" />";
				}
				$out .= "</td></tr>\n";
			}
		}
		/// finished supp. fields ///

		$out .=	"<tr><td colspan=\"3\" align=\"center\">".
			"<input type=\"submit\" name=\"submit\" value=\"".lecho("Submit").
			"\" /><input type=\"reset\" value=\"".lecho("Cancel").
			"\" /></td></tr></table></form>";

		$out = $this->html->simplebox($this->create_account_text())."<br /><br />".
			$this->html->simplebox($out);
		return $out;
	}

	/**
	 * This function show NEW if the lastseen is older than comments timestamp
	 *@param integer timestamp
	 *@return string html of the NEW symbol
	 */
	Function lastseen_show ($timestamp) {
		if (!$this->checked) {
			return;
		}
		if ($this->lastseen < $timestamp) {
			return '<img src="'.$this->session->imgurl("new").
			'" border="0" alt="'.lecho("NEW").'" />';
		}
	}

	/**
	 * This function show the user boxes
	 *@param string list of boxes separated with ":"
	 */
	Function show_userboxes ($boxes="") {

		global $config;
		if (!empty ($boxes)) {
			$tmp_array = split(":",$boxes);
		} else {
			$tmp_array = array();
		}

		if ($this->session->has_user_boxes &&
			count($this->user_boxes) > 0) {
			reset($this->user_boxes);
			/*
			 * This should probably be optimised
			 */
			while ($cur = current($this->user_boxes)) {
				if (isset ($config->user_boxes[$cur])) {

					$to_eval = $config->user_boxes[$cur]['function'];
					$to_eval = ereg_replace('^\$user','$this',$to_eval);

					eregi('^\$([^-]*)',$to_eval,$f_tmp);
					$f_tmp[2] = ucfirst($f_tmp[1]);

					if ($f_tmp[1] != "this") {
						eval("\$$f_tmp[1] = LoadClass($f_tmp[2]);");
					}
					eval("\$tempo = $to_eval;");

					echo $tempo;

					eregi('^\$([^-]*)',$to_eval,$f_tmp);
					$f_tmp[2] = ucfirst($f_tmp[1]);

					if ($f_tmp[1] != "this") {
						eval("\$$f_tmp[1] = LoadClass($f_tmp[2]);");
					}
				}
				next($this->user_boxes);
			}

		} else {

			if (count($tmp_array) > 0) {
				while ($d = each($tmp_array)) {

					if (empty ($d[1])) {
						continue;
					}

					$to_eval = $config->user_boxes[$d[1]]['function'];
					$to_eval = ereg_replace('^\$user','$this',$to_eval);

					eregi('^\$([^-]*)',$to_eval,$f_tmp);
					$f_tmp[2] = ucfirst($f_tmp[1]);
					if ($f_tmp[1] != "this") {
						eval("\$$f_tmp[1] = LoadClass($f_tmp[2]);");
					}
					eval("\$eval = $to_eval;");
					echo $eval;
				}
			} else {

				reset($config->default_user_boxes);
				while ($d = each($config->default_user_boxes)) {

					$to_eval = $config->user_boxes[$d[1]]['function'];
					$to_eval = ereg_replace('^\$user','$this',$to_eval);

					eregi('^\$([^-]*)',$to_eval,$f_tmp);
					$f_tmp[2] = ucfirst($f_tmp[1]);
					if ($f_tmp[1] != "this") {
						eval("\$$f_tmp[1] = LoadClass($f_tmp[2]);");
					}
					eval("\$eval = $to_eval;");
					echo $eval;
				}
			}

		}
	}

}

?>
