/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.QName;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.OneStepIterator;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XSLProcessorContext {
    private TransformerImpl transformer;
    private Stylesheet stylesheetTree;
    private DTM sourceTree;
    private int sourceNode;
    private QName mode;

    public XSLProcessorContext(TransformerImpl transformerImpl, Stylesheet stylesheet) {
        this.transformer = transformerImpl;
        this.stylesheetTree = stylesheet;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        this.mode = transformerImpl.getMode();
        this.sourceNode = xPathContext.getCurrentNode();
        this.sourceTree = xPathContext.getDTM(this.sourceNode);
    }

    public Node getContextNode() {
        return this.sourceTree.getNode(this.sourceNode);
    }

    public QName getMode() {
        return this.mode;
    }

    public Node getSourceTree() {
        return this.sourceTree.getNode(this.sourceTree.getDocument());
    }

    public Stylesheet getStylesheet() {
        return this.stylesheetTree;
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    public void outputToResultTree(Stylesheet stylesheet, Object object) throws TransformerException, MalformedURLException, FileNotFoundException, IOException {
        try {
            Object object2;
            int n;
            XObject xObject;
            ResultTreeHandler resultTreeHandler = this.transformer.getResultTreeHandler();
            XPathContext xPathContext = this.transformer.getXPathContext();
            if (object instanceof XObject) {
                xObject = (XObject)object;
            } else if (object instanceof String) {
                xObject = new XString((String)object);
            } else if (object instanceof Boolean) {
                xObject = new XBoolean((boolean)((Boolean)object));
            } else if (object instanceof Double) {
                xObject = new XNumber((Double)object);
            } else if (object instanceof DocumentFragment) {
                n = xPathContext.getDTMHandleFromNode((DocumentFragment)object);
                xObject = new XRTreeFrag(n, xPathContext);
            } else if (object instanceof DTM) {
                DTM dTM = (DTM)object;
                object2 = new DescendantIterator();
                object2.setRoot(dTM.getDocument(), xPathContext);
                xObject = new XNodeSet((DTMIterator)object2);
            } else if (object instanceof DTMAxisIterator) {
                DTMAxisIterator dTMAxisIterator = (DTMAxisIterator)object;
                object2 = new OneStepIterator(dTMAxisIterator, -1);
                xObject = new XNodeSet((DTMIterator)object2);
            } else {
                xObject = object instanceof DTMIterator ? new XNodeSet((DTMIterator)object) : (object instanceof NodeIterator ? new XNodeSet(new NodeSetDTM((NodeIterator)object, xPathContext)) : (object instanceof Node ? new XNodeSet(xPathContext.getDTMHandleFromNode((Node)object), xPathContext.getDTMManager()) : new XString(object.toString())));
            }
            n = xObject.getType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    object2 = xObject.str();
                    resultTreeHandler.characters(((String)object2).toCharArray(), 0, ((String)object2).length());
                    break;
                }
                case 4: {
                    int n2;
                    DTMIterator dTMIterator = xObject.iter();
                    while ((n2 = dTMIterator.nextNode()) != -1) {
                        DTM dTM = dTMIterator.getDTM(n2);
                        int n3 = n2;
                        while (n2 != -1) {
                            resultTreeHandler.flushPending();
                            ClonerToResultTree.cloneToResultTree(n2, dTM.getNodeType(n2), dTM, resultTreeHandler, true);
                            int n4 = dTM.getFirstChild(n2);
                            while (n4 == -1) {
                                if (dTM.getNodeType(n2) == 1) {
                                    resultTreeHandler.endElement("", "", dTM.getNodeName(n2));
                                }
                                if (n3 == n2) break;
                                n4 = dTM.getNextSibling(n2);
                                if (n4 != -1 || n3 != (n2 = dTM.getParent(n2))) continue;
                                if (dTM.getNodeType(n2) == 1) {
                                    resultTreeHandler.endElement("", "", dTM.getNodeName(n2));
                                }
                                n4 = -1;
                                break;
                            }
                            n2 = n4;
                        }
                    }
                    break;
                }
                case 5: {
                    resultTreeHandler.outputResultTreeFragment(xObject, this.transformer.getXPathContext());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }
}

