/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public abstract class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    protected transient DTM m_cdtm;
    transient int m_stackFrame = -1;
    private boolean m_isTopLevel = false;
    protected transient int m_last = 0;
    public transient int m_lastFetched = -1;
    transient NodeSetDTM m_cachedNodes;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next;

    protected LocPathIterator(PrefixResolver prefixResolver) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = prefixResolver;
    }

    protected LocPathIterator(Compiler compiler, int n, int n2) throws TransformerException {
        this(compiler, n, n2, true);
    }

    protected LocPathIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        this.setLocPathIterator(this);
    }

    public void allowDetachToRelease(boolean bl) {
        this.m_allowDetach = bl;
    }

    public DTMIterator asIterator(XPathContext xPathContext, int n) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstance();
        locPathIterator.setRoot(n, xPathContext);
        return locPathIterator;
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        DTMIterator dTMIterator = this.m_clones.getInstance();
        int n = xPathContext.getCurrentNode();
        dTMIterator.setRoot(n, xPathContext);
        int n2 = dTMIterator.nextNode();
        dTMIterator.detach();
        return n2;
    }

    public boolean bool(XPathContext xPathContext) throws TransformerException {
        return this.asNode(xPathContext) != -1;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)this.clone();
        locPathIterator.reset();
        return locPathIterator;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            this.m_prefixResolver = null;
            this.m_cdtm = null;
            this.m_clones.freeInstance(this);
        }
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstance();
        int n = xPathContext.getCurrentNode();
        locPathIterator.setRoot(n, xPathContext);
        return new XNodeSet(locPathIterator);
    }

    public int getAxis() {
        return -1;
    }

    public NodeSetDTM getCachedNodes() {
        return this.m_cachedNodes;
    }

    public final int getContext() {
        return this.m_context;
    }

    public final int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    public DTM getDTM(int n) {
        return this.m_execContext.getDTM(n);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public int getLast() {
        return this.getLength();
    }

    /*
     * Unable to fully structure code
     */
    public int getLastPos(XPathContext var1_1) {
        var2_2 = this.m_cachedNodes != null ? this.m_cachedNodes.getCurrentPos() : -1;
        var3_3 = this.m_predicateIndex >= 0 ? this.getProximityPosition() : (this.m_cachedNodes != null ? this.m_cachedNodes.getCurrentPos() : this.m_next);
        try {
            block4: {
                if (var3_3 != 0 || this.m_currentContextNode == -1) break block4;
                var4_4 = (LocPathIterator)this.cloneWithReset();
                ** GOTO lbl14
            }
            var4_4 = (LocPathIterator)this.clone();
            if (true) ** GOTO lbl14
        }
        catch (CloneNotSupportedException v0) {
            return -1;
        }
        do {
            ++var3_3;
lbl14:
            // 3 sources

        } while ((var5_5 = var4_4.nextNode()) != -1);
        if (var2_2 != -1) {
            this.m_cachedNodes.setCurrentPos(var2_2);
        }
        return var3_3;
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = this.m_cachedNodes == null || !this.m_foundLast ? this.getLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public int getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public boolean isNodesetExpr() {
        return true;
    }

    public int item(int n) {
        return this.m_cachedNodes.item(n);
    }

    public abstract int nextNode();

    public int previousNode() {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
    }

    private void resetToCachedList() {
        int n = this.getCurrentPos();
        if (this.m_cachedNodes == null || n != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(n);
    }

    protected int returnNextNode(int n) {
        if (n != -1) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(n);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = n;
        if (n == -1) {
            this.m_foundLast = true;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (var1_1 != -1) ** GOTO lbl-1000
            while ((var2_2 = this.nextNode()) != -1) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if ((var2_3 = this.nextNode()) != -1) continue;
            }
        }
    }

    public final void setCurrentContextNode(int n) {
        this.m_currentContextNode = n;
    }

    public void setCurrentPos(int n) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.setNextPosition(n);
        this.m_cachedNodes.setCurrentPos(n);
    }

    public void setEnvironment(Object object) {
    }

    public void setIsTopLevel(boolean bl) {
        this.m_isTopLevel = bl;
    }

    public void setItem(int n, int n2) {
        this.m_cachedNodes.setElementAt(n, n2);
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    protected void setNextPosition(int n) {
        this.m_next = n;
    }

    public void setRoot(int n, Object object) {
        XPathContext xPathContext;
        this.m_context = n;
        this.m_execContext = xPathContext = (XPathContext)object;
        this.m_cdtm = xPathContext.getDTM(n);
        this.m_currentContextNode = n;
        this.m_prefixResolver = xPathContext.getNamespaceContext();
        if (this.m_isTopLevel) {
            this.m_stackFrame = xPathContext.getVarStack().getStackFrame();
        }
        this.reset();
    }

    public void setShouldCacheNodes(boolean bl) {
        if (bl) {
            if (this.m_cachedNodes == null) {
                this.m_cachedNodes = new NodeSetDTM(this.getDTMManager());
            }
        } else {
            this.m_cachedNodes = null;
        }
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

