/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * init_fnc.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: init_fnc.c,v 1.13 2003/12/30 09:00:18 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/file.h>
#include <signal.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <linux/sem.h>		/* for the value of SEMVMX */
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <gnome.h>

#include "misc_gtk.h"
#include "init_fnc.h"
#include "main.h"
#include "do_connect.h"
#include "dctc_process.h"
#include "status.h"
#include "gui_layout.h"
#include "bookmark.h"
#include "bdb.h"
#include "gdl_ctree.h"
#include "gui_define.h"
#include "find_result_clist.h"
#include "user_file_list_clist.h"
#include "shared_dir_clist.h"
#include "gtk_helper.h"
#include "custom_hublist_tree.h"
#include "callbacks.h"
#include "global_user.h"

/**************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one */
/**************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		gchar *str;

		gtk_tree_model_get(gtm,iter,column_number,&str,-1);

		if((str!=NULL)&&(!strcmp(string,str)))
		{
			g_free(str);
			return TRUE;
		}
		if(str)
			g_free(str);

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/*********************************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one (case insensitive) */
/*********************************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string_nocase(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		gchar *str;

		gtk_tree_model_get(gtm,iter,column_number,&str,-1);

		if((str!=NULL)&&(!strcasecmp(string,str)))
		{
			g_free(str);
			return TRUE;
		}
		if(str)
			g_free(str);

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/*************************************************************************************/
/* search in the given treemodel, in the given column a value matching the given one */
/*************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_ulong(GtkTreeModel *gtm, int column_number, const unsigned long value, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		unsigned long v;

		gtk_tree_model_get(gtm,iter,column_number,&v,-1);

		if(v==value)
			return TRUE;

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/***************************************************/
/* check if the given gtk_tree_model contains rows */
/***************************************************/
/* output: TRUE: yes, FALSE: no, it is empty */
/*********************************************/
int gtk_tree_model_is_not_empty(GtkTreeModel *gtm)
{
	GtkTreeIter iter;

	return gtk_tree_model_get_iter_first(gtm,&iter);
}



GtkStyle *fast_style=NULL;				/* style for fast user */

/* name of the label widget of each private chat (UTF8 content) */
char *lbl_chat[]={"pchat_label1", "pchat_label2", "pchat_label3",
						"pchat_label4", "pchat_label5", "pchat_label6",
						"pchat_label7", "pchat_label8", "pchat_label9"};

/* name of the text widget of each private chat */
char *chat_text[]={	"chat1_text", "chat2_text", "chat3_text",
							"chat4_text", "chat5_text", "chat6_text",
							"chat7_text", "chat8_text", "chat9_text"};

/* nickname of the user of each private chat (original format) */
GString *gstr_chat[]={NULL,NULL,NULL,
								NULL,NULL,NULL,
								NULL,NULL,NULL};

/********************************************************************************************************************/
/* the following function makes some adjustements that cannot be done inside glade (or I don't know how to do them) */
/********************************************************************************************************************/
void init_clist(void)
{
	GtkWidget *w;
	int i;

	/* create tags for private chat */
	/* and perform all other initializations on private chat  */
	for(i=0;i<9;i++)
	{
		GtkTextBuffer *gtb;
		GtkTextIter iter;

		w=get_widget_by_widget_name(main_window,chat_text[i]);
		gtb=gtk_text_view_get_buffer(GTK_TEXT_VIEW(w));
		gtk_text_buffer_create_tag(gtb,"timestamp","foreground","lightgrey",NULL);
		gtk_text_buffer_create_tag(gtb,"nickname","foreground","red","weight",PANGO_WEIGHT_BOLD,NULL);

		gtk_text_buffer_get_end_iter(gtb,&iter);					/* create an end mark */
		gtk_text_buffer_create_mark(gtb,"end",&iter,FALSE);

		/* initialize the default nickname */
		gstr_chat[i]=g_string_new("");			/* create an empty string */

		w=get_widget_by_widget_name(main_window,lbl_chat[i]);
		gtk_label_set(GTK_LABEL(w),_("empty"));
	}

	/* and also for public chat */
	{
		GtkTextBuffer *gtb;
		GtkTextIter iter;

		w=get_widget_by_widget_name(main_window,"chat_output");
		gtb=gtk_text_view_get_buffer(GTK_TEXT_VIEW(w));

		gtk_text_buffer_create_tag(gtb,"timestamp","foreground","lightgrey",NULL);
		gtk_text_buffer_create_tag(gtb,"nickname","foreground","red","weight",PANGO_WEIGHT_BOLD,NULL);

		gtk_text_buffer_get_end_iter(gtb,&iter);					/* create an end mark */
		gtk_text_buffer_create_mark(gtb,"end",&iter,FALSE);
	}

	/* and also on the error message area */
	{
		GtkTextBuffer *gtb;
		GtkTextIter iter;

		w=get_widget_by_widget_name(main_window,"error_messages_text");
		gtb=gtk_text_view_get_buffer(GTK_TEXT_VIEW(w));

		gtk_text_buffer_create_tag(gtb,"timestamp","foreground","lightgrey",NULL);

		gtk_text_buffer_get_end_iter(gtb,&iter);					/* create an end mark */
		gtk_text_buffer_create_mark(gtb,"end",&iter,FALSE);
	}

#if 0
	load_all_done_lists();
#endif

	w=get_widget_by_widget_name(main_window,"find_history_combo");
	if(w)
	{
		gtk_combo_disable_activate(GTK_COMBO(w));
	}

	load_profile_name_combo();

	sync_hidden_entry_with_share_list();
	sync_hidden_planar_hublist_with_custom_hublist_treeview();
}

/***********************************************/
/* load the combo containing all profile names */
/***********************************************/
void load_profile_name_combo(void)
{
	GtkWidget *w;

	w=get_widget_by_widget_name(main_window,"profile_name_combo");
	if(w)
	{
		void *iter;
		GList *glst=NULL;
		GStringChunk *gsc=g_string_chunk_new(32);

		/* we must get all kets: "/PROGNAME/ProfileNames/" */
		iter=gnome_config_init_iterator("/" PROGNAME "/ProfileNames/");
		while(iter!=NULL)
		{
			char *prof_name=NULL;
			char *buf=NULL;
			
			iter=gnome_config_iterator_next(iter,&prof_name,&buf);
			if(iter!=NULL)
			{
				/* prof_name is the profile name, buf is unused */
				if((prof_name!=NULL)&&(strlen(prof_name)))
				{
					glst=g_list_append(glst,g_string_chunk_insert(gsc,prof_name));
				}
			}
		}

		if(glst!=NULL)
		{
			gtk_combo_set_popdown_strings(GTK_COMBO(w),glst);
			g_list_free(glst);
		}
		g_string_chunk_free(gsc);
	}
}

typedef struct
{
	char *widget_name;
	char *var_name;
} LNK;

static void set_tos_string(char *widget_name, int tos_value)
{
	char *t;

	switch(tos_value)
	{
		case 2:	t=_("Low Cost");
					break;
		case 4:	t=_("High Reliability");
					break;
		case 8:	t=_("High Throughput");
					break;
		case 16:	t=_("Low Latency");
					break;

		default:	fprintf(stderr,"Unknown tos value: %d for %s\n",tos_value,widget_name);
		case 0:	t=_("Normal");
					break;
	}

	gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,widget_name)), t);
}

/************************************************************/
/* set all fields of preference_box according to vars value */
/************************************************************/
void fix_pref_window(void)
{
	static const LNK v[]={	{"nickname_entry","nickname"},
								{"user_description_entry","user_desc"},
								{"cnx_type_entry","cnx_type"},
								{"e_mail_entry","email"},
								{"incoming_port_number_entry","com_port"},
								{"xfer_host_ip_entry","hostip"},
								{"dl_dir_entry","dl_path"},
								{"socks_address_entry","socks_ip"},
								{"socks_port_entry","socks_port"},
								{"socks_userid_entry","socks_name"},
								{"unodeport_entry","unode_port"},
								{"min_gdl_wake_up_delay_entry","min_gdl_wake_up_delay"},
								{"vshare_dir_entry","vshare_dir"},
								{"lmule_temp_entry","gdl_met_dir"},
								{"fake_dcpp_version_entry","fake_dcpp_version"},
								{NULL,NULL}};

	static const LNK tgl_bt[]={	{"enable_upload_checkbutton","dl_on"},
											{"follow_forcemove_checkbutton","follow_force_move"},
											{"use_done_dir_checkbutton","when_done"},
											{"ddl_checkbutton","with_ddl"},
											{"hide_kick_checkbutton","hide_kick"},
											{"abort_upload_checkbutton","abort_upload_when_user_leaves"},
											{"lazykc_checkbutton","lazy_key_check"},
											{"incoming_wake_up_checkbutton","with_incoming_wake_up"},
											{"sr_wake_up_checkbutton","with_sr_wake_up"},
											{"dynipcheckbutton","dynamic_ip"},
											{"sharelist_dl_checkbutton","sharelist_dl"},
											{"fake_dcpp_checkbutton","fake_dcpp_client"},
										{NULL,NULL}};

	int i;
	const char *t;

	/* initialize gtk entry from base */
	i=0;
	while(v[i].widget_name!=NULL)
	{
		t=get_var(v[i].var_name);
		if(t!=NULL)
		{
			if(utf8_mode==TRUE)
				set_gtk_entry_by_name(main_window,v[i].widget_name,t);
			else
			{
				gchar *utf8;
				utf8=g_locale_to_utf8(t,-1,NULL,NULL,NULL);
				set_gtk_entry_by_name(main_window,v[i].widget_name,utf8);
				g_free(utf8);
			}
		}
		else
		{
			if(current_dctc!=NULL)
				gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,v[i].widget_name)), "");
		}
		i++;
	}

	/* adjust toggle buttons */
	i=0;
	while(tgl_bt[i].widget_name!=NULL)
	{
		t=get_var(tgl_bt[i].var_name);
		if(t!=NULL)
		{
			gtk_toggle_button_set_active(
							GTK_TOGGLE_BUTTON(
									get_widget_by_widget_name(main_window,tgl_bt[i].widget_name)),
							atoi(t));
		}
		i++;
	}

	t=get_var("offset");
	if(t!=NULL)
	{
		double val;
		double scale[4]={1.0,1024.0, 1024.0*1024.0, 1024.0*1024.0*1024.0};
		char *unit_name[4]={_("Bytes"), _("KBytes"), _("MBytes"), _("GBytes")};
		int i=0;
		char buf[512];

		val=strtod(t,NULL);

		while(i<3)
		{
			double res,ent;

			res=modf(val/scale[i+1],&ent);
			if(res!=0.0)
				break;
			i++;
		}

		gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,"size_offset_unit_entry")), unit_name[i]);
		sprintf(buf,"%.0f",val/scale[i]);
		gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,"size_offset_entry")), buf);
		
	}

	/* adjust range */
	{
		static const LNK range_val[]={ {"sim_dl_hscale","dl_slot"},
												 {"reconnect_delay_scale","recon_delay"},
												 {"rebuild_delay_scale","auto_rebuild_delay"},
												 {NULL,NULL}};
												
		i=0;
		while(range_val[i].widget_name!=NULL)
		{
			t=get_var(range_val[i].var_name);
			if(t!=NULL)
			{
				gtk_adjustment_set_value(
							gtk_range_get_adjustment(GTK_RANGE(
									get_widget_by_widget_name(main_window,range_val[i].widget_name))),
							atoi(t));
			}
			i++;
		}
	}

	/* adjust spin button */
	{
		static const LNK spin_bt[]={ {"maxrunspinbutton","max_running_source_per_gdl"},
											  {"maxudl_spinbutton","max_dl_per_user"},
											  {"maxasoffspinbutton","disable_gdl_as_when_enough_running"},
											  {"min_delay_between_search_spinbutton","min_delay_between_search"},
											  {"lmule_scan_spinbutton","gdl_met_poll"},
											  {NULL,NULL}};
												
		i=0;
		while(spin_bt[i].widget_name!=NULL)
		{
			t=get_var(spin_bt[i].var_name);
			if(t!=NULL)
			{
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(
									get_widget_by_widget_name(main_window,spin_bt[i].widget_name)),
							atoi(t));
			}
			i++;
		}
	}


	t=get_var("behind_fw");
	if(t!=NULL)
	{
		if(atoi(t)==1)
		{
			gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(
								get_widget_by_widget_name(main_window,"passive_mode_radio_button")),
						TRUE);
		}
		else
		{
			gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(
								get_widget_by_widget_name(main_window,"active_mode_radio_button")),
						TRUE);
		}
	}

	{
		t=get_var("ul_path");
		if(t!=NULL)
		{	
			/* we put its value into "hidden_shared_dir_entry" so it will be saved */
			set_gtk_entry_by_name(main_window,"hidden_shared_dir_entry",t);
			sync_hidden_entry_with_share_list();
		}
	}

   /* set xbl values */
   {
      struct
      {
         char *cmd_name;
         char *check_widget;
         char *val_widget;
      } sema_bl[]={  {"ubl","ubl_checkbutton","ubl_entry"},
                     {"dbl","dbl_checkbutton","dbl_entry"},
                     {"gbl","gbl_checkbutton","gbl_entry"},
                     {NULL,NULL,NULL}};

      i=0;
      while(sema_bl[i].cmd_name!=NULL)
      {
			t=get_var(sema_bl[i].cmd_name);
			if(t!=NULL)
			{
				if(atoi(t)==SEMVMX)
				{
					gtk_toggle_button_set_active(
									GTK_TOGGLE_BUTTON(
											get_widget_by_widget_name(main_window,sema_bl[i].check_widget)),FALSE);
				}
				else
				{
					gtk_toggle_button_set_active(
									GTK_TOGGLE_BUTTON(
											get_widget_by_widget_name(main_window,sema_bl[i].check_widget)),TRUE);
					gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,sema_bl[i].val_widget)), t);
				}
			}
			i++;
		}
	}

	t=get_var("cnx_opt");
	if(t!=NULL)
	{
		unsigned int v=atoi(t);

		gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(
								get_widget_by_widget_name(main_window,"away_togglebutton")),
						((v&2)?TRUE:FALSE));
	}

	t=get_var("cnx_status");
	if(t!=NULL)
	{
		/* we have a connection status */
		GtkWidget *w;

		w=get_widget_by_widget_name(main_window,"appbar1");
		if(w!=NULL)
		{
			unsigned int a;

			a=atoi(t);
		
			gnome_appbar_clear_stack(GNOME_APPBAR(w));

			switch(a&3)
			{
				case 3:	/* green, connection established */
							gnome_appbar_set_status(GNOME_APPBAR(w),_("Online"));
							break;
						
				case 1:	/* orange, connection in progress */
							gnome_appbar_set_status(GNOME_APPBAR(w),_("Trying to establish connection with hub"));
							break;

				default:	/* red, connection lost */
				case 2:
				case 0:
							t=get_var("main_sck");
							if((t==NULL)||(t[0]!='=')||(t[1]!='>'))
							{
								gnome_appbar_set_status(GNOME_APPBAR(w),"Offline");
							}
							else
							{
								char buf_time[512];
								struct tm tm;
								GString *rcn_msg;
								time_t tt;

								tt=atoi(t+2);
								localtime_r(&tt,&tm);
								strftime(buf_time,sizeof(buf_time)-1,"%c",&tm);

								rcn_msg=g_string_new(_("Offline, reconnect time: "));
								rcn_msg=g_string_append(rcn_msg,buf_time);

								gnome_appbar_set_status(GNOME_APPBAR(w),rcn_msg->str);

								g_string_free(rcn_msg,TRUE);
							}
							w=get_widget_by_widget_name(main_window,"user_clist");
							if(w!=NULL)
							{
								GtkTreeModel *gtm;
								gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w));
								gu_unref_model(gtm);
								gtk_list_store_clear(GTK_LIST_STORE(gtm));
							}
							break;
			}
		}
	}

	{
		GtkWidget *w;

		w=get_widget_by_widget_name(main_window,"current_hub_address_label");

		if(w!=NULL)
		{
			t=get_var("hub_addr");
			if(t==NULL)
			{
				gtk_label_set(GTK_LABEL(w),"");
			}
			else
			{
				gtk_label_set(GTK_LABEL(w),t);
			}
		}
	}
	{
		GtkWidget *w;

		w=get_widget_by_widget_name(main_window,"dctc_version_label");

		if(w!=NULL)
		{
			t=get_var("version");
			if(t==NULL)
			{
				gtk_label_set(GTK_LABEL(w),"");
			}
			else
			{
				gtk_label_set(GTK_LABEL(w),t);
			}
		}
	}
	{
		GtkWidget *w;

		w=get_widget_by_widget_name(main_window,"curhostip_var_label");

		if(w!=NULL)
		{
			t=get_var("curhostip");
			if(t==NULL)
			{
				gtk_label_set(GTK_LABEL(w),"");
			}
			else
			{
				gtk_label_set(GTK_LABEL(w),t);
			}
		}
	}


	t=get_var("tos");
	if(t!=NULL)
	{
		unsigned int hub_tos,udp_tos,dl_tos,ul_tos;

		if(sscanf(t,"%u,%u,%u,%u",&hub_tos,&udp_tos,&dl_tos,&ul_tos)!=4)
		{
			fprintf(stderr,"Invalid \"tos\" variable, 4 values are required and '%s' is given.\n",t);
		}
		else
		{
			set_tos_string("hub_tos_entry",hub_tos);
			set_tos_string("udp_tos_entry",udp_tos);
			set_tos_string("dl_tos_entry",dl_tos);
			set_tos_string("ul_tos_entry",ul_tos);
		}
	}

	t=get_var("gdlasports");
	if(t!=NULL)
	{
		unsigned int low,up;

		sscanf(t,"%u:%u",&low,&up);

		if(low==0)
		{
			gtk_toggle_button_set_active(
							GTK_TOGGLE_BUTTON(
									get_widget_by_widget_name(main_window,"limit_as_port_checkbutton")),FALSE);
		}
		else
		{
			gtk_toggle_button_set_active(
							GTK_TOGGLE_BUTTON(
									get_widget_by_widget_name(main_window,"limit_as_port_checkbutton")),TRUE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(
								get_widget_by_widget_name(main_window,"low_as_port_spinbutton")),
								low);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(
								get_widget_by_widget_name(main_window,"up_as_port_spinbutton")),
								up);
		}
	}
	else
	{
		gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(
								get_widget_by_widget_name(main_window,"limit_as_port_checkbutton")),FALSE);
	}
}

static gboolean autostart_client_if_has_autoflag(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
	char *flags;
	char *bg;
	int ret=FALSE;

	gtk_tree_model_get(model,iter,FHC_FLAGS,&flags,FHC_LINE_BACKGROUND,&bg,-1);
	if( (bg==NULL) || ((bg!=NULL)&&(strcmp(bg,"green"))) )
	{
		/* green row are running one */
		if((flags)&&(flag_is_set(flags,AUTOSTART_FLAG)))
		{
			char *col;
			char *prof_name;
	
			gtk_tree_model_get(model,iter,FHC_PROFILE,&prof_name,FHC_HUB_ADDR_COL,&col,-1);

			if((prof_name==NULL)||(strlen(prof_name)==0))
				start_a_new_dctc(col,1,NULL);
			else
				start_a_new_dctc(col,1,prof_name);

			free(col);
			free(prof_name);

			ret=TRUE;	/* don't start more than one client at the same time */
		}
	}
	if(flags)
		free(flags);
	if(bg)
		free(bg);

	return ret;
}

gint favorite_client_periodic_autostart(gpointer data)
{
	GtkWidget *rhcw;

	if(auto_start_disabled==TRUE)		/* auto start client is disabled */
		return TRUE;
	
	rhcw=get_widget_by_widget_name(main_window,"hub_favorite_clist");
	if(rhcw==NULL)
		return TRUE;
	gtk_tree_model_foreach(gtk_tree_view_get_model(GTK_TREE_VIEW(rhcw)),autostart_client_if_has_autoflag,NULL);

	return TRUE;	/* don't stop periodic calling */
}


static void process_one_cmd_row(const char *cmd_line)
{
	if(!strncmp(cmd_line,"ed2k://|file|",strlen("ed2k://|file|")))
	{
		process_ed2k_file_url(cmd_line);
	}
	else
	{
		fprintf(stderr,"Unsupported command: '%s'\n",cmd_line);
	}
}

/************************************************************************/
/* check periodically the .dc_gui2.cmd file to process incoming command */
/************************************************************************/
gint cmd_file_check(gpointer data)
{
	int fd;

	if(current_dctc!=NULL)
	{	/* process file only if we are connected to a client */
		fd=open(dc_gui2_cmdfile->str,O_RDWR);	/* don't create the file */
		if(fd!=-1)
		{
			if(flock(fd,LOCK_EX|LOCK_NB)==0)
			{
				struct stat st;

				if((fstat(fd,&st)==0)&&(st.st_size!=0))
				{
					char *c;

					c=malloc(st.st_size+1);
					if(c!=NULL)
					{
						if(read(fd,c,st.st_size)==st.st_size)
						{
							gchar **rows;
							int i;

							c[st.st_size]='\0';
							
							rows=g_strsplit(c,"\n",0);
							i=0;
							while(rows[i]!=NULL)
							{
								process_one_cmd_row(rows[i]);
								i++;
							}
							g_strfreev(rows);
							ftruncate(fd,0);		/* clear the .cmd file */
						}
						free(c);
					}
				}
				flock(fd,LOCK_UN);
			}
			close(fd);
		}
	}
	return TRUE;	/* don't stop periodic calling */
}

/************************************************/
/* initialize the user pref with default values */
/************************************************/
void load_default_profile_parameters(void)
{
	static const char *string2clear[]={
													/* identity and connection" */
													"nickname_entry","e_mail_entry","user_description_entry",
													"hidden_shared_dir_entry","xfer_host_ip_entry","socks_proxy_version_combo_entry",
													"socks_address_entry","socks_userid_entry","socks_port_entry",
													"socks_user_passwd_entry","hublist_cnxtype_entry","web_proxy_host_entry",
													"web_proxy_port_entry",

													/* shares */
													"dl_dir_entry","vshare_dir_entry","size_offset_entry",

													/* misc extra param. */
													"version_number_entry","unodeport_entry","fake_dcpp_version_entry",

													/* extra Param. (DL)*/
													"dbl_entry",

													/* extra Param. (GDL) */
													"gbl_entry",

													/* extra Param. (UL) */
													"ubl_entry",

													NULL
													};

	static const char *string2preset[][2]={
														{"cnx_type_entry","28.8Kbps"},
														{"incoming_port_number_entry","412"},
														{"size_offset_unit_entry","GBytes"},
														{"min_gdl_wake_up_delay_entry","30"},
														{"hub_tos_entry","Normal"},
														{"udp_tos_entry","Normal"},
														{"dl_tos_entry","Normal"},
														{"ul_tos_entry","Normal"},
														{NULL,NULL}
													  };

	static const char *toggle2set[]={
												"enable_upload_checkbutton",
												"active_mode_radio_button",
												"ignore_ipcheckbutton",
												"dynipcheckbutton",
												"abort_upload_checkbutton",
												"grabip_checkbutton",
												"hide_kick_checkbutton",
												"use_done_dir_checkbutton",
												"ddl_checkbutton",
												"lazykc_checkbutton",
												"incoming_wake_up_checkbutton",
												"sr_wake_up_checkbutton",
												"sharelist_dl_checkbutton",
												NULL
												};

	static const char *toggle2clear[]={
												"follow_forcemove_checkbutton",
												"dbl_checkbutton",
												"limit_as_port_checkbutton",
												"gbl_checkbutton",
												"ubl_checkbutton",
												"add_tag_checkbutton",
												"fake_dcpp_checkbutton",
												NULL
												};
	int i;

	/* initialize the entries to clear */
	i=0;
	while(string2clear[i]!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,string2clear[i])),"");
		i++;
	}

	/* initialize the entries to clear */
	i=0;
	while(string2preset[i][0]!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(get_widget_by_widget_name(main_window,string2preset[i][0])),string2preset[i][1]);
		i++;
	}

	/* initialize the togglebutton to set */
	i=0;
	while(toggle2set[i]!=NULL)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,toggle2set[i])),TRUE);
		i++;
	}

	/* initialize the togglebutton to clear */
	i=0;
	while(toggle2clear[i]!=NULL)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,toggle2clear[i])),FALSE);
		i++;
	}


	/* misc initialization */
	sync_hidden_entry_with_share_list();	/* sync the share list with its hidden entry */
	sync_hidden_planar_hublist_with_custom_hublist_treeview();

	gtk_range_set_value(GTK_RANGE(get_widget_by_widget_name(main_window,"sim_dl_hscale")),3);
	gtk_range_set_value(GTK_RANGE(get_widget_by_widget_name(main_window,"reconnect_delay_scale")),30);
	gtk_range_set_value(GTK_RANGE(get_widget_by_widget_name(main_window,"rebuild_delay_scale")),60);
	

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"min_delay_between_search_spinbutton")),10);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"running_client_list_refresh_rate_spinbutton")),5);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"favorite_client_autostart_check_rate_spinbutton")),5);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"low_as_port_spinbutton")),1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"up_as_port_spinbutton")),65535);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"maxrunspinbutton")),3);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"maxasoffspinbutton")),2);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"maxudl_spinbutton")),1);

	/* load default lmule directory */
	on_lmule_default_temp_dir_button_clicked(NULL,NULL);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(get_widget_by_widget_name(main_window,"lmule_scan_spinbutton")),10);
}


